/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.es.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dts.RowInfo;
import kd.bos.dts.impl.fulltext.Mapper;
import kd.bos.dts.multientity.MultiEntity;
import kd.bos.exception.KDException;
import kd.bos.ext.hr.es.api.common.util.EsCommonUtils;
import kd.bos.ext.hr.es.api.storage.EsStorage;
import kd.bos.ext.hr.es.me.common.EsStrageBaseHelper;
import kd.bos.ext.hr.es.me.constants.EnumDataChangeType;
import kd.bos.ext.hr.es.me.dao.EntityEsConfigService;
import kd.bos.ext.hr.es.me.importdata.impl.EsBatchImportData;
import kd.bos.ext.hr.es.me.importdata.impl.EsIncrementDataProcess;
import kd.bos.ext.hr.es.me.utils.AsynDeleteIndex;
import kd.bos.ext.hr.exception.ExtHrErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import org.apache.commons.collections.CollectionUtils;

public class EsCommonMapper
implements Mapper {
    protected static ExecutorService executorService = ThreadPools.newCachedExecutorService((String)"EsCommonMapper-DeleteIndex-Thread", (int)1, (int)2);
    private static final Log logger = LogFactory.getLog(EsCommonMapper.class);
    private String multientityname;

    public Map<?, ?> convert2Es(String arg0, RowInfo arg1) {
        return null;
    }

    public String getESDataType() {
        return null;
    }

    public String getFieldStoredName(String arg0, String arg1) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RowInfo> preHandle(List<RowInfo> rowInfoList) {
        String strSymbol;
        if (CollectionUtils.isEmpty(rowInfoList) || StringUtils.isEmpty((CharSequence)this.multientityname)) {
            return null;
        }
        RowInfo firstRowInfo = rowInfoList.get(0);
        if (firstRowInfo == null) {
            return null;
        }
        String tableName = firstRowInfo.getTable();
        int length = tableName.length();
        if (length > 3 && "_".equals(strSymbol = tableName.substring(length - 2, length - 1))) {
            return null;
        }
        String dataChangeType = firstRowInfo.getType();
        String entityNumber = firstRowInfo.getEntityNumber();
        if (entityNumber == null) {
            entityNumber = this.getMultiEntity().getMainEntityNumber(null);
        }
        boolean isBatchImportData = true;
        ArrayList<Object> idList = new ArrayList<Object>();
        for (RowInfo rowInfo : rowInfoList) {
            if (isBatchImportData && !EnumDataChangeType.NEW.getType().equals(dataChangeType)) {
                isBatchImportData = false;
            }
            idList.add(rowInfo.getKeyObject());
        }
        if (CollectionUtils.isNotEmpty(idList)) {
            try {
                CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
                if (isBatchImportData && idList.size() > 1) {
                    EsBatchImportData esBatchImportData = EsBatchImportData.getInstance();
                    esBatchImportData.batchImportData(this.multientityname, idList);
                    logger.info("Batch import data success! query entity name:{}, data change type:{}, batch size:{}", new Object[]{this.multientityname, dataChangeType, idList.size()});
                } else {
                    EsIncrementDataProcess esIncrementDataProcess = EsIncrementDataProcess.getInstance();
                    esIncrementDataProcess.proccessMessageToEs(this.multientityname, entityNumber, dataChangeType, idList);
                    logger.info("Increment import data success! query entity name:{}, data change type:{}, entity number:{}, id:{}", new Object[]{this.multientityname, dataChangeType, entityNumber, idList.get(0)});
                }
            }
            finally {
                CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)false);
            }
        }
        return null;
    }

    public String getKeyId(RowInfo arg0) {
        return null;
    }

    public String getIndexName(String arg0) {
        return null;
    }

    public void setRegion(String arg0) {
    }

    public MultiEntity getMultiEntity() {
        return new MyMultiEntity();
    }

    public void endInit(String opType, String entityNumber) {
        if (StringUtils.isEmpty((CharSequence)this.multientityname) || StringUtils.isEmpty((CharSequence)opType)) {
            return;
        }
        if (!opType.equals("insert")) {
            return;
        }
        EsStorage storage = EsStrageBaseHelper.init();
        String aliasName = EsCommonUtils.getIndexAliasName("hr", this.multientityname);
        DynamicObject dyReleaseInfo = EntityEsConfigService.getEsSyncSchemeConfig(this.multientityname);
        int version = dyReleaseInfo.getInt("version");
        String indexName = EsCommonUtils.getIndexName("hr", this.multientityname, version);
        storage.removeAndAddAliases(indexName, aliasName);
        String msg = "";
        try {
            try (TXHandle handle = TX.requiresNew();){
                msg = (String)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHBSSEsReleaseStatusService", (String)"esDataImproted", (Object[])new Object[]{this.multientityname});
            }
            logger.info("Invoke RPC service success! cloudId:{},appId:{},serviceName:{}, methodName:{} ,parameter:{},error message:{}", new Object[]{"hrmp", "hrcs", "IHBSSEsReleaseStatusService", "esDataImproted", this.multientityname, msg});
            String indexPrefix = EsCommonUtils.getIndexAliasName("hr", this.multientityname);
            executorService.execute(ThreadLifeCycleManager.wrapRunnable((Runnable)new AsynDeleteIndex(storage, indexPrefix, version)));
            logger.info("delete index {}", (Object)(indexPrefix + version));
        }
        catch (Exception e) {
            logger.error("Invoke RPC service error! cloudId:{},appId:{},serviceName:{}, methodName:{} ,parameter:{},error message:{}", new Object[]{"hrmp", "hrcs", "IHBSSEsReleaseStatusService", "esDataImproted", this.multientityname, msg});
            throw new KDException(ExtHrErrorCode.extHrException, new Object[]{"invoke RPC service error!"});
        }
    }

    class MyMultiEntity
    implements MultiEntity {
        MyMultiEntity() {
        }

        public String getMainEntityNumber(String entityNumber) {
            String queryFormId = MetadataDao.getIdByNumber((String)EsCommonMapper.this.multientityname, (MetaCategory)MetaCategory.Form);
            if (StringUtils.isEmpty((CharSequence)queryFormId)) {
                return null;
            }
            EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readMeta((String)queryFormId, (MetaCategory)MetaCategory.Entity);
            QueryEntity queryEntity = (QueryEntity)entityMeta.getRootEntity();
            return queryEntity.getEntityName();
        }

        public boolean isMainEntity(String entityNumber) {
            if (StringUtils.isEmpty((CharSequence)entityNumber)) {
                return false;
            }
            return entityNumber.equals(this.getMainEntityNumber(entityNumber));
        }
    }
}

