/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.es.me.importdata.impl;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.es.api.EsBatchValue;
import kd.bos.ext.hr.es.api.common.util.EsCommonUtils;
import kd.bos.ext.hr.es.api.storage.EsStorage;
import kd.bos.ext.hr.es.me.common.EncryptionBusinessDataServiceHelper;
import kd.bos.ext.hr.es.me.common.EsStrageBaseHelper;
import kd.bos.ext.hr.es.me.importdata.IEsBatchImportData;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.orm.util.CollectionUtils;

public class EsBatchImportData
implements IEsBatchImportData {
    private static volatile EsBatchImportData esBatchImportData = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EsBatchImportData getInstance() {
        if (esBatchImportData != null) return esBatchImportData;
        Class<EsBatchImportData> clazz = EsBatchImportData.class;
        synchronized (EsBatchImportData.class) {
            if (esBatchImportData != null) return esBatchImportData;
            esBatchImportData = new EsBatchImportData();
            // ** MonitorExit[var0] (shouldn't be in output)
            return esBatchImportData;
        }
    }

    @Override
    public void batchImportData(String queryEntityName, List<Object> idList) {
        QueryEntity queryEntity = EsStrageBaseHelper.getQueryEntity(queryEntityName);
        if (queryEntity == null) {
            throw new KDBizException("QueryEntity[" + queryEntityName + "] not exists");
        }
        EsStorage storage = EsStrageBaseHelper.init();
        List<EsBatchValue> batchValue = this.buildBatchValue(queryEntity, queryEntityName, idList);
        if (CollectionUtils.isEmpty(batchValue)) {
            return;
        }
        String indexName = EsCommonUtils.getIndexName("hr", queryEntityName);
        storage.batchSave(indexName, "t_data", batchValue.toArray(new EsBatchValue[batchValue.size()]));
    }

    private List<EsBatchValue> buildBatchValue(QueryEntity queryEntity, String builderEntityName, List<Object> listIds) {
        HashSet<String> mainPropertys = new HashSet<String>();
        HashSet<String> nestPropertys = new HashSet<String>();
        EsStrageBaseHelper.parseSelectField(queryEntity, mainPropertys, nestPropertys, Boolean.FALSE);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)queryEntity.getEntityName());
        DynamicObject[] mainArray = EncryptionBusinessDataServiceHelper.loadDynamicObjectsByPks(listIds.toArray(new Object[listIds.size()]), (DynamicObjectType)dt);
        if (mainArray == null) {
            return null;
        }
        return EsStrageBaseHelper.buildBatchBaseValue(builderEntityName, queryEntity, mainArray, mainPropertys, nestPropertys);
    }
}

