/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.filter.control;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.hr.ruleengine.controls.ConditionControl;
import kd.bos.ext.hr.ruleengine.utils.HRFilterOptUtil;
import kd.bos.ext.hr.ruleengine.utils.ParamsUtil;
import kd.bos.ext.hr.ruleengine.utils.RuleUtil;
import kd.bos.form.BindingContext;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;

@KSObject
@DataEntityTypeAttribute(name="kd.bos.ext.hr.filter.control.HRFilter")
public class HRFilter
extends ConditionControl {
    private String paramDisplayMode = "tree";
    Integer defaultRows = 0;
    private static final String INPUTOBJECT = "inputobject";
    private static final String INPUT_PARAMNUMBER = "inputnumber";
    private static final String INPUT_NAME = "inputname";
    private static final String INPUT_PARAMSTYPE = "inputparamstype";
    private static final String INPUT_COMBO = "inputcombo";
    private static final String INPUT_MULTIPLE = "inputmultiple";
    private static final String INPUT_DATE_FORMAT = "inputdateformat";
    private static final String INPUT_DYN_PROP = "inputdynprop";

    @Override
    public void bindData(BindingContext object) {
        HashMap data = Maps.newHashMapWithExpectedSize((int)16);
        data.put("initing", "true");
        data.put("value", this.getValue(true));
        data.put("comparisonOpt", HRFilterOptUtil.getComparisonOperatorsMap());
        data.put("conditionExpress", this.getConditionExpress());
        data.put("containTarget", false);
        data.put("showValueType", false);
        data.put("hideButton", this.getHideButton());
        data.put("defaultRows", this.getDefaultRows());
        data.put("showDeleteOnlyOneRow", this.getShowDeleteOnlyOneRow());
        data.put("paramDisplayMode", this.getParamDisplayMode());
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        String pageStatus = this.getView().getPageCache().get("pageState");
        if ("VIEW".equals(pageStatus)) {
            data.put("pageState", "VIEW");
        } else {
            String pageState;
            String string = pageState = operationStatus == OperationStatus.ADDNEW ? "NEW" : operationStatus.name();
            if (this.getLock() != null && this.getLock().contains(pageState.toLowerCase())) {
                data.put("pageState", "VIEW");
            }
        }
        String sceneId = this.getScene();
        if (StringUtils.isNotEmpty((CharSequence)sceneId)) {
            data.put("param", this.getInputParam(Long.parseLong(sceneId)));
        }
        this.updateControlDataOnInit(data);
        this.setInited(Boolean.TRUE);
    }

    @Override
    public List<Map<String, String>> getInputParam(Long sceneId) {
        DynamicObjectCollection inputParams = this.getInputParams(sceneId);
        return this.getInputParam(inputParams);
    }

    private List<Map<String, String>> getInputParam(DynamicObjectCollection inputParams) {
        List<Map<String, String>> paramList = ParamsUtil.getParamIdList(inputParams, INPUT_PARAMSTYPE, INPUTOBJECT, INPUT_NAME, INPUT_PARAMNUMBER, INPUT_COMBO, INPUT_MULTIPLE, INPUT_DATE_FORMAT, INPUT_DYN_PROP);
        if ("tree".equals(this.paramDisplayMode)) {
            return paramList;
        }
        ArrayList tempList = Lists.newArrayListWithCapacity((int)10);
        for (Map<String, String> paramMap : paramList) {
            tempList.addAll((Collection)SerializationUtils.fromJsonString((String)paramMap.get("children"), List.class));
        }
        tempList.sort((o1, o2) -> {
            String rowKey1 = (String)o1.get("name");
            String rowKey2 = (String)o2.get("name");
            return rowKey1.compareTo(rowKey2);
        });
        return tempList;
    }

    @Override
    public Map<String, List<Map<String, String>>> getInputValueParam(Long sceneId) {
        return null;
    }

    public DynamicObjectCollection getInputParams(Long sceneId) {
        QFilter filter = new QFilter("id", "=", (Object)sceneId);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] sceneDy = BusinessDataServiceHelper.load((String)"hrcs_filterscene", (String)"sceneinputparams, sceneinputparams.inputname, sceneinputparams.inputnumber, sceneinputparams.inputparamstype, sceneinputparams.inputobject, sceneinputparams.inputmultiple, sceneinputparams.inputcombo, sceneinputparams.inputdateformat, sceneinputparams.inputdynprop", (QFilter[])filters);
        return sceneDy[0].getDynamicObjectCollection("sceneinputparams");
    }

    public void setParam(List<Map<String, String>> paramList) {
        HashMap data = Maps.newHashMapWithExpectedSize((int)2);
        data.put("param", paramList);
    }

    public void setParamAndUpdateControl(List<Map<String, String>> paramList) {
        HashMap data = Maps.newHashMapWithExpectedSize((int)2);
        data.put("param", paramList);
        this.updateControlData(data);
    }

    @Override
    public void updateControlData(Map<String, Object> data) {
        this.updateControlData(this.getKey(), data);
    }

    public String getValue(boolean updateDisplayName) {
        String value = super.getValue();
        if (StringUtils.isEmpty((CharSequence)value) || !updateDisplayName) {
            return value;
        }
        return RuleUtil.getNewestConditionValue(value);
    }

    @KSMethod
    @SimplePropertyAttribute(name="paramDisplayMode")
    public String getParamDisplayMode() {
        return this.get(this.paramDisplayMode);
    }

    public void setParamDisplayMode(String paramDisplayMode) {
        this.paramDisplayMode = paramDisplayMode;
        this.set(paramDisplayMode);
    }

    @Override
    public Integer getDefaultRows() {
        return Integer.parseInt(this.get(this.defaultRows.toString()));
    }
}

