/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.form.operate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.form.operate.helper.MultiSheetOperateHelper;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.dto.ImportPermissionParam;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.mservice.ImportPermissionService;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.listop.ExportList;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class MultiSheetExportByImpt
extends ExportList {
    private final String MULTI_SHEET_SELECT_OP = "multisheetselectexporttemplate";
    private final String ENTITY_NUMBER = "EntityNumber";
    private ImportPermissionService importPermissionService = new ImportPermissionService();

    protected String getTemplateType() {
        return "IMPT";
    }

    public OperationResult invokeOperation() {
        if (this.getView() instanceof IListView) {
            IListView listview = (IListView)this.getView();
            BillList billList = (BillList)listview.getControl("billlistap");
            int billNum = billList.getSelectedRows().getPrimaryKeyValues().length;
            listview.getPageCache().put("ExportParameter", SerializationUtils.toJsonString((Object)this.getParameter()));
            listview.getPageCache().put("EntityNumber", this.getEntityId());
            if (billNum == 0) {
                if (this.isDefaultExportListAll() && (billNum = billList.queryBillDataCount()) > 0) {
                    this.saveCacheForPermission(listview.getPageCache());
                    String showMsg = MessageFormat.format(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5bfc\u51fa{0}\u5f20\u5355\u636e\uff0c\u786e\u8ba4\u662f\u5426\u5bfc\u51fa\uff1f", (String)"MultiSheetExportByImpt_0", (String)"bos-ext-hr", (Object[])new Object[0]), billNum);
                    this.getView().showConfirm(showMsg, MessageBoxOptions.YesNo, new ConfirmCallBackListener("MultiSheetExportListConfirmCallBack", (AbstractOperate)this));
                    return null;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"MultiSheetExportByImpt_1", (String)"bos-ext-hr", (Object[])new Object[0]));
            } else {
                this.export();
            }
        }
        return null;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            try {
                this.handleCancelDataRight();
                this.handleCancelRight();
            }
            catch (KDBizException kdBizException) {
                this.getView().showErrorNotification(kdBizException.getMessage());
                return;
            }
            if (this.checkPermission()) {
                this.export();
            }
        }
    }

    private void handleCancelRight() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter.getCancelRight() != 0) {
            FormConfig config = formShowParameter.getFormConfig();
            String formName = config.getCaption().toString();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\"%1$s\"\u529f\u80fd\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"MultiSheetExportByImpt_2", (String)"bos-ext-hr", (Object[])new Object[0]), formName));
        }
    }

    private void handleCancelDataRight() {
        if (this.getView().getFormShowParameter().isCancelDataRight()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"MultiSheetExportByImpt_3", (String)"bos-ext-hr", (Object[])new Object[0]));
        }
    }

    private boolean checkPermission() {
        OperationResult result = new OperationResult();
        IFormView view = this.getView();
        String orgIdsStr = view.getPageCache().get("MainOrgIds");
        ImportPermissionParam.Buidler importPermissionParamBuidler = new ImportPermissionParam.Buidler().setBizAppId(view.getPageCache().get("CheckRightAppId")).setMainOrgIds(StringUtils.isNotBlank((CharSequence)orgIdsStr) ? JSONObject.parseArray((String)orgIdsStr, Long.class) : new ArrayList(0)).setRealEntityId(view.getPageCache().get("RealPermissionEntityId")).setCurrentEntityId(view.getPageCache().get("BillFormId")).setOperateName(view.getPageCache().get("OperateName")).setPermissionItemId(view.getPageCache().get("PermissionItemId")).setResult(result);
        if (!this.importPermissionService.validatePermission(importPermissionParamBuidler.build())) {
            this.importPermissionService.doFailCheckRight(this.getView(), result);
            return false;
        }
        return true;
    }

    private boolean isDefaultExportListAll() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)formShowParameter;
            ListUserOption listOption = listShowParameter.getListUserOption();
            if (listOption == null) {
                listOption = new ListUserOption();
            }
            return listOption.isDefaultExportListAll();
        }
        return false;
    }

    private void saveCacheForPermission(IPageCache pageCache) {
        String billFormId = null;
        String listName = null;
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        if (view instanceof IListView) {
            IListView listview = (IListView)view;
            FormConfig config = FormMetadataCache.getFormConfig((String)listview.getBillFormId());
            billFormId = config.getEntityTypeId();
            listName = config.getCaption().toString();
            pageCache.put("BillTypeId", "" + ((ListShowParameter)formShowParameter).getBillTypeId());
        } else if (view instanceof IBillView) {
            billFormId = view.getEntityId();
            String caption = formShowParameter.getCaption();
            listName = StringUtils.isNotBlank((CharSequence)caption) ? caption : (formShowParameter.getFormConfig() != null ? formShowParameter.getFormConfig().getCaption().toString() : "");
        }
        pageCache.put("ServiceAppId", formShowParameter.getServiceAppId());
        pageCache.put("CheckRightAppId", formShowParameter.getCheckRightAppId());
        pageCache.put("BillFormId", billFormId);
        pageCache.put("ListName", listName);
        pageCache.put("OperateKey", this.getOperateKey());
        pageCache.put("PermissionItemId", this.getPermissionItemId());
        pageCache.put("RealPermissionEntityId", this.getRealPermissionEntityId());
        List mainOrgIds = new ArrayList<Long>();
        if (view instanceof IListView) {
            mainOrgIds = ((IListView)this.getView()).getSelectedMainOrgIds();
        } else if (this.mainOrgId != null) {
            mainOrgIds.add(this.mainOrgId);
        }
        if (mainOrgIds != null && !mainOrgIds.isEmpty()) {
            pageCache.put("MainOrgIds", JSONArray.toJSONString(mainOrgIds));
        }
        pageCache.put("OperateName", this.getOperateName().toString());
    }

    private void export() {
        String entityNumber = this.getView().getPageCache().get("EntityNumber");
        Map parameter = (Map)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get("ExportParameter"), Map.class);
        if (Boolean.TRUE.equals(parameter.get("byList"))) {
            this.showProgressForm(entityNumber, this.getBlankTemplateId());
        } else {
            QFilter filters = MultiSheetOperateHelper.constructTemplateQfilter(this.getTemplateType(), entityNumber);
            List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"export", (String)"hrcs_multientityimptmpl", (QFilter[])new QFilter[]{filters}, (String)"", (int)2);
            if (pkIds.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u9002\u914d\u7684\u6a21\u677f,\u8bf7\u5148\u914d\u7f6e\u76f8\u5e94\u6a21\u677f!", (String)"MultiSheetExportByImpt_4", (String)"bos-ext-hr", (Object[])new Object[0]));
            } else if (pkIds.size() == 1) {
                String errMsg = MultiSheetOperateHelper.checkTemplatesCondition(pkIds.toArray());
                if (StringUtils.isBlank((CharSequence)errMsg)) {
                    this.showProgressForm(entityNumber, (Long)pkIds.get(0));
                } else {
                    this.getView().showErrorNotification(errMsg);
                }
            } else {
                this.showSelectTemplate();
            }
        }
    }

    private void showProgressForm(String entitynumber, long templateId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrcs_exportdataprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        Map customParams = showParameter.getCustomParams();
        customParams.put("ServiceAppId", this.getView().getFormShowParameter().getServiceAppId());
        customParams.put("entitynumber", entitynumber);
        customParams.put("entityname", StringUtils.isBlank((CharSequence)this.getView().getFormShowParameter().getCaption()) ? this.getView().getFormShowParameter().getFormConfig().getCaption().getLocaleValue() : this.getView().getFormShowParameter().getCaption());
        customParams.put("templateId", templateId);
        customParams.put("fillparent", String.valueOf("EXPT".equals(this.getTemplateType())));
        customParams.put("byList", "false");
        customParams.put("EXPORT_LIST_TYPE", this.getTemplateType());
        customParams.put("taskClassName", "kd.hr.hbp.formplugin.web.multiexpt.MultiSheetExportDataTask");
        this.getView().showForm(showParameter);
    }

    private void showSelectTemplate() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrcs_selectexporttemplate");
        showParameter.setCustomParam("TemplateType", (Object)this.getTemplateType());
        showParameter.setCustomParam("BillTypeId", (Object)((ListShowParameter)this.getView().getFormShowParameter()).getBillTypeId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "multisheetselectexporttemplate");
        showParameter.setCloseCallBack(closeCallBack);
        IFormView view = this.getView();
        showParameter.setCustomParam("ServiceAppId", (Object)view.getPageCache().get("ServiceAppId"));
        showParameter.setCustomParam("CheckRightAppId", (Object)view.getPageCache().get("CheckRightAppId"));
        showParameter.setCustomParam("BillFormId", (Object)view.getPageCache().get("BillFormId"));
        showParameter.setCustomParam("ListName", (Object)view.getPageCache().get("ListName"));
        showParameter.setCustomParam("OperateKey", (Object)view.getPageCache().get("OperateKey"));
        showParameter.setCustomParam("PermissionItemId", (Object)view.getPageCache().get("PermissionItemId"));
        showParameter.setCustomParam("RealPermissionEntityId", (Object)view.getPageCache().get("RealPermissionEntityId"));
        showParameter.setCustomParam("MainOrgIds", (Object)view.getPageCache().get("MainOrgIds"));
        showParameter.setCustomParam("OperateName", (Object)view.getPageCache().get("OperateName"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if (event.getView() != null) {
            this.setView(event.getView());
            if (event.getReturnData() != null) {
                if ("multisheetselectexporttemplate".equals(event.getActionId())) {
                    try {
                        this.handleCancelDataRight();
                        this.handleCancelRight();
                    }
                    catch (KDBizException kdBizException) {
                        this.getView().showErrorNotification(kdBizException.getMessage());
                        return;
                    }
                    if (!this.checkPermission()) {
                        return;
                    }
                }
                Object[] templates = (Object[])event.getReturnData();
                String entitynumber = this.getView().getPageCache().get("EntityNumber");
                this.showProgressForm(entitynumber, (Long)templates[0]);
            }
        }
    }
}

