/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.metadata.edit;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.dao.FormTemplateFactory;
import kd.bos.designer.dao.IFormTemplate;
import kd.bos.designer.property.RefPropsEdit;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.hr.util.QueryEntityUtil;
import kd.bos.form.control.TreeView;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.metadata.entity.businessfield.IBasedataField;

public class QueryRefPropsEdit
extends RefPropsEdit {
    private static final String F_TARGET_PROPS = "ftargetprops";
    private static final String FIELD_TREE = "FieldTree";
    private static final String CHECK_NODES = "checkNodes";
    private static final String FTNAME = "ftname";

    public void afterCreateNewData(EventObject e) {
        List item = (List)this.getView().getFormShowParameter().getCustomParam("context");
        if (item != null && !item.isEmpty()) {
            EntityMetadata entityMetadata;
            Object ctrl = this.getCtrl(item);
            String entityId = "";
            if (ctrl instanceof IBasedataField) {
                entityId = ((IBasedataField)ctrl).getBaseEntityId();
            }
            if (!StringUtils.isBlank((CharSequence)entityId) && (entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity)).getRootEntity() instanceof QueryEntity) {
                TreeNode root = QueryEntityUtil.buildBillTreeNodes(entityMetadata, true);
                TreeView tree = (TreeView)this.getView().getControl(FIELD_TREE);
                tree.addNode(root);
                Object value = this.getView().getFormShowParameter().getCustomParams().get("value");
                if (value == null || StringUtils.isBlank(value)) {
                    value = Lists.newArrayListWithExpectedSize((int)16);
                }
                List refProps = (List)value;
                ArrayList checkNodeIds = Lists.newArrayListWithExpectedSize((int)16);
                ArrayList checkNodes = Lists.newArrayListWithExpectedSize((int)16);
                for (Map refprop : refProps) {
                    String nodeId = (String)refprop.get("Name");
                    if (nodeId == null) continue;
                    checkNodeIds.add(nodeId);
                    checkNodes.add(root.getTreeNode(nodeId, 16));
                }
                tree.checkNodes((List)checkNodes);
                this.getPageCache().put(FIELD_TREE, SerializationUtils.toJsonString((Object)root));
                this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString((Object)checkNodeIds));
                IDataModel model = this.getModel();
                model.deleteEntryData(F_TARGET_PROPS);
                for (Map refProp : refProps) {
                    String name = (String)refProp.get("Name");
                    TreeNode node = root.getTreeNode(name, 16);
                    if (node == null) continue;
                    int rowindex = model.createNewEntryRow(F_TARGET_PROPS);
                    model.setValue(FTNAME, (Object)node.getId(), rowindex);
                    model.setValue("ftdisplayname", (Object)node.getText(), rowindex);
                }
            }
        }
    }

    private String getModelType() {
        String modelType = (String)this.getView().getFormShowParameter().getCustomParams().get("modelType");
        if (StringUtils.isBlank((CharSequence)modelType)) {
            modelType = "QueryListModel";
        }
        return modelType;
    }

    private Object getCtrl(List<Map<String, Object>> item) {
        List fldlist = item.get(0) instanceof List ? (List)((Object)item.get(0)) : item;
        IFormTemplate template = FormTemplateFactory.createTemplate((String)this.getModelType());
        return template.deserializeFromMap((Map)fldlist.get(0), null);
    }
}

