/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.metadata.prop;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.ext.hr.util.QueryEntityUtil;
import kd.bos.ext.hr.util.QueryRefUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public interface IQueryProp {
    public static final Log LOGGER = LogFactory.getLog(IQueryProp.class);
    public static final List<String> employees = Arrays.asList("hrpi_employeef7querylist", "hrpi_employeelist", "hrpi_employeequitf7list", "hrpi_latestemployeelist");
    public static final List<String> depEmps = Arrays.asList("hrpi_depemp4chargef7list", "hrpi_depempf7querylist", "hrpi_deppromemberf7list");

    default public String getNameKey(IDataEntityType dt, String displayProp) {
        if (!(displayProp = QueryRefUtils.removeConnectorByNumber(displayProp, this.getBaseEntityId())).contains(",")) {
            if (null == dt) {
                dt = this.getComplexType();
            }
            BasedataEntityType basedataEntityType = (BasedataEntityType)dt;
            String nameKey = displayProp.contains(".") ? displayProp.replace(".number", ".name") : basedataEntityType.getNameProperty();
            return this.hasProp(basedataEntityType, nameKey) ? nameKey : displayProp;
        }
        String[] keys = displayProp.split(",");
        String nameKey = keys[0].endsWith("name") ? keys[0] : keys[1];
        return nameKey;
    }

    default public String getNumberKey(IDataEntityType dt, String displayProp) {
        if (employees.contains(this.getBaseEntityId())) {
            return "empnumber";
        }
        if (depEmps.contains(this.getBaseEntityId())) {
            return "employee.empnumber";
        }
        if (!(displayProp = QueryRefUtils.removeConnectorByNumber(displayProp, this.getBaseEntityId())).contains(",")) {
            if (null == dt) {
                dt = this.getComplexType();
            }
            BasedataEntityType basedataEntityType = (BasedataEntityType)dt;
            String numberKey = displayProp.contains(".") ? displayProp.replace(".name", ".number") : basedataEntityType.getNumberProperty();
            return this.hasProp(basedataEntityType, numberKey) ? numberKey : displayProp;
        }
        String[] keys = displayProp.split(",");
        String numberKey = keys[0].endsWith("name") ? keys[1] : keys[0];
        return numberKey;
    }

    default public boolean hasProp(BasedataEntityType dt, String displayProp) {
        String[] field = displayProp.split("\\.");
        DynamicProperty prop = dt.getProperty(field[0]);
        if (prop instanceof BasedataProp) {
            BasedataEntityType basedataEntityType = (BasedataEntityType)((BasedataProp)prop).getComplexType();
            return null != basedataEntityType.getProperty(field[1]);
        }
        return null != prop;
    }

    public String getBaseEntityId();

    public IDataEntityType getComplexType();

    default public void addProperty(DynamicObjectType refEntityType, QueryEntityType queryEntityType) {
        try {
            LongProp idProp;
            List<String> fieldNames = QueryEntityUtil.getFieldNames(queryEntityType, true);
            for (String fieldName : fieldNames) {
                String field = fieldName.split("\\.")[0];
                DynamicProperty property = queryEntityType.getProperty(field);
                if (null == property) continue;
                this.addProperty((IDataEntityType)refEntityType, (DynamicProperty)property.clone());
                if (!(property instanceof BasedataProp)) continue;
                if (null != queryEntityType.getProperty(field + "_id")) {
                    this.addProperty((IDataEntityType)refEntityType, (DynamicProperty)queryEntityType.getProperty(field + "_id").clone());
                    continue;
                }
                if (null == queryEntityType.getProperty(field + ".id")) continue;
                this.addProperty((IDataEntityType)refEntityType, (DynamicProperty)queryEntityType.getProperty(field + ".id").clone());
            }
            if (queryEntityType.getProperty("id") instanceof LongProp) {
                idProp = new LongProp();
                idProp.setName("id");
                this.addProperty((IDataEntityType)refEntityType, (DynamicProperty)idProp);
            } else {
                idProp = new TextProp();
                idProp.setName("id");
                this.addProperty((IDataEntityType)refEntityType, (DynamicProperty)idProp);
            }
            if (queryEntityType.getProperty("masterid") instanceof LongProp) {
                idProp = new LongProp();
                idProp.setName("masterid");
                this.addProperty((IDataEntityType)refEntityType, (DynamicProperty)idProp);
            } else if (queryEntityType.getProperty("masterid") instanceof TextProp) {
                idProp = new TextProp();
                idProp.setName("masterid");
                this.addProperty((IDataEntityType)refEntityType, (DynamicProperty)idProp);
            }
            if (null != queryEntityType.getProperty("multilanguagetext")) {
                this.addProperty((IDataEntityType)refEntityType, (DynamicProperty)queryEntityType.getProperty("multilanguagetext").clone());
            }
        }
        catch (CloneNotSupportedException exc) {
            LOGGER.error("CloneNotSupportedException\uff1a", (Throwable)exc);
        }
    }

    public void addProperty(IDataEntityType var1, DynamicProperty var2);
}

