/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.ruleengine.controls;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.hr.ruleengine.constants.RuleConstants;
import kd.bos.ext.hr.ruleengine.helper.RuleEngineHelper;
import kd.bos.ext.hr.ruleengine.utils.FormatUtil;
import kd.bos.ext.hr.ruleengine.utils.ParamsUtil;

public interface ICondition
extends RuleConstants {
    default public List<Map<String, String>> getInputParamContainTarget(Long sceneId) {
        List<Map<String, String>> paramData = this.getInputParamNoContainTarget(sceneId);
        List<Map<String, String>> targetData = this.getTarget(sceneId);
        if (!targetData.isEmpty()) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)2);
            map.put("text", ResManager.loadKDString((String)"\u6307\u6807", (String)"ICondition_0", (String)"bos-ext-hr", (Object[])new Object[0]));
            map.put("children", SerializationUtils.toJsonString(targetData));
            paramData.add(map);
        }
        return paramData;
    }

    default public List<Map<String, String>> getInputParamNoContainTarget(Long sceneId) {
        return ParamsUtil.getInputParam(sceneId);
    }

    default public List<Map<String, String>> getTarget(Long sceneId) {
        DynamicObjectCollection targetObjs = RuleEngineHelper.queryTargetByScene(sceneId);
        ArrayList targetList = Lists.newArrayListWithCapacity((int)targetObjs.size());
        for (DynamicObject obj : targetObjs) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)6);
            String key = FormatUtil.getTargetMapKey(obj.getString("id"));
            map.put("id", key);
            map.put("text", obj.getString("name"));
            map.put("type", obj.getString("returntype"));
            map.put("target", "true");
            map.put("typeDetail", obj.getString("returntype"));
            map.put("dateFormat", obj.getString("dateFormat"));
            targetList.add(map);
        }
        return targetList;
    }
}

