/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.ruleengine.controls;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.org.OrgViewSchemeProp;
import kd.bos.exception.KDException;
import kd.bos.ext.hr.ruleengine.constants.RuleConstants;
import kd.bos.ext.hr.ruleengine.helper.RuleEngineHelper;
import kd.bos.ext.hr.ruleengine.utils.FormatUtil;
import kd.bos.ext.hr.ruleengine.utils.ParamsUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import org.apache.commons.beanutils.ConvertUtils;

public interface IRule
extends RuleConstants {
    public static final Log logger = LogFactory.getLog(IRule.class);

    default public F7Param getF7Param(String entityNumber, String field) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        DynamicProperty prop = (DynamicProperty)mainEntityType.getAllFields().get(field);
        if (prop instanceof OrgProp) {
            OrgProp orgProp = (OrgProp)prop;
            OrgViewSchemeProp orgViewScheme = orgProp.getOrgViewScheme();
            return new F7Param(orgProp.getBaseEntityId(), orgProp.getOrgFunc(), orgViewScheme == null ? null : orgViewScheme.getNumber());
        }
        if (prop instanceof BasedataProp) {
            return new F7Param(((BasedataProp)prop).getBaseEntityId());
        }
        if (prop instanceof MulBasedataProp) {
            return new F7Param(((MulBasedataProp)prop).getBaseEntityId());
        }
        return new F7Param();
    }

    default public F7Param getF7Param(String[] entities) {
        F7Param f7Param;
        if (entities.length == 6) {
            f7Param = this.getF7Param(entities[3], entities[4]);
        } else if (entities.length == 5) {
            String entityNumber = "";
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entities[1]);
            DynamicProperty prop = (DynamicProperty)mainEntityType.getAllFields().get(entities[2]);
            if (prop instanceof BasedataProp) {
                entityNumber = ((BasedataProp)prop).getBaseEntityId();
            } else if (prop instanceof MulBasedataProp) {
                entityNumber = ((MulBasedataProp)prop).getBaseEntityId();
            }
            f7Param = this.getF7Param(entityNumber, entities[3]);
        } else {
            f7Param = entities.length == 4 ? this.getF7Param(entities[1], entities[2]) : (entities.length == 3 ? new F7Param(entities[1]) : new F7Param(entities[0]));
        }
        return f7Param;
    }

    default public List<QFilter> getQFilters(MainEntityType mainEntityType, String filterStr) {
        List qFilterList;
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)2);
        if (null != mainEntityType.findProperty("enable")) {
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
        }
        if (null != mainEntityType.findProperty("status")) {
            qFilters.add(new QFilter("status", "=", (Object)"C"));
        }
        if (StringUtils.isNotEmpty((CharSequence)filterStr) && !CollectionUtils.isEmpty((Collection)(qFilterList = SerializationUtils.fromJsonStringToList((String)filterStr, QFilter.class)))) {
            qFilters.addAll(qFilterList);
        }
        return qFilters;
    }

    default public void openParamF7(Control control, LinkedHashMap<String, Object> argsJson, String actionId) {
        String entityNumber = argsJson.get("entityNumber").toString();
        String index = argsJson.get("index").toString();
        boolean isMulti = Boolean.parseBoolean(argsJson.get("isMulti").toString());
        String selectedIdStr = null == argsJson.get("value") ? "" : argsJson.get("value").toString();
        String filterStr = (String)argsJson.get("filters");
        String[] entities = entityNumber.split("\\.");
        F7Param f7Param = this.getF7Param(entities);
        entityNumber = f7Param.getEntityNumber();
        try {
            ListShowParameter fsp = ShowFormHelper.createShowListForm((String)entityNumber, (boolean)isMulti);
            fsp.setCloseCallBack(new CloseCallBack(control.getClass().getName(), FormatUtil.getActionId(control.getKey(), actionId, index, entityNumber)));
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setShowTitle(false);
            fsp.setHasRight(true);
            fsp.setCustomParam("orgFuncId", (Object)f7Param.getOrgFunId());
            fsp.setCustomParam("orgViewSchemeNumber", (Object)f7Param.getOrgViewSchemeNumber());
            if (entityNumber.equals("haos_adminorghr")) {
                fsp.setCustomParam("struct_project_ids", (Object)SerializationUtils.toJsonString(Collections.singletonList("1010")));
                fsp.setF7ClickByFilter(true);
            }
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            List<QFilter> qFilters = this.getQFilters(mainEntityType, filterStr);
            fsp.setListFilterParameter(new ListFilterParameter(qFilters, null));
            if (isMulti && StringUtils.isNotEmpty((CharSequence)selectedIdStr)) {
                Object[] selectedIds = selectedIdStr.split(",");
                if (mainEntityType.getPrimaryKey() instanceof LongProp) {
                    fsp.setSelectedRows((Object[])((Long[])ConvertUtils.convert((String[])selectedIds, Long.class)));
                } else {
                    fsp.setSelectedRows(selectedIds);
                }
            }
            control.getView().showForm((FormShowParameter)fsp);
        }
        catch (KDException exc) {
            control.getView().showErrorNotification(ResManager.loadKDString((String)"\u6253\u5f00\u5b9e\u4f53%s\u5217\u8868\u5f02\u5e38", (String)"IRule_0", (String)"bos-ext-hr", (Object[])new Object[]{entityNumber}));
            logger.error(String.format(Locale.ROOT, "\u6253\u5f00\u5b9e\u4f53%s\u5217\u8868\u5f02\u5e38", entityNumber), (Throwable)exc);
        }
    }

    default public Map<String, Object> getF7CallBack(String index, ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedCol = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (null == selectedCol) {
            return null;
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)32);
        ArrayList idList = Lists.newArrayListWithExpectedSize((int)32);
        ArrayList nameList = Lists.newArrayListWithExpectedSize((int)32);
        ArrayList numberList = Lists.newArrayListWithExpectedSize((int)32);
        for (ListSelectedRow select : selectedCol) {
            idList.add(select.getPrimaryKeyValue().toString());
            nameList.add(StringUtils.isEmpty((CharSequence)select.getName()) ? select.getPrimaryKeyValue().toString() : select.getName());
            numberList.add(select.getNumber());
        }
        String entityNumber = closedCallBackEvent.getActionId().split("\\.")[3];
        if (ParamsUtil.isAdminOrg(entityNumber)) {
            numberList.clear();
            Map<String, String> result = RuleEngineHelper.getStructNumber(idList.stream().map(Long::parseLong).collect(Collectors.toList()));
            for (String id : idList) {
                numberList.add(result.get(id));
            }
        }
        resultMap.put("idList", idList);
        resultMap.put("nameList", nameList);
        resultMap.put("numberList", numberList);
        resultMap.put("valueIdIsString", selectedCol.get(0).getPrimaryKeyValue() instanceof String);
        resultMap.put("index", index);
        return resultMap;
    }

    default public Map<String, List<Map<String, String>>> getInputValueParam(Long sceneId) {
        return ParamsUtil.getInputValueParamMap(sceneId);
    }

    public void clear();

    public void clearAll();

    public static class F7Param {
        private String entityNumber;
        private String orgFunId;
        private String orgViewSchemeNumber;

        public F7Param() {
        }

        public F7Param(String entityNumber) {
            this.entityNumber = entityNumber;
        }

        public F7Param(String entityNumber, String orgFunId, String orgViewSchemeNumber) {
            this.entityNumber = entityNumber;
            this.orgFunId = orgFunId;
            this.orgViewSchemeNumber = orgViewSchemeNumber;
        }

        public String getEntityNumber() {
            return this.entityNumber;
        }

        public void setEntityNumber(String entityNumber) {
            this.entityNumber = entityNumber;
        }

        public String getOrgFunId() {
            return this.orgFunId;
        }

        public void setOrgFunId(String orgFunId) {
            this.orgFunId = orgFunId;
        }

        public String getOrgViewSchemeNumber() {
            return this.orgViewSchemeNumber;
        }

        public void setOrgViewSchemeNumber(String orgViewSchemeNumber) {
            this.orgViewSchemeNumber = orgViewSchemeNumber;
        }
    }
}

