/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.util.query;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IJoinProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.EntityItemTypes;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import org.apache.commons.lang3.StringUtils;

public class QueryEntityTypeUtil {
    private int index = 0;
    private QueryEntityType entityType;
    private List<String> fieldList;
    private Set<String> cacheField = new HashSet<String>();
    private boolean clearOriginalProp = false;

    public QueryEntityTypeUtil(QueryEntityType entityType, String selectFields) {
        this.entityType = entityType;
        this.fieldList = Arrays.asList(selectFields.split(","));
    }

    public QueryEntityTypeUtil(QueryEntityType entityType, String selectFields, boolean clearOriginalProp) {
        this.entityType = entityType;
        this.fieldList = Arrays.asList(selectFields.split(","));
        this.clearOriginalProp = clearOriginalProp;
    }

    public List<String> getFieldList() {
        return this.fieldList;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(QueryEntityType queryEntityType) {
        this.entityType = queryEntityType;
    }

    public DynamicObjectType genDynamicObjectType() {
        MainEntityType dt = new MainEntityType();
        dt.setName("QueryObject");
        Set joinEntity = this.entityType.getJoinEntitys().stream().map(JoinEntity::getEntityName).collect(Collectors.toSet());
        for (String fieldName : this.fieldList) {
            String[] fieldNames = fieldName.split("\\.");
            if (!joinEntity.contains(fieldNames[0]) && fieldNames.length == 2) {
                this.registerProperty((DynamicObjectType)dt, fieldNames[0]);
                continue;
            }
            if (joinEntity.contains(fieldNames[0]) && fieldNames.length > 3) {
                String preField = fieldName.substring(0, fieldName.lastIndexOf(46));
                this.registerProperty((DynamicObjectType)dt, preField);
                continue;
            }
            this.registerProperty((DynamicObjectType)dt, fieldName);
        }
        String mainEntityPk = this.entityType.getPrimaryKey().getName();
        this.registerProperty((DynamicObjectType)dt, mainEntityPk);
        for (String joinEntityNum : joinEntity) {
            ISimpleProperty primaryKey = EntityMetadataCache.getDataEntityType((String)joinEntityNum).getPrimaryKey();
            String joinPkField = joinEntityNum + "." + primaryKey.getName();
            this.registerProperty((DynamicObjectType)dt, joinPkField);
        }
        return dt;
    }

    public String registerProperty(DynamicObjectType dt, String fieldName) {
        IDataEntityProperty srcFieldProp = this.getSelectProp((EntityType)this.entityType, fieldName);
        if (srcFieldProp == null) {
            return null;
        }
        String propName = this.getPropName(fieldName, srcFieldProp);
        if (srcFieldProp instanceof ISimpleProperty) {
            return this.registerProperty(dt, fieldName, (ISimpleProperty)srcFieldProp, propName);
        }
        if (srcFieldProp instanceof IComplexProperty) {
            return this.registerProperty(dt, fieldName, (IComplexProperty)srcFieldProp, propName);
        }
        if (srcFieldProp instanceof ICollectionProperty) {
            return this.registerProperty(dt, fieldName, (ICollectionProperty)srcFieldProp, propName);
        }
        return null;
    }

    private String registerProperty(DynamicObjectType dt, String fieldName, ICollectionProperty srcFieldProp, String propName) {
        DynamicProperty p = dt.getProperty(propName);
        if (p == null) {
            MulBasedataProp baseProp = (MulBasedataProp)TypesContainer.createInstance(srcFieldProp.getClass());
            baseProp.setItemType(srcFieldProp.getItemType());
            baseProp.setAlias(srcFieldProp.getAlias());
            baseProp.setName(fieldName);
            p = baseProp;
            if (this.cacheField.contains(fieldName)) {
                return fieldName;
            }
            this.cacheField.add(fieldName);
            baseProp.setOrdinal(this.index++);
            dt.registerCollectionProperty((DynamicCollectionProperty)baseProp);
        }
        return propName;
    }

    private String registerProperty(DynamicObjectType dt, String fieldName, IComplexProperty srcFieldProp, String propName) {
        if (srcFieldProp instanceof IJoinProperty) {
            return this.registerJoinProperty(dt, fieldName, srcFieldProp, propName);
        }
        DynamicProperty p = dt.getProperty(propName);
        if (p == null) {
            String refIdPropName = srcFieldProp.getName() + "_Id";
            BasedataProp baseProp = (BasedataProp)TypesContainer.createInstance(srcFieldProp.getClass());
            baseProp.setName(fieldName);
            baseProp.setDbIgnore(true);
            baseProp.setRefIdPropName(refIdPropName);
            if (baseProp instanceof ItemClassProp) {
                FilterField itemTypeFld;
                String itemTypePropName = ((ItemClassProp)srcFieldProp).getTypePropName();
                if (StringUtils.isNotEmpty((CharSequence)itemTypePropName) && (itemTypeFld = FilterField.create((MainEntityType)this.entityType, (String)itemTypePropName)) != null) {
                    itemTypePropName = itemTypeFld.getFullFieldName();
                }
                ((ItemClassProp)baseProp).setTypePropName(itemTypePropName);
            } else {
                baseProp.setComplexType(srcFieldProp.getComplexType());
            }
            if (baseProp instanceof FlexProp) {
                ((FlexProp)baseProp).setFlexTypeId(((FlexProp)srcFieldProp).getFlexTypeId());
                ((FlexProp)baseProp).setBasePropertyKey(((FlexProp)srcFieldProp).getBasePropertyKey());
                ((FlexProp)baseProp).setDisplayProp(((FlexProp)srcFieldProp).getDisplayProp());
            }
            if (this.cacheField.contains(fieldName)) {
                return fieldName;
            }
            this.cacheField.add(fieldName);
            baseProp.setOrdinal(this.index++);
            dt.addProperty((DynamicProperty)baseProp);
            p = baseProp;
            DynamicSimpleProperty refIdProp = (DynamicSimpleProperty)EntityItemTypes.clone((IDataEntityProperty)((BasedataProp)srcFieldProp).getRefIdProp());
            baseProp.setRefIdProp((IDataEntityProperty)refIdProp);
            if (this.cacheField.contains(refIdProp.getName())) {
                return refIdProp.getName();
            }
            this.cacheField.add(refIdProp.getName());
            refIdProp.setOrdinal(this.index++);
            this.tryClearDefVal(refIdProp);
            dt.registerSimpleProperty(refIdProp);
        }
        return propName;
    }

    private String registerJoinProperty(DynamicObjectType dt, String fieldName, IComplexProperty srcFieldProp, String propName) {
        int index;
        String key;
        IDataEntityType complexType = srcFieldProp.getComplexType();
        IDataEntityProperty property = this.getSelectProp((EntityType)complexType, key = propName.substring(index = propName.indexOf(46) + 1));
        if (property instanceof IComplexProperty) {
            return this.registerJoinProperty(dt, fieldName, (IComplexProperty)property, key);
        }
        propName = this.getPropName(propName, property);
        return this.registerProperty(dt, fieldName, (ISimpleProperty)property, propName);
    }

    private String registerProperty(DynamicObjectType dt, String fieldName, ISimpleProperty srcFieldProp, String propName) {
        DynamicProperty sp = dt.getProperty(propName);
        if (sp == null) {
            DynamicSimpleProperty property;
            Class<String> propertyType = srcFieldProp.getPropertyType();
            if (propertyType == ILocaleString.class) {
                propertyType = String.class;
            }
            if (srcFieldProp instanceof ItemClassTypeProp) {
                ItemClassTypeProp newProp = new ItemClassTypeProp();
                ItemClassTypeProp srcProp = (ItemClassTypeProp)srcFieldProp;
                newProp.setBaseEntityIds(srcProp.getBaseEntityIds());
                newProp.setComboItems(srcProp.getComboItems());
                newProp.getItemTypes().putAll(srcProp.getItemTypes());
                newProp.setName(fieldName);
                property = newProp;
            } else {
                property = new DynamicSimpleProperty(fieldName, propertyType, null);
            }
            property.setDbType(srcFieldProp.getDbType());
            if (this.cacheField.contains(fieldName)) {
                return fieldName;
            }
            this.cacheField.add(fieldName);
            property.setOrdinal(this.index++);
            this.tryClearDefVal(property);
            dt.registerSimpleProperty(property);
        }
        return propName;
    }

    private void tryClearDefVal(DynamicSimpleProperty property) {
        if (this.clearOriginalProp) {
            property.setEnableNull(true);
            property.setDefaultValue(null);
        }
    }

    private String getPropName(String fieldName, IDataEntityProperty srcFieldProp) {
        String propName;
        if (srcFieldProp instanceof ISimpleProperty) {
            propName = fieldName;
        } else if (srcFieldProp instanceof IComplexProperty) {
            propName = FilterField.buildPropORMFullName((IDataEntityProperty)srcFieldProp);
        } else if (srcFieldProp instanceof ICollectionProperty) {
            propName = FilterField.buildPropORMFullName((IDataEntityProperty)srcFieldProp);
        } else {
            throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{this.getEntityType().getName(), fieldName});
        }
        return propName;
    }

    private IDataEntityProperty getSelectProp(EntityType dt, String key) {
        Object prop;
        String[] keys = key.split("\\.");
        if (keys.length > 1) {
            prop = dt.findProperty(keys[0]);
            if (prop instanceof EntryProp) {
                if ((prop = (IDataEntityProperty)((ICollectionProperty)prop).getItemType().getProperties().get((Object)keys[1])) instanceof SubEntryProp) {
                    prop = (IDataEntityProperty)((SubEntryProp)prop).getItemType().getProperties().get((Object)keys[2]);
                }
            } else if (prop instanceof JoinProperty) {
                if ((prop = ((JoinProperty)prop).getDynamicComplexPropertyType().getProperty(keys[1])) instanceof BasedataProp) {
                    if (keys.length < 3) {
                        return prop;
                    }
                    prop = (IDataEntityProperty)((BasedataProp)prop).getComplexType().getProperties().get((Object)keys[2]);
                } else if (prop instanceof EntryProp) {
                    EntryProp entryProp = (EntryProp)prop;
                    EntryType entryType = (EntryType)entryProp.getDynamicCollectionItemPropertyType();
                    prop = entryType.findProperty(keys[2]);
                }
            }
            if (prop == null) {
                prop = dt.findProperty(key);
            }
        } else {
            prop = dt.getPrimaryKey().getName().equals(key) ? dt.getPrimaryKey() : dt.findProperty(key);
        }
        return prop;
    }
}

