/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.validate;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class HRBDDeleteValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String operateKey = this.getOperateKey();
        if ("delete".equals(operateKey) && dataEntities.length > 0) {
            DynamicObjectCollection dynObjects = this.queryDynamicObjectCollection(this.getIdCollections(dataEntities));
            int length = dynObjects.size();
            for (int index = 0; index < length; ++index) {
                ExtendedDataEntity de = this.getExtDataEntityById(((DynamicObject)dynObjects.get(index)).getLong("id"));
                this.addErrorMessage(de, ResManager.loadKDString((String)"\u4e0d\u53ef\u5220\u9664\u7cfb\u7edf\u9884\u7f6e\u6570\u636e\u3002", (String)"HRBDDeleteValidator_0", (String)"bos-ext-hr", (Object[])new Object[0]));
            }
        }
    }

    private List<Long> getIdCollections(ExtendedDataEntity[] dataEntities) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObject dymObject = entity.getDataEntity();
            Long bdId = (Long)dymObject.get("id");
            idList.add(bdId);
        }
        return idList;
    }

    private DynamicObjectCollection queryDynamicObjectCollection(List<Long> idList) {
        QFilter sysPreset = new QFilter("issyspreset", "=", (Object)"1");
        QFilter idQueryFilter = new QFilter("id", "in", idList);
        QFilter[] dataFilterArray = new QFilter[]{idQueryFilter, sysPreset};
        return QueryServiceHelper.query((String)this.entityKey, (String)"id", (QFilter[])dataFilterArray);
    }

    private ExtendedDataEntity getExtDataEntityById(Long id) {
        for (ExtendedDataEntity de : this.dataEntities) {
            DynamicObject dy = de.getDataEntity();
            Long bdId = dy.getLong("id");
            if (bdId.compareTo(id) != 0) continue;
            return de;
        }
        return null;
    }
}

