/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.validate;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class HRDataBaseValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String operateKey = this.getOperateKey();
        if ("delete".equals(operateKey) && dataEntities.length > 0) {
            List<Long> idList = this.getIdListByDataEntity(dataEntities);
            DynamicObjectCollection dynObjects = this.queryPresetDynamicObjects(idList);
            int length = dynObjects.size();
            for (int i = 0; i < length; ++i) {
                ExtendedDataEntity dataEntity = this.getExtendedDataEntityById(((DynamicObject)dynObjects.get(i)).getLong("id"));
                this.addErrorMessage(dataEntity, ((DynamicObject)dynObjects.get(i)).getString("name") + " " + ResManager.loadKDString((String)"\u4e0d\u53ef\u5220\u9664\u7cfb\u7edf\u9884\u7f6e\u6570\u636e\u3002", (String)"HRDataBaseValidator_0", (String)"bos-ext-hr", (Object[])new Object[0]));
            }
        }
    }

    private List<Long> getIdListByDataEntity(ExtendedDataEntity[] dataEntities) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            Long basedataId = (Long)dynamicObject.get("id");
            idList.add(basedataId);
        }
        return idList;
    }

    private DynamicObjectCollection queryPresetDynamicObjects(List<Long> idList) {
        QFilter idFilter = new QFilter("id", "in", idList);
        QFilter issyspreset = new QFilter("issyspreset", "=", (Object)"1");
        QFilter[] dataFilterArray = new QFilter[]{idFilter, issyspreset};
        DynamicObjectCollection dynObjectColl = QueryServiceHelper.query((String)this.entityKey, (String)"id,name", (QFilter[])dataFilterArray);
        return dynObjectColl;
    }

    private ExtendedDataEntity getExtendedDataEntityById(Long id) {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            Long basedataId = dynamicObject.getLong("id");
            if (basedataId.compareTo(id) != 0) continue;
            return dataEntity;
        }
        return null;
    }
}

