/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.web.filter;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import kd.bos.context.RequestContext;
import kd.bos.ext.hr.web.dto.HrUserRequestContextDTO;
import kd.bos.ext.hr.web.util.HrFilterUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class HrUserContextFilter
implements Filter {
    private static final Log LOGGER = LogFactory.getLog(HrUserContextFilter.class);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        Cookie hrUserCookie = HrFilterUtil.getHrUserCookie(request);
        String referer = request.getHeader("Referer");
        if (hrUserCookie != null && StringUtils.isNotEmpty((String)referer)) {
            LOGGER.info("Got referer: {}.", (Object)referer);
            URL refererUrl = new URL(referer);
            String refererPath = refererUrl.getPath();
            String query = refererUrl.getQuery();
            Map<String, String> queryMap = null;
            if (StringUtils.isNotEmpty((String)query) && query.contains("=")) {
                try {
                    queryMap = this.split("&", "=", query);
                }
                catch (Exception ex) {
                    LOGGER.error("resolveReferQueryError:", (Throwable)ex);
                }
            }
            String requestContextPath = request.getContextPath();
            String requestFormKey = HrFilterUtil.getRequestFormKey(request, refererPath);
            String loginFormId = HrFilterUtil.getRequestCommonLoginFormId(request, refererPath);
            LOGGER.info("Got params queryMap: {}, refererPath: {}, requestContextPath: {}, requestFormKey: {}, loginFormId: {}.", new Object[]{queryMap, refererPath, requestContextPath, requestFormKey, loginFormId});
            if (queryMap != null && queryMap.containsKey("loginConfigNumber") && queryMap.containsKey(requestFormKey) && !queryMap.get(requestFormKey).equals(loginFormId)) {
                LOGGER.info("Enter request context.");
                String loginConfigNumber = queryMap.get("loginConfigNumber");
                RequestContext requestContext = RequestContext.get();
                if (StringUtils.isEmpty((String)requestContext.getYzjAppTicket())) {
                    LOGGER.info("Request ticket is empty with value: {}.", (Object)hrUserCookie.getValue());
                    HrUserRequestContextDTO hrUserContextDTO = new HrUserRequestContextDTO(hrUserCookie.getValue(), HrFilterUtil.getClientType(request, loginConfigNumber));
                    requestContext.setYzjAppTicket(JSONUtils.toString((Object)hrUserContextDTO));
                } else {
                    LOGGER.info("Request ticket is not empty.");
                }
            } else {
                LOGGER.info("Got empty queryMap.");
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    private Map<String, String> split(String separatorPattern, String separator, String sequence) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String item : sequence.split(separatorPattern)) {
            String[] pair = item.split(separator);
            map.putIfAbsent(pair[0].trim(), pair.length > 1 ? pair[1].trim() : "");
        }
        return map;
    }
}

