/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.web.util;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.ext.hr.web.util.HrUserCacheUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.http.KDHttpServletRequestWrapper;
import kd.bos.login.utils.AgentUtil;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.service.web.filter.HttpServletRequestWrapper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.session.SessionInfo;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.url.UrlService;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.RevProxyUtil;
import org.eclipse.jetty.server.Request;

public class HrFilterUtil {
    private static final Log LOGGER = LogFactory.getLog(HrFilterUtil.class);
    public static final String HR_USER_COOKIE = "KHRSESSIONID";
    public static final String HR_COMMONLOGIN_FORMID = "hbss_commonlogin";

    public static void createGuestRequestContext(HttpServletRequest request, String globalSessionId) {
        String tenantId = RevProxyUtil.getTenantId((HttpServletRequest)request);
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)globalSessionId);
        Map sessionInfoMap = sessionDAO.getAttributesAsMap(new String[]{"tenantId", "sandboxId", "language", "userId", "userName", "userOpenId", "orgId", "userType", "yzjAppId", "yzjAppTicket", "kdCsrfToken", "accountId", "uid", "loginIP", "loginOrg", "client", "accCompanyId", "api3rdAppId", "bizPartnerId"});
        String accountId = (String)sessionInfoMap.get("accountId");
        String sandboxId = (String)sessionInfoMap.get("sandboxId");
        String userId = (String)sessionInfoMap.get("userId");
        long orgId = 0L;
        if (!StringUtils.isEmpty((String)((String)sessionInfoMap.get("orgId")))) {
            orgId = Long.parseLong((String)sessionInfoMap.get("orgId"));
        }
        String lang = (String)sessionInfoMap.get("language");
        String userName = (String)sessionInfoMap.get("userName");
        String userOpenId = (String)sessionInfoMap.get("userOpenId");
        String userType = (String)sessionInfoMap.get("userType");
        String yzjAppId = (String)sessionInfoMap.get("yzjAppId");
        String yzjAppTicket = (String)sessionInfoMap.get("yzjAppTicket");
        String uId = (String)sessionInfoMap.get("uid");
        String loginOrg = (String)sessionInfoMap.get("loginOrg");
        String client = (String)sessionInfoMap.get("client");
        String api3rdAppId = (String)sessionInfoMap.get("api3rdAppId");
        String accCompany = (String)sessionInfoMap.get("accCompanyId");
        SessionInfo si = new SessionInfo();
        si.setTenantId(tenantId);
        si.setSandboxId(sandboxId);
        si.setOrgId(String.valueOf(orgId));
        si.setUserId(userId);
        si.setUserName(userName);
        si.setUserOpenId(userOpenId);
        si.setUserType(userType);
        si.setYzjAppId(yzjAppId);
        si.setYzjAppTicket(yzjAppTicket);
        si.setLanguage(lang);
        si.setUid(uId);
        si.setAccCompany(accCompany);
        si.setAccountId(accountId);
        si.setClient(client);
        if ("api".equalsIgnoreCase(client)) {
            si.setApi3rdAppId(api3rdAppId);
        }
        if (loginOrg != null) {
            si.setLoginOrg(loginOrg);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)((String)sessionInfoMap.get("bizPartnerId")))) {
            si.setBizPartnerId((String)sessionInfoMap.get("bizPartnerId"));
        }
        RequestContextCreator.create((HttpServletRequest)request, (String)globalSessionId, (SessionInfo)si);
    }

    public static void addClientCookie(HttpServletRequest request, HttpServletResponse response, String cookieName, String cookieValue) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)cookieName) && kd.bos.util.StringUtils.isNotEmpty((String)cookieValue)) {
            Cookie newCookie = new Cookie(cookieName, cookieValue);
            String tenantId = RevProxyUtil.getTenantId((HttpServletRequest)request);
            newCookie.setSecure(HrFilterUtil.isSecure(tenantId));
            newCookie.setPath(HrFilterUtil.getCookiePath(tenantId));
            response.addCookie(newCookie);
        }
    }

    public static void removeClientCookie(HttpServletRequest request, HttpServletResponse response, String cookieName) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)cookieName)) {
            Cookie newCookie = new Cookie(cookieName, null);
            String tenantId = RevProxyUtil.getTenantId((HttpServletRequest)request);
            newCookie.setSecure(HrFilterUtil.isSecure(tenantId));
            newCookie.setPath(HrFilterUtil.getCookiePath(tenantId));
            newCookie.setMaxAge(0);
            response.addCookie(newCookie);
        }
    }

    public static void removeCookieAndSession(HttpServletRequest request, HttpServletResponse response, String cookieName, String hrGlobalSessionId) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)cookieName)) {
            HrFilterUtil.removeClientCookie(request, response, cookieName);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)hrGlobalSessionId)) {
            String accountId = RequestContext.get().getAccountId();
            HrUserCacheUtil.remove(accountId, hrGlobalSessionId);
        }
    }

    public static String handleSessionTimeout(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, Cookie hrUserCookie, String loginConfigNumber) throws IOException, ServletException {
        String globalSessionId;
        if (hrUserCookie != null) {
            HrFilterUtil.removeClientCookie(request, response, hrUserCookie.getName());
        }
        if ((globalSessionId = HrFilterUtil.getKDGlobalSessionId(request)) == null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return "";
        }
        HrFilterUtil.createGuestRequestContext(request, globalSessionId);
        String accountId = RequestContext.get().getAccountId();
        String referer = request.getHeader("Referer");
        if (kd.bos.util.StringUtils.isNotEmpty((String)referer)) {
            URL refererUrl = new URL(referer);
            String query = refererUrl.getQuery();
            Map queryMap = null;
            if (kd.bos.util.StringUtils.isNotEmpty((String)query) && query.contains("=")) {
                try {
                    queryMap = Splitter.onPattern((String)"&").trimResults().withKeyValueSeparator("=").split((CharSequence)query);
                }
                catch (Exception ex) {
                    LOGGER.error("resolveReferQueryError:{}", (Object)ex.getMessage());
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append(HrFilterUtil.getDomainContextUrl(request) + HrFilterUtil.getRequestHtmlPath(request, refererUrl.getPath()) + "?userId=Guest&needReset=true").append("&accountId=").append(accountId).append("&kdcdc=").append(accountId);
            if (queryMap != null) {
                if (queryMap.containsKey("form")) {
                    sb.append("&form=").append((String)queryMap.get("form"));
                }
                if (queryMap.containsKey("formId")) {
                    sb.append("&form=").append((String)queryMap.get("formId"));
                }
                if (queryMap.containsKey("loginConfigNumber")) {
                    sb.append("&loginConfigNumber=").append((String)queryMap.get("loginConfigNumber"));
                }
                if (queryMap.containsKey("bizUserId")) {
                    sb.append("&bizUserId=").append((String)queryMap.get("bizUserId"));
                }
                if (queryMap.containsKey("bizCustomParam")) {
                    sb.append("&bizCustomParam=").append((String)queryMap.get("bizCustomParam"));
                }
                if (queryMap.containsKey("language")) {
                    sb.append("&language=").append((String)queryMap.get("language"));
                }
            }
            return sb.toString();
        }
        return HrFilterUtil.getFormUrlByGuest(request, accountId, HrFilterUtil.getClientUrlExpiryFormId(request, loginConfigNumber), loginConfigNumber);
    }

    public static String getKDGlobalSessionId(HttpServletRequest request) {
        String globalSessionId = LoginUtils.getKDCookieValue((HttpServletRequest)request);
        if (!SessionUtils.verifyCookieSession((HttpServletRequest)request, (String)globalSessionId)) {
            globalSessionId = null;
        }
        return globalSessionId;
    }

    public static Account getCurrentAccount(HttpServletRequest request) {
        String tenantId = RevProxyUtil.getTenantId((HttpServletRequest)request);
        String accountId = LoginUtils.getParamerter((HttpServletRequest)request, (String)"accountId");
        if (null == accountId || 0 == accountId.trim().length()) {
            accountId = LoginUtils.getParamerter((HttpServletRequest)request, (String)"a");
        }
        LOGGER.info("Got step1 accountId: {}.", (Object)accountId);
        if (null == accountId || 0 == accountId.trim().length()) {
            try {
                Map<String, String> queryMap = HrFilterUtil.getRefererQueryParamMap(request);
                accountId = queryMap.get("accountId");
            }
            catch (MalformedURLException exception) {
                LOGGER.error("Got MalformedURLException exception.", (Throwable)exception);
            }
        }
        LOGGER.info("Got step2 accountId: {}.", (Object)accountId);
        return AccountUtils.getCorrectAccount((String)accountId, (String)tenantId);
    }

    public static Map<String, String> getRefererQueryParamMap(HttpServletRequest request) throws MalformedURLException {
        Map<String, String> queryMap = null;
        String referer = request.getHeader("Referer");
        if (kd.bos.util.StringUtils.isEmpty((String)referer)) {
            return queryMap;
        }
        URL refererUrl = new URL(referer);
        String query = refererUrl.getQuery();
        if (kd.bos.util.StringUtils.isNotEmpty((String)query) && query.contains("=")) {
            try {
                queryMap = HrFilterUtil.split("&", "=", query);
            }
            catch (Exception ex) {
                LOGGER.info("Got referer: {}.", (Object)referer);
                LOGGER.error("resolveReferQueryError", (Throwable)ex);
            }
        }
        return queryMap;
    }

    public static Map<String, String> split(String separatorPattern, String separator, String sequence) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String item : sequence.split(separatorPattern)) {
            String[] pair = item.split(separator);
            map.putIfAbsent(pair[0].trim(), pair.length > 1 ? pair[1].trim() : "");
        }
        return map;
    }

    private static boolean isSecure(String tenantAlias) {
        boolean isSecure = false;
        String domain = UrlService.getDomainContextUrlByTenantCode((String)tenantAlias);
        try {
            URI url = new URI(domain);
            if ("https".equalsIgnoreCase(url.getScheme())) {
                isSecure = true;
            }
        }
        catch (URISyntaxException var4) {
            LOGGER.warn((Throwable)var4);
        }
        return isSecure;
    }

    public static String getCookiePath(String tenantAlias) {
        String root = "/";
        String pathString = SystemPropertyUtils.getProptyByTenant((String)"cookie_domain_path", (String)tenantAlias);
        return kd.bos.util.StringUtils.isNotEmpty((String)pathString) ? root + pathString.trim() : root;
    }

    public static String crlfFilter(String inputParam) {
        if (kd.bos.util.StringUtils.isEmpty((String)inputParam)) {
            return "";
        }
        inputParam = inputParam.replace("/n", "");
        inputParam = inputParam.replace("\n", "");
        inputParam = inputParam.replace("/r", "");
        inputParam = inputParam.replace("\r", "");
        return inputParam;
    }

    public static String getHtmlUriParam(String accountId, String loginConfigNumber, String bizUserId, String bizCustomParam) {
        StringBuilder sb = new StringBuilder();
        sb.append("accountId=").append(accountId).append("&loginConfigNumber=").append(loginConfigNumber).append("&bizUserId=" + bizUserId);
        if (kd.bos.util.StringUtils.isNotEmpty((String)bizCustomParam)) {
            sb.append("&bizCustomParam=" + bizCustomParam);
        }
        return sb.toString();
    }

    public static boolean isIndexHTML(HttpServletRequest request) {
        boolean isIndexHTML = false;
        String path = request.getRequestURI();
        String context = request.getContextPath();
        String xpath = null;
        if (path != null) {
            xpath = path.replace(context + "/", "");
        }
        if (xpath != null && xpath.toLowerCase(Locale.ENGLISH).startsWith("index.html")) {
            isIndexHTML = true;
        }
        if (!isIndexHTML && xpath != null && kd.bos.util.StringUtils.isEmpty((String)xpath)) {
            isIndexHTML = true;
        }
        return isIndexHTML;
    }

    public static String getFormUrlByGuest(HttpServletRequest request, String accountId, String formId, String loginConfigNumber) {
        String domainContextUrl = HrFilterUtil.getDomainContextUrl(request);
        String htmlPath = HrFilterUtil.getClientHtmlPath(request, loginConfigNumber);
        StringBuilder sb = new StringBuilder();
        sb.append(domainContextUrl).append(htmlPath).append("?userId=Guest&needReset=true").append("&accountId=").append(accountId).append("&kdcdc=").append(accountId).append("&").append(HrFilterUtil.getClientFormKey(request, loginConfigNumber)).append("=").append(formId);
        return sb.toString();
    }

    public static String getDomainContextUrl(HttpServletRequest request) {
        if (RequestContext.get() != null) {
            return UrlService.getDomainContextUrl();
        }
        Account currentCenter = HrFilterUtil.getCurrentAccount(request);
        Map userMap = LoginUtils.getClientUserInfo((String)RevProxyUtil.getTenantId((HttpServletRequest)request));
        LoginUtils.createGuestRequestContext((HttpServletRequest)request, (Account)currentCenter);
        String url = UrlService.getDomainContextUrl();
        RequestContext.set(null);
        return url;
    }

    public static Cookie getHrUserCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        String tenantAlias = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        String hrUserSessionCookieName = HrFilterUtil.getHrUserSessionCookieName(tenantAlias);
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(hrUserSessionCookieName) || !kd.bos.util.StringUtils.isNotEmpty((String)cookie.getValue())) continue;
            return cookie;
        }
        return null;
    }

    public static Cookie getCookieByName(HttpServletRequest request, String cookieName) {
        if (kd.bos.util.StringUtils.isEmpty((String)cookieName)) {
            return null;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(cookieName) || !kd.bos.util.StringUtils.isNotEmpty((String)cookie.getValue())) continue;
            return cookie;
        }
        return null;
    }

    private static String getHrUserSessionCookieName(String tenantAlias) {
        return HR_USER_COOKIE + tenantAlias;
    }

    public static String getURI(ServletRequest paramServletRequest) {
        String uri = null;
        String contextPath = null;
        if (paramServletRequest instanceof KDHttpServletRequestWrapper) {
            KDHttpServletRequestWrapper httpServletRequestWrapper = (KDHttpServletRequestWrapper)paramServletRequest;
            uri = httpServletRequestWrapper.getRequestURI();
            contextPath = httpServletRequestWrapper.getContextPath();
        } else if (paramServletRequest instanceof Request) {
            uri = ((Request)paramServletRequest).getOriginalURI();
            contextPath = ((Request)paramServletRequest).getContextPath();
        } else if (paramServletRequest instanceof HttpServletRequestWrapper) {
            uri = ((HttpServletRequestWrapper)paramServletRequest).getRequestURI();
            contextPath = ((HttpServletRequestWrapper)paramServletRequest).getContextPath();
        } else {
            uri = ((HttpServletRequest)paramServletRequest).getRequestURI();
            contextPath = ((HttpServletRequest)paramServletRequest).getContextPath();
        }
        uri = uri.split("\\?")[0];
        return uri.substring(contextPath.length());
    }

    public static String xssEncode(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length() + 16);
        block11: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '>': {
                    sb.append('\uff1e');
                    continue block11;
                }
                case '<': {
                    sb.append('\uff1c');
                    continue block11;
                }
                case '\'': {
                    sb.append('\u2018');
                    continue block11;
                }
                case '\"': {
                    sb.append('\u201c');
                    continue block11;
                }
                case '&': {
                    sb.append('\uff06');
                    continue block11;
                }
                case '\\': {
                    sb.append('\uff3c');
                    continue block11;
                }
                case '#': {
                    sb.append('\uff03');
                    continue block11;
                }
                case '(': {
                    sb.append('\uff08');
                    continue block11;
                }
                case ')': {
                    sb.append('\uff09');
                    continue block11;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String getClientType(HttpServletRequest request, String loginConfigNumber) {
        LOGGER.info("Got client type params loginConfigNumber: {}.", (Object)loginConfigNumber);
        String result = "";
        if (kd.bos.util.StringUtils.isNotEmpty((String)loginConfigNumber)) {
            RequestContext old = RequestContext.get();
            Account currentCenter = HrFilterUtil.getCurrentAccount(request);
            LoginUtils.createGuestRequestContext((HttpServletRequest)request, (Account)currentCenter);
            DynamicObject[] items = BusinessDataServiceHelper.load((String)"hbss_loginconfig", (String)"redirectform,redirectappformid", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)loginConfigNumber)});
            LOGGER.info("Got login config data size: {} with loginConfigNumber: {}.", (Object)items.length, (Object)loginConfigNumber);
            if (items.length > 0) {
                String mobileRedirectForm = items[0].getString("redirectform");
                String pcRedirectForm = items[0].getString("redirectappformid");
                LOGGER.info("Got mobileRedirectForm: {} and pcRedirectForm: {}.", (Object)mobileRedirectForm, (Object)pcRedirectForm);
                if (kd.bos.util.StringUtils.isEmpty((String)mobileRedirectForm) && kd.bos.util.StringUtils.isNotEmpty((String)pcRedirectForm)) {
                    result = "web";
                }
                if (kd.bos.util.StringUtils.isEmpty((String)pcRedirectForm) && kd.bos.util.StringUtils.isNotEmpty((String)mobileRedirectForm)) {
                    result = "mobile";
                }
            }
            RequestContext.set((RequestContext)old);
        }
        LOGGER.info("Got step1 result: {}.", (Object)result);
        if (kd.bos.util.StringUtils.isNotEmpty((String)result)) {
            return result;
        }
        LoginClientEnum loginClientType = AgentUtil.getLoginClientEnumType((HttpServletRequest)request);
        LOGGER.info("Got step2 result: {}.", (Object)loginClientType);
        if (loginClientType == LoginClientEnum.WEB) {
            return "web";
        }
        return "mobile";
    }

    public static String getClientHtmlPath(HttpServletRequest request, String loginConfigNumber) {
        String clientType = HrFilterUtil.getClientType(request, loginConfigNumber);
        if (clientType.equals("web")) {
            return "/index.html";
        }
        return "/mobile.html";
    }

    public static String getClientFormKey(HttpServletRequest request, String loginConfigNumber) {
        String clientType = HrFilterUtil.getClientType(request, loginConfigNumber);
        if (clientType.equals("web")) {
            return "formId";
        }
        return "form";
    }

    public static String getClientCommonLoginFormId(HttpServletRequest request, String loginConfigNumber) {
        String clientType = HrFilterUtil.getClientType(request, loginConfigNumber);
        if (clientType.equals("web")) {
            return "hbss_commonloginpc";
        }
        return HR_COMMONLOGIN_FORMID;
    }

    public static String getClientUrlExpiryFormId(HttpServletRequest request, String loginConfigNumber) {
        String clientType = HrFilterUtil.getClientType(request, loginConfigNumber);
        if (clientType.equals("web")) {
            return "hbss_safeuriexpirypc";
        }
        return "hbss_safeuriexpiry";
    }

    public static String getClientIP(HttpServletRequest request) {
        return NetAddressUtils.getRemoteHost((HttpServletRequest)request);
    }

    public static boolean isIndexHTML(HttpServletRequest request, String refererPath) {
        boolean isIndexHTML = false;
        String path = refererPath;
        String context = request.getContextPath();
        String xpath = null;
        if (path != null) {
            xpath = path.replace(context + "/", "");
        }
        if (xpath != null && xpath.toLowerCase(Locale.ENGLISH).startsWith("index.html")) {
            isIndexHTML = true;
        }
        if (!isIndexHTML && xpath != null && kd.bos.util.StringUtils.isEmpty((String)xpath)) {
            isIndexHTML = true;
        }
        if (!isIndexHTML && null != refererPath && refererPath.contains("index.html")) {
            isIndexHTML = true;
        }
        return isIndexHTML;
    }

    public static String getRequestHtmlPath(HttpServletRequest request, String refererPath) {
        boolean isIndexHtml = HrFilterUtil.isIndexHTML(request, refererPath);
        if (isIndexHtml) {
            return "/index.html";
        }
        return "/mobile.html";
    }

    public static String getRequestFormKey(HttpServletRequest request, String refererPath) {
        boolean isIndexHtml = HrFilterUtil.isIndexHTML(request, refererPath);
        if (isIndexHtml) {
            return "formId";
        }
        return "form";
    }

    public static String getRequestCommonLoginFormId(HttpServletRequest request, String refererPath) {
        boolean isIndexHtml = HrFilterUtil.isIndexHTML(request, refererPath);
        if (isIndexHtml) {
            return "hbss_commonloginpc";
        }
        return HR_COMMONLOGIN_FORMID;
    }
}

