package kd.bos.ext.imc.common.constant;

public class OriginalBillConstant {
	public static final String FORM_ID = "sim_original_bill";
	public static final String ITEM_KEY = "sim_original_bill_item";
	public static final String ID = "id";

	//所属批次
	public static final String BATCHBELONG = "batchbelong";
    /***业务单据编号   fbillno***/
    public static final String BILLNO="billno";
    /***单据日期   fbilldate***/
    public static final String BILLDATE="billdate";
    /***单据税额  ftotaltax***/
    public static final String TOTALTAX="totaltax";
    /***原始价税合计   foldtotalamount***/
    public static final String OLDTOTALAMOUNT="oldtotalamount";
    /***单据金额   finvoiceamount***/
    public static final String INVOICEAMOUNT="invoiceamount";
    /***价税合计   ftotalamount***/
    public static final String TOTALAMOUNT="totalamount";
    /***单据税率   fbilltaxrate***/
    public static final String BILLTAXRATE="billtaxrate";
    /***已确认金额   fconfirmamount***/
    public static final String CONFIRMAMOUNT="confirmamount";
    /**待冲蓝票代码*/
    public static final String BLUEINVOICECODE = "blueinvoicecode";
    /**待冲蓝票号码*/
    public static final String BLUEINVOICENO = "blueinvoiceno";
    /**原蓝票开票时间*/
    public static final String BLUEISSUETIME = "originalissuetime";
    //原数电号码
    public static final String ORIGINAL_ETAX_INVOICENO = "originaletaxinvoiceno";

    // 原开票时间
    /**发票号码*/
    public static final String TAXADJUST = "taxadjust";

    /***申请状态   fconfirmstate 0-未申请 1-部分申请 2-已申请 ***/
    public static final String CONFIRMSTATE="confirmstate";
    /***币别   fcurrency***/
    public static final String CURRENCY="currency";
    /***汇率   fexchangerate***/
    public static final String EXCHANGERATE="exchangerate";
    /***单据类型   fbilltype***/
    public static final String BILLTYPE="billtype";
    /***单据名称   fbilltype***/
    public static final String BILLTYPE_NAME = "billtypebase.name";

    /***微信userid   fwxid***/
    public static final String WXID = "wxid";
    /***作废原因   fabolishreason ***/
    public static final String ABOLISHREASON = "abolishreason";


    public static class BillTypeNumEnum{
        /** 标准销售应收 **/
        public static final String ARFIN_STANDARD_NUM = "arfin_standard_BT_S";
        /** 标准费用应收 **/
        public static final String ARFIN_EXPENSE_NUM = "arfin_expense_BT_S";
        /** 其他应收 **/
        public static final String ARFIN_OTR_NUM = "arfin_other_BT_S";
        /** 借贷项应收 **/
        public static final String ARFIN_BORROW_NUM = "arfin_borrowar_BT_S";
        /** 服务销售应收 **/
        public static final String ARFIN_SERSAL_NUM = "arfin_sersal_BT_S";
        /** 销售费用应收 **/
        public static final String ARFIN_SALEFEE_NUM = "arfin_salefee_BT_S";
    }
    // 已开金额
    public static final String MAIN_ISSUED_AMOUNT = "mainissuedamount";
    // 已开税额
    public static final String MAIN_ISSUED_TAX = "mainissuedtax";
    // 剩余可开金额
    public static final String SURPLUS_AMOUNT = "surplusamount";
    // 剩余可开税额
    public static final String SURPLUS_TAX = "surplustax";
    // 税额误差
    public static final String MAIN_TAX_DEVIATION = "maintaxdeviation";
    // 拆分合并标志
    public static final String SPLIT_OR_MERGE_FLAG = "splitormergeflag";
    // 0不拆分不合并，1要拆分不合并，2不拆分要合并，3要拆分要合并
    public static class SplitOrMergeFlagEnum{
        public static final String NO_SPLIT_NO_MERGE = "0";
        public static final String SPLIT_NO_MERGE = "1";
        public static final String MERGE_NO_SPLIT = "2";
        public static final String SPLIT_MERGE = "3";
    }
    // 业务类型
    public static final String BIZ_TYPE = "biztype";

    //审核意见
    public static final String AUDIT_SUGGESTION="auditsuggestion";

    public static final String SETTLEMENT_ORGBASE_NAME="settlementorgbase.name";
    //botp下推类型
    public static final String BOTPTYPE="botptype";

    public static final String MERGELABLE="mergelable";
    //发票代码
    public static final String INVOICE_CODE="invoicecode";
    //发票号码
    public static final String INVOICE_NO="invoiceno";
    //开票日期
    public static final String ISSUE_TIME="issuetime";
    //发票状态
    public static final String INVOICE_STATUS="invoicestatus";
    //发票总价税合计
    public static final String INVOICED_TOTAL_AMOUNT="invoicedtotalamount";
    //发票税额
    public static final String INVOICED_TAX="invoicedtax";
    //发票金额
    public static final String INVOICED_AMOUNT="invoicedamount";
    //单据是否完整
    public static final String BILL_COMPLETE="billcomplete";

    public static final String EDITABLE = "editable";
    //关闭状态，用来控制是否可以继续下推，已关闭不能继续下推
    public static final String CLOSESTATUS = "closestatus";
    //单据类型
    public static final String BILLSOURCETYPE = "billsourcetype";
    //-----------------------------------------------外币相关字段-----------  TODO FROM BODY
    //原币已开不含税金额
    public static final String FOREIGN_ISSUED_AMOUNT = "foreignissuedamount";
    //原币不含税金额
    public static final String FOREIGN_INVOICE_AMOUNT = "foreigninvoiceamount";
    //原币税额
    public static final String FOREIGN_TAX = "foreigntax";
    //原币价税合计
    public static final String FOREIGN_TOTAL_AMOUNT = "foreigntotalamount";
    //原币已开价税合计
    public static final String FOREIGN_ISSUED_TOTAL_AMOUNT = "foreignissuedtotalamount";
    //原币已开税额
    public static final String FOREIGN_ISSUED_TAX = "foreignissuedtax";
    //原币税额误差
    public static final String FOREIGN_TAX_DIFFERENCE = "foreigntaxdifference";
    //币别
    public static final String FROM_CURR = "fromcurr";
    //本位币
    public static final String TO_CURR = "tocurr";
    //汇率表
    public static final String EXRATE_TABLE = "exratetable";
    /***汇率日期   fexchangedate***/
    public static final String EXCHANGEDATE="exchangedate";
    //汇率
    public static final String EXRATE = "exrate";
    //换算方式
    public static final String QUOTATION = "quotation";
    //数电纸票
    public static final String IS_ELE_PAPER = "iselepaper";

    //------------------------------------------------外币相关字段----------

    public static class BillSourceTypeEnum{
        public static final String NORMAL_BILL = "A";
        public static final String RED_BILL = "B";
        public static final String INVALID_BILL = "C";
        public static final String REOPEN_BILL = "D";
    }

    public static boolean isSpecialSourcType(Object sourceType){
        return BillSourceTypeEnum.RED_BILL.equals(sourceType) || BillSourceTypeEnum.INVALID_BILL.equals(sourceType) || BillSourceTypeEnum.REOPEN_BILL.equals(sourceType);
    }

    public static class Editable{
        public static final String YES = "0";
        public static final String NO = "1";
    }

    public static  class Complete{
        public static final String YES = "0";
        public static final String NO = "1";
    }

    public static class MergeLable{
        public static final String NUM_ONE = "1";
        public static final String NUM_TWO = "2";

    }

    public static class CloseStatusEnum{
        public static final String OPEN = "0";
        public static final String CLOSED = "1";

    }

    public static class ConfirmStateEnum {
        public static final String UNCONFIRMED = "0";
        public static final String PART_CONFIRM = "1";
        public static final String CONFIRMED = "2";
    }
    /***有效状态   fvalidstate***/
    public static final String VALIDSTATE="validstate";
    public static class ValidStateEnum {
        public static final String NORMAL = "0";
        public static final String SHELVE = "1";
        public static final String ISSUE_END = "2";
    }
    /***是否拆分   fsplit***/
    public static final String SPLIT="split";
    public static class SplitEnum {
        public static final String SPLIT = "0";
        public static final String UNSPLIT = "1";
    }
    /***优先级   fpriority***/
    public static final String PRIORITY="priority";
    public static class PriorityEnum{
        public static final String NORMAL = "0";
        public static final String URGENT = "1";
    }
    /***单据是否含税   fhsbz***/
    public static final String HSBZ="hsbz";
    public static class HSBZEnum{
        public static final String NO_INCLUDE_TAX = "0";//不含税
        public static final String INCLUDE_TAX = "1";//含税
    }
    /***设备编号   fjqbh***/
    public static final String JQBH="jqbh";
    /***终端号   fterminalno***/
    public static final String TERMINALNO="terminalno";
    /***数据来源系统   fsystemsource***/
    public static final String SYSTEMSOURCE="systemsource";

    /***征税方式   ftaxationstyle***/
    public static final String TAXATIONSTYLE="taxationstyle";
    public static class TaxationStyleEnum{
        public static final String NORMAL = "0";//普通
        public static final String REDUCED_LEVY = "1";//减按计征
        public static final String DIFFERENCE_LEVY = "2";//差额征税
    }

    /***单据性质   fbillproperties***/
    public static final String BILLPROPERTIES="billproperties";
    public static class BillPropertiesEnum {
        // 正数
        public static final String BLUE = "1";
        // 负数
        public static final String RED = "-1";
    }
    public static class BillSpecialEnum {
        // 正数
        public static final String BLUE = "1";
        // 负数
        public static final String RED = "-1";
    }
    /***开票要求(备注)   fbillremark***/
    public static final String BILLREMARK="billremark";
    /***购方名称   fbuyername***/
    public static final String BUYERNAME="buyername";
    /***购方纳税人识别号   fbuyertaxno***/
    public static final String BUYERTAXNO="buyertaxno";
    /***购方地址、电话   fbuyeraddr***/
    public static final String BUYERADDR="buyeraddr";
    /***购方开户行及账号   fbuyerbank***/
    public static final String BUYERBANK="buyerbank";
    /***收票人名称   fbuyerpersonname***/
    public static final String BUYERPERSONNAME="buyerpersonname";
    /***收票人电话   fbuyerphone***/
    public static final String BUYERPHONE="buyerphone";
    /***收票人邮箱   fbuyeremail***/
    public static final String BUYEREMAIL="buyeremail";
    /***购方企业类型   fbuyerproperty***/
    public static final String BUYERPROPERTY="buyerproperty";

    public static class BuyerPropertyEnum {
        public static final String PERSONAL = "1";
        public static final String ENTERPRISE = "0";
    }

    /***销方开户行及账号   fsalerbank***/
    public static final String SALERBANK="salerbank";
    /***销方税号   fsalertaxno***/
    public static final String SALERTAXNO="salertaxno";
    /***销方地址电话   fsaleraddr***/
    public static final String SALERADDR="saleraddr";
    /***销方名称   fsalername***/
    public static final String SALERNAME="salername";
    /***发票种类   finvoicetype***/
    public static final String INVOICETYPE="invoicetype";
    /***发票备注   finvoiceremark***/
    public static final String INVOICEREMARK="invoiceremark";
    /***开票人   fdrawer***/
    public static final String DRAWER = "drawer";
    /***收款人   fpayee***/
    public static final String PAYEE="payee";
    /***复核人   freviewer***/
    public static final String REVIEWER="reviewer";
    /***合同编号   fcontractno***/
    public static final String CONTRACTNO="contractno";
    /***采购商名称   fpurchasername***/
    public static final String PURCHASERNAME="purchasername";
    /***采购商联系人   fpurchasercontact***/
    public static final String PURCHASERCONTACT="purchasercontact";
    /***合同日期   fcontractdate***/
    public static final String CONTRACTDATE="contractdate";
    /***合同金额   fcontractamount***/
    public static final String CONTRACTAMOUNT="contractamount";
    /***采购商电话   fpurchaserphone***/
    public static final String PURCHASERPHONE="purchaserphone";
    /***供应商名称   fsuppliername***/
    public static final String SUPPLIERNAME="suppliername";
    /***供应商联系人   fsuppliercontact***/
    public static final String SUPPLIERCONTACT="suppliercontact";
    /***供应商电话   fsupplierphone***/
    public static final String SUPPLIERPHONE="supplierphone";
    /**单据所属组织*/
    public static final String ORG_ID = "orgid";
    /***扣除额   fdeduction***/
    public static final String DEDUCTION="deduction";
    /***创建时间   createdate***/
    public static final String CREATEDATE="createdate";
    /***批次序号   originbillseq***/
    public static final String ORIGINBILLSEQ="originbillseq";
    /***业务系统来源   billsource***/
    public static final String BILLSOURCE="billsource";
    /**特殊票种 specialtype*/
    public static final String SPECIALTYPE="specialtype";
    /***待冲发票种类   fblueinvoicetype***/
    public static final String BLUEINVOICETYPE="blueinvoicetype";
    /***红冲原因   fhongchongreason***/
    public static final String REDREASON="redreason";

    /**合并分组规则，差额不合并，则设置为不同的key specialtype*/
    public static final String MERGEKEY = "mergekey";

    /**商品类型*/
    public static final String PRODUCTTYPE = "producttype";

    /**商品类型枚举*/

    public static class ProductTypeEnum {
        //开票项
        public static final String GOODSINFO = "1";
        //物料
        public static final String MATERIAL = "2";
        //费用项
        public static final String EXPENSE_ITEM = "3";
    }

    //红字信息表标号
    public static final String INFOCODE = "infocode";

    public static final String ORIGINALISSUETIME = "originalissuetime";
    /***申请方   fapplicant***/
    public static final String APPLICANT = "applicant";
    /***原购方名称   foribuyername***/
    public static final String ORIBUYERNAME="oribuyername";
    /***原购方地址电话   foribuyeraddr***/
    public static final String ORIBUYERADDR="oribuyeraddr";
    /***原购方开户行电话   foribuyerbank***/
    public static final String ORIBUYERBANK="oribuyerbank";
    /***拆合规则   fsplitrule***/
    public static final String SPLITRULE = "splitrule";
    /***拆合规则   fsplitrule***/
    public static final String MERGERULE = "mergerule";
    /***主表备注5   ftextfield5***/
    public static final String TEXTFIELD5="textfield5";
    /***主表备注4   ftextfield4***/
    public static final String TEXTFIELD4="textfield4";
    /***主表备注3   ftextfield3***/
    public static final String TEXTFIELD3="textfield3";
    /***主表备注2   ftextfield2***/
    public static final String TEXTFIELD2="textfield2";
    /***主表备注1   ftextfield1***/
    public static final String TEXTFIELD1="textfield1";

    /***单据审批状态   fbillstatus***/
    public static final String BILLSTATUS="billstatus";
    /***下推参数   fbotpparamconfig***/
    public static final String BOTPPARAMCONFIG="botpparamconfig";


    /**销售组织*/
    public static final String SALES_ORG="salesorg";
    /**结算组织**/
    public static final String SETTLEMENT_ORG="settlementorg";
    /**资金组织**/
    public static final String CAPITAL_ORG="capitalorg";
    /**物料类型**/
    public static final String GOODSTYPE="goodstype";
    /**客户**/
    public static final String CUSTOMNAME = "customname";
    /** 单据类型实体 **/
    public static final String BILLTYPEBASE = "billtypebase";
    /** 创建人 **/
    public static final String CREATOR = "creator";
    /** 创建人名称 **/
    public static final String CREATOR_NAME = "creator.name";
    // 开票内容，数据库没有的字段
    public static final String INVOICECONTENT = "invoiceContent";
    //经办人
    public static final String OPERATOR = "operator";
    //购销身份
    public static final String SALERORBUYER = "salerorbuyer";

    // 不动产地址
    public static final String SIMPLEADDRESS = "simpleaddress";

    // 不动产详细地址
    public static final String DETAILADDRESS = "detailaddress";

    public static final String LEASEDATE = "leasedate";

    // 跨地（市）标志
    public static final String CROSSCITYSIGN = "crosscitysign";

    // 面积单位
    public static final String AREAUNIT = "areaunit";

    // 建筑项目名称
    public static final String BUILDINGNAME = "buildingname";

    // 土地增值税项目编号
    public static final String LANDTAXNO = "landtaxno";

    // 房屋产权证书/不动产权证号
    public static final String ESTATEID = "estateid";

    // 租赁期起
    public static final String STARTLEASEDATE = "startleasedate";

    // 租赁期止
    public static final String ENDLEASEDATE = "endleasedate";

    // 不动产单元代码/网签合同备案编号
    public static final String ESTATECODE = "estatecode";

    // 核定计税价格
    public static final String APPROVEDPRICE = "approvedprice";

    // 实际成交含税金额
    public static final String ACTUALTURNOVER = "actualturnover";

    //关联金额
    public static final String PUSHAMOUNT = "pushamount";
    //关联本币金额
    public static final String PUSHLOCALAMOUNT = "pushlocalamount";
    //未关联本币金额
    public static final String UNPUSHLOCALAMOUNT = "unpushlocalamount";
    //未关联金额
    public static final String UNPUSHAMOUNT = "unpushamount";
    public static final String CUSTOMNAMEID = "customnameid";



    public static class SalerOrBuyerEnum{
        public static final String SALER = "0";
        public static final String BUYER = "1";
    }

    public static class InvoiceContentEnum{
        public static final String redInfo = "1";
        public static final String bill = "2";
    }

    public static class InvoiceContentChangeEnum{
        // 可以切换
        public static final String yes = "1";
        // 不可切换
        public static final String no = "-1";
        // 切换开票内容可不变明细
        public static final String noImpact = "0";
    }

    public static class BillSourceEnum {
        public static final String EXCEL = "1";
        public static final String BUSINESS_SYSTEM = "2"; // 业务系统
        public static final String BILL_PUSH = "3"; // botp下推
        public static final String OTHER = "4";
        public static final String SCAN = "5";
        //手工新增
        public static final String NEW= "6";
        public static final String SCAN_PUSH_TITLE = "7";
    }

    public static class Item {
        /***分录id   FEntryID***/
        public static final String ENTRYID="entryid";
        /***分录行号   FSeq***/
        public static final String SEQ="seq";
        /***商品名称   fgoodsname***/
        public static final String GOODSNAME="goodsname";
        /***开票项编码   fspbm***/
        public static final String SPBM="spbm";
        /***规格型号   fspecification***/
        public static final String SPECIFICATION="specification";
        /***单位   funit***/
        public static final String UNIT="unit";
        /***单位换算率   ***/
        public static final String MODELNUMRATE = "modelnumrate";
        /***数量   fnum***/
        public static final String NUM="num";
        /***不含税单价   funitprice***/
        public static final String UNITPRICE="unitprice";
        /***含税单价   ftaxunitprice***/
        public static final String TAXUNITPRICE="taxunitprice";
        /***原始单价   foriunitprice***/
        public static final String ORIUNITPRICE="oriunitprice";
        /***不含税金额   famount***/
        public static final String AMOUNT="amount";
        /***含税金额   ftaxamount***/
        public static final String TAXAMOUNT="taxamount";
        /***税率   ftaxrate***/
        public static final String TAXRATE="taxrate";
        /***税额   ftax***/
        public static final String TAX="tax";
        /***发票行性质   frowtype***/
        public static final String ROWTYPE="rowtype";
        /***税收分类编码   fgoodscode***/
        public static final String GOODSCODE="goodscode";
        /***商品简称   fgoodssimplename***/
        public static final String GOODSSIMPLENAME="goodssimplename";
        /***优惠政策内容   fpolicycontants***/
        public static final String POLICYCONTANTS="policycontants";
        /***备注   fremark***/
        public static final String REMARK="remark";
        /***物料分类  "materialtype" ***/
        public static final String MATERIALTYPE = "materialtype";
        // 税收分类编辑基础资料
        public static final String TAXRATECODEID="taxratecodeid";
        //开票项id
        public static final String GOODSID="goodsid";


        /***已开数量   issuednum***/
        public static final String ISSUEDNUM="issuednum";
        /***原始已开数量   oriissuednum***/
        public static final String ORIISSUEDNUM="oriissuednum";

        /***剩余可申请数量   fremainvalidnum***/
        public static final String REMAINVALIDNUM="remainvalidnum";
        /***剩余可申请(开具)金额   fremainvalidamount***/
        public static final String REMAINVALIDAMOUNT="remainvalidamount";
        /***剩余可申请（开具）税额   fremainvalidtax***/
        public static final String REMAINVALIDTAX = "remainvalidtax";
        /***是否享受优惠   fpolicylogo***/
        public static final String POLICYLOGO="policylogo";
        /***折扣金额   fdiscountamount***/
        public static final String DISCOUNTAMOUNT="discountamount";
        /***折扣率  fdiscountrate***/
        public static final String DISCOUNTRATE="discountrate";
        /***单据来源明细id  fbillsourceid***/
        public static final String BILLSOURCEID="billsourceid";
        /***原始商品名称   forigoodsname***/
        public static final String ORIGOODSNAME="origoodsname";
        /***原始规格型号   forispecification***/
        public static final String ORISPECIFICATION="orispecification";
        /***原始单位   foriunit***/
        public static final String ORIUNIT="oriunit";
        //原始原币价税合计
        public static final String ORIFROMTAXAMOUNT="orifromtaxamount";
        /***原始数量   forinum***/
        public static final String ORINUM="orinum";
        /***备注1   fextrafield***/
        public static final String EXTRAFIELD="extrafield";
        /***备注2   fextrafield2***/
        public static final String EXTRAFIELD2="extrafield2";
        /***备注3   fextrafield3***/
        public static final String EXTRAFIELD3="extrafield3";
        /***备注4   fextrafield4***/
        public static final String EXTRAFIELD4="extrafield4";
        /***备注5   fextrafield5***/
        public static final String EXTRAFIELD5="extrafield5";
        /***税额尾差   ftaxdeviation***/
        public static final String TAXDEVIATION = "taxdeviation";
        /***金额(不含税)尾差   ftaxdeviation***/
        public static final String AMOUNTDEVIATION = "amountdeviation";
        /***数量尾差   ftaxdeviation***/
        public static final String NUMDEVIATION = "numdeviation";


        /***被折扣行明细主键   fdeductepkd***/
        public static final String DEDUCTEDPK = "deductedpk";
        /***关联金额   combineamount***/
        public static final String COMBINEAMOUNT="combineamount";

        /***已开金额   issuedamount***/
        public static final String ISSUEDAMOUNT="issuedamount";
        //已开税额
        public static final String ISSUEDTAX="issuedtax";
        //已开价税合计
        public static final String ISSUEDTOTALTAXAMOUNT="issuedtotaltaxamount";

        //费用项目
        public static final String EXPENSEITEM = "expenseitem";

        //物料
        public static final String MATERIELFIELD = "materielfield";

        //明细扣除额
        public static final String ITEMDEDUCTION = "itemdeduction";
        //原红字信息表编号
        public static final String SOUCEINFOCODE = "sourceinfocode";

        //原红字信息表明细id
        public static final String SOURCEINFODETAILID = "sourceinfodetailid";
        //基准类型
        public static final String BENCHMARK = "benchmark";
        //原始含税金额
        public static final String ORITAXAMOUNT = "oritaxamount";
        /** 0金额下推类型 **/
        public static final String ZEROPUSHFLAG = "zeropushflag";
        //关联数量
        public static final String COMBINENUM = "combinenum";

        //外币相关明细字段-------------------------------------------------------------  TODO FROM ITEM
        //原币单价含税
        public static final String FROM_TAX_PRICE = "fromtaxprice";
        //原币单价不含税
        public static final String FROM_PRICE = "fromprice";
        //明细原币金额
        public static final String FROM_AMOUNT = "fromamount";
        //原币已开金额
        public static final String FROM_ISSUED_AMOUNT = "fromissuedamount";
        //原币税额
        public static final String FROM_TAX = "fromtax";
        //原币已开税额
        public static final String FROM_ISSUED_TAX = "fromissuedtax";
        //原币折扣额
        public static final String FROM_DISCOUNT_AMOUNT = "fromdiscountamount";
        //原币税额尾差
        public static final String FROMTAXDEVIATION = "fromtaxdeviation";
        //原币含税金额
        public static final String FROM_TAX_AMOUNT = "fromtaxamount";
        //原币已开价税合计
        public static final String FROM_ISSUED_TAX_AMOUNT = "fromissuedtaxamount";

        //关联本币金额
        public static final String COMBINE_LOCAL_AMOUNT = "combinelocalamount";

        //赠品行
        public static final String GIFT_ROW = "gift";

        public static final String BLUE_INVOICE_ITEMID = "blueinvoiceitemid";


        //关联数量
        public static final String PUSHNUM = "pushnum";
        //未关联数量
        public static final String UNPUSHNUM = "unpushnum";
        //关联金额
        public static final String PUSHAMT = "pushamt";
        //未关联金额
        public static final String UNPUSHAMT = "unpushamt";
        //关联本币金额
        public static final String PUSHLOCALAMT = "pushlocalamt";
        //未关联本币金额
        public static final String UNPUSHLOCALAMT = "unpushlocalamt";
        //折扣方式
        public static final String DISCOUNTMODE = "discountmode";
        //核心单据类型
        public static final String COREBILLTYPE = "corebilltype";
        public static final String COREBILLNO = "corebillno";
        public static final String COREBILLID = "corebillid";
        public static final String COREBILLENTRYSEQ = "corebillentryseq";
        public static final String COREBILLENTRYID = "corebillentryid";
        public static final String CONBILLENTITY = "conbillentity";
        public static final String CONBILLNUMBER = "conbillnumber";
        public static final String CONBILLROWNUM = "conbillrownum";
        public static final String CONBILLID = "conbillid";
        public static final String CONBILLENTRYID = "conbillentryid";
        public static final String UNITFIELD = "unitfield";

        //外币相关明细字段-------------------------------------------------------------
    }


    /**
     * @Description 赠品行枚举
     * @Author zongjie_ye
     * @date 2022/6/15 16:07
     * @return
     */
    public static class GiftRowEnum{
        public static final String NORMAL = "0"; // 普通行
        public static final String GIFT = "1";  //赠品行
    }



    public static class ZeroPushFlagEnum{
        public static final String UNPUSH = "0"; // 未下推
        public static final String PUSHED = "1";
    }

    public static class PolicyLogEnum{
        public static final String NO_USE = "0";
        public static final String USE = "1";
    }

    public static class RowTypeEnum{
        public static final String ALL = "0"; // 整单折扣
        public static final String DISCOUNT = "1";
        public static final String NORMAL = "2";// 普通行
        // 开票申请单没有此枚举值
        public static final String BZK = "3";// 被折扣行
    }

    public static class BenchMark{
        public static final String NUM = "0";
        public static final String AMOUNT = "1";
    }

    public static class BillPropertity{
        /**
         *@description 负数
         *@time 2020/11/10 20:02
         *@author wenhao_wei
         **/
        public static final String POSITIVE = "1";
        /**
         *@description 正数
         *@time 2020/11/10 20:02
         *@author wenhao_wei
         **/
        public static final String NEGATIVE = "-1";
    }

    public static class Dialog{
        public static final String IMPORT = "sim_original_bill_import";
        public static final String INVOICES_PREVIEW = "sim_original_invs_preview";
        public static final String SIM_ORI_PREVIEW = "sim_ori_preview";
        public static final String SIM_BILL_PROCESS = "sim_bill_process";
        public static final String SIM_SPLIT_PROCESS = "sim_split_process";
    }

    // 征税方式弹窗处理回调
    public static class ZSFSCallbackKey {
        // 减按计征
        public static final String ZSFS_REDUCED_LEVY = "ZSFS_REDUCED_LEVY";
        // 差额征税
        public static final String ZSFS_DIFFERENCE_LEVY = "ZSFS_DIFFERENCE_LEVY";
        // 普通征税
        public static final String ZSFS_NORMAL = "ZSFS_NORMAL";
    }

    public static class DiscountMode{
        public static final String NULL = "NULL";
        public static final String PERCENT = "PERCENT";
        public static final String TOTAL = "TOTAL";
        public static final String GIFT = "GIFT";
    }

    public static class IsElePaper{
        public static final String NO = "0";
        public static final String YES = "1";
    }
}
