package kd.bos.ext.imc.common.util;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;

import java.math.BigDecimal;

/**
 * 金额计算工具类
 *
 * @Author deyu_peng
 */
public class BigDecimalUtil {

    public final static BigDecimal ZERO = new BigDecimal(0);

    /**
     * 获取绝对值
     */
    public static BigDecimal abs(BigDecimal val) {
        if (val == null) {
            val = new BigDecimal(0);
        }
        return val.abs();
    }


    public static BigDecimal multiply(BigDecimal val1, BigDecimal val2) {
        if (null == val1 || null == val2) {
            throw new NullPointerException(ResManager.loadKDString("进行计算的金额不能为null!", "BigDecimalUtil_0", "imc-bdm-common"));
        }
        return val1.multiply(val2);
    }


    /**
     * 校验val1和val2之间的差值是否大于val3 ,大于为true
     */
    public static boolean compare(BigDecimal val1, BigDecimal val2, BigDecimal val3) {
        if (val1 == null) {
            val1 = BigDecimal.ZERO;
        }
        if (val2 == null) {
            val2 = BigDecimal.ZERO;
        }
        if (val3 == null) {
            val3 = BigDecimal.ZERO;
        }
        return BigDecimalUtil.subtract(val1, val2).abs().compareTo(val3) > 0;
    }

    public static BigDecimal subtract(BigDecimal val1, BigDecimal val2) {
        int scale = getScale(val1, val2);
        return val1.subtract(val2).setScale(scale, BigDecimal.ROUND_HALF_UP);
    }

    public static BigDecimal add(BigDecimal val1, BigDecimal val2) {
        int scale = getScale(val1, val2);
        return val1.add(val2).setScale(scale, BigDecimal.ROUND_HALF_UP);
    }

    private static int getScale(BigDecimal val1, BigDecimal val2) {
        if (null == val1 || null == val2) {
            throw new NullPointerException(ResManager.loadKDString("进行计算的金额不能为null!", "BigDecimalUtil_0", "imc-bdm-common"));
        }
        return val1.scale() >= val2.scale() ? val1.scale() : val2.scale();
    }

    /**
     * 是否等于0
     *
     * @param val
     * @return
     */
    public static boolean compareZero(BigDecimal val) {
        if (null == val) {
            return true;
        }
        return val.compareTo(ZERO) == 0;
    }

    /**
     * 是否大于0
     *
     * @param val
     * @return
     */
    public static boolean greaterZero(BigDecimal val) {
        if (null == val) {
            return false;
        }
        return val.compareTo(ZERO) > 0;
    }

    /**
     * 是否小于0
     *
     * @param val
     * @return
     */
    public static boolean lessZero(BigDecimal val) {
        if (null == val) {
            return false;
        }
        return val.compareTo(ZERO) < 0;
    }

    public static String transToPoint(String val) {
        return transToPoint(val, 2);
    }

    public static String transToPoint(String val, int scale) {
        if (!isNumber(val)) {
            return "";
        }
        return new BigDecimal(val).setScale(scale, BigDecimal.ROUND_HALF_UP).toPlainString();
    }

    public static boolean isNumber(String number) {
        try {
            BigDecimal val = new BigDecimal(number);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    public static BigDecimal getJsonBigDecimalVal(Object obj) {
        BigDecimal val = BigDecimal.ZERO;
        if (obj == null) {
            return val;
        }
        try {
            val = new BigDecimal(obj.toString());
        } catch (Exception ignore) {
        }
        return val;
    }

    public static String getBigDecimalStr(String big){
        if (StringUtils.isBlank(big) || !isNumber(big)) {
            return "";
        }
        BigDecimal cp = new BigDecimal(big);
        if (cp.compareTo(BigDecimal.ZERO) == 0) {
            return "";
        }
        return big;
    }

    public static BigDecimal transDecimal(Object val) {
        if (null == val || "".equals(val)) {
            return BigDecimal.ZERO;
        }
        if (val instanceof BigDecimal) {
            return (BigDecimal) val;
        }
        try {
            return new BigDecimal(String.valueOf(val));
        } catch (NumberFormatException e) {
            return BigDecimal.ZERO;
        }
    }
}
