package kd.bos.ext.imc.formplugin.operation;

import com.alibaba.fastjson.JSONObject;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.imc.common.opration.OpConfigParam;
import kd.bos.metadata.entity.operation.CustOpParameterPlugin;
import kd.bos.metadata.entity.operation.CustOperationParameter;

public class DelAttConfigParamPlugin extends CustOpParameterPlugin {
	@Override
	protected void showParameter(CustOperationParameter v) {
		JSONObject param = JSONObject.parseObject(v.getParameter());
		if(param == null) {
			return;
		}
		if(StringUtils.isNotBlank(param.getString(OpConfigParam.CONFIG_ENTITYID))){
			getModel().setValue(OpConfigParam.CONFIG_ENTITYID, param.get(OpConfigParam.CONFIG_ENTITYID));
		}
		if(StringUtils.isNotBlank(param.getString(OpConfigParam.CONFIG_BILLID))){
			getModel().setValue(OpConfigParam.CONFIG_BILLID, param.getString(OpConfigParam.CONFIG_BILLID));
		}
		if(StringUtils.isNotBlank(param.getString(OpConfigParam.CONFIG_CALLBACKPLUGIN))){
			getModel().setValue(OpConfigParam.CONFIG_CALLBACKPLUGIN, param.getString(OpConfigParam.CONFIG_CALLBACKPLUGIN));
		}
		if(StringUtils.isNotBlank(param.getString(OpConfigParam.CONFIG_CALLBACK))) {
			getModel().setValue(OpConfigParam.CONFIG_CALLBACK, param.getString(OpConfigParam.CONFIG_CALLBACK));
		}
		if(StringUtils.isNotBlank(param.getString(OpConfigParam.CONFIG_ATTACHPANELKEY))) {
			getModel().setValue(OpConfigParam.CONFIG_ATTACHPANELKEY, param.getString(OpConfigParam.CONFIG_ATTACHPANELKEY));
		}
	}
	
	@Override
	protected void returnParameter(CustOperationParameter v) {
		DynamicObject entity = this.getModel().getDataEntity();
		JSONObject param = new JSONObject();
		if(StringUtils.isNotBlank(entity.getString(OpConfigParam.CONFIG_BILLID))) {
			param.put(OpConfigParam.CONFIG_BILLID, entity.getString(OpConfigParam.CONFIG_BILLID));
		}
		if(StringUtils.isNotBlank(entity.getString(OpConfigParam.CONFIG_ENTITYID))) {
			param.put(OpConfigParam.CONFIG_ENTITYID, entity.getString(OpConfigParam.CONFIG_ENTITYID));
		}
		if(StringUtils.isNotBlank(entity.getString(OpConfigParam.CONFIG_CALLBACKPLUGIN))) {
			param.put(OpConfigParam.CONFIG_CALLBACKPLUGIN, entity.getString(OpConfigParam.CONFIG_CALLBACKPLUGIN));
		}
		if(StringUtils.isNotBlank(entity.getString(OpConfigParam.CONFIG_CALLBACK))) {
			param.put(OpConfigParam.CONFIG_CALLBACK, entity.getString(OpConfigParam.CONFIG_CALLBACK));
		}
		if(StringUtils.isNotBlank(entity.getString(OpConfigParam.CONFIG_ATTACHPANELKEY))) {
			param.put(OpConfigParam.CONFIG_ATTACHPANELKEY, entity.getString(OpConfigParam.CONFIG_ATTACHPANELKEY));
		}
		v.setParameter(JSONObject.toJSONString(param));
	}
}
