package kd.bos.ext.imc.operation;

import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.imc.operation.contant.InvoiceOpParamContant;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IMobileView;
import kd.bos.form.ShowType;

/**
 * 	选择发票页面操作的插件
 * @Description: 
 * @author 何雨秋
 * @date 2022-3-29
 */
public class CollectInvoiceOperate extends AbstractInvoiceFormOperate {
	@Override
	void setPageInfo(FormShowParameter param) {
		if(this.getView() instanceof IMobileView) {
			param.getOpenStyle().setShowType(ShowType.Floating);
			param.setFormId(InvoiceOpParamContant.RIM_MOBILE_INDEX);
		}else {
			param.getOpenStyle().setShowType(ShowType.Modal);
			param.setFormId(InvoiceOpParamContant.RIM_FPZS_MAIN);
		}
	}
	
	@Override
	protected void extConfig(Map<String, Object> configParam, JSONObject param) {
		//是否需要自动导入单据开关
		boolean needAutoToBill = param.getBooleanValue(InvoiceOpParamContant.NEEDAUTOTOBILL);
		if(needAutoToBill) {
			//单据的发票头分录
			String headEntryKey = param.getString(InvoiceOpParamContant.HEAD_ENTRY_KEY);
			if(StringUtils.isNotBlank(headEntryKey)) {
				configParam.put("billInvoiceHeadKey", headEntryKey);
				//发票头字段映射
				JSONArray headKeyMap = param.getJSONArray(InvoiceOpParamContant.ENTRYENTITY_OPEN);
				if(headKeyMap != null) {
					JSONObject headKey = new JSONObject();
					for (int i = 0; i < headKeyMap.size(); i++) {
						JSONObject keyMap= headKeyMap.getJSONObject(i);
						headKey.put(keyMap.getString("entrykey"), keyMap.getString("invoiceKeys"));
					}
					if(!headKey.isEmpty()) {
						configParam.put("headKeyMap", headKey);
					}
				}
			}
			//单据的发票明细分录
			String itemEntryKey = param.getString(InvoiceOpParamContant.ITEM_ENTRY_KEY);
			if(StringUtils.isNotBlank(itemEntryKey)) {
				configParam.put("billInvoiceItemKey", itemEntryKey);
				//发票明细字段映射
				JSONArray itemKeyMap =param.getJSONArray(InvoiceOpParamContant.ITEM_ENTRYENTITY);
				if(itemKeyMap != null) {
					JSONObject itemKey = new JSONObject();
					for (int i = 0; i < itemKeyMap.size(); i++) {
						JSONObject keyMap= itemKeyMap.getJSONObject(i);
						itemKey.put(keyMap.getString("itementyfieldkey"), keyMap.getString("invoiceItemKeys"));
					}
					if(!itemKey.isEmpty()) {
						configParam.put("itemKeyMap", itemKey);
					}
				}
			}
		}
		if(param.getString(InvoiceOpParamContant.ATTACHPANELKEY) != null) {
			configParam.put(InvoiceOpParamContant.ATTACHPANELKEY, param.getString(InvoiceOpParamContant.ATTACHPANELKEY));
		}
	}
	
	@Override
	protected void extCustom(Map<String, Object> customParams, Map<String, Object> configParam) {
		if(configParam.get("billInvoiceHeadKey") != null) {
			customParams.put("billInvoiceHeadKey", configParam.get("billInvoiceHeadKey"));
			if(configParam.get("headKeyMap") != null) {
				customParams.put("headKeyMap", configParam.get("headKeyMap"));
			}
		}
		
		if(configParam.get("billInvoiceItemKey") != null) {
			customParams.put("billInvoiceItemKey", configParam.get("billInvoiceItemKey"));
			if(configParam.get("itemKeyMap") != null) {
				customParams.put("itemKeyMap", configParam.get("itemKeyMap"));
			}
		}
		
		if(configParam.get(InvoiceOpParamContant.BILLNO) != null) {
			customParams.put(InvoiceOpParamContant.BILLNO, configParam.get(InvoiceOpParamContant.BILLNO));
		}
		if(configParam.get(InvoiceOpParamContant.BILLTYPE) != null) {
			customParams.put(InvoiceOpParamContant.BILLTYPE, configParam.get(InvoiceOpParamContant.BILLTYPE));
		}
		
		//附件面板标识
		if(configParam.get(InvoiceOpParamContant.ATTACHPANELKEY) != null) {
			customParams.put(InvoiceOpParamContant.ATTACHPANELKEY, configParam.get(InvoiceOpParamContant.ATTACHPANELKEY));
		}
		
		//税号
		Object taxNo = configParam.get(InvoiceOpParamContant.TAXNO);
		List<Map<String, String>> companyInfo = Lists.newArrayList();
		if(taxNo != null) {
			Object name = configParam.get(InvoiceOpParamContant.NAME);
			if(taxNo.toString().indexOf(",") != -1) {
				String[] taxNoArr = taxNo.toString().split(",");
				String[] nameArr = name.toString().split(",");
				
				for (int i = 0; i < nameArr.length; i++) {
					Map<String, String> taxAndName = Maps.newHashMapWithExpectedSize(1);
					taxAndName.put(InvoiceOpParamContant.TAXNO, taxNoArr[i]);
					taxAndName.put(InvoiceOpParamContant.NAME, nameArr[i]);
					companyInfo.add(taxAndName);
				}
			}else {
				Map<String, String> taxAndName = Maps.newHashMapWithExpectedSize(1);
				taxAndName.put(InvoiceOpParamContant.TAXNO, taxNo.toString());
				taxAndName.put(InvoiceOpParamContant.NAME, name.toString());
				companyInfo.add(taxAndName);
			}
		}
		if(!companyInfo.isEmpty()) {
			customParams.put(InvoiceOpParamContant.COMPANYINFO, companyInfo);
		}
	}
	
	@Override
	protected void judgeCutomeParam(Map<String, Object> configParam, OperationResult result) {
		if(configParam.get(InvoiceOpParamContant.BILLNO) == null) {
			//result.setSuccess(false);
			this.getView().showTipNotification(this.getOperateName().getLocaleValue()+"失败，未获取到单据编号，请联系管理员");
		}
		if(configParam.get(InvoiceOpParamContant.BILLTYPE) == null){
			//result.setSuccess(false);
			this.getView().showTipNotification(this.getOperateName().getLocaleValue()+"失败，未获取到单据类型，请联系管理员");
		}
		if(configParam.get(InvoiceOpParamContant.ORGID) == null){
			//result.setSuccess(false);
			this.getView().showTipNotification(this.getOperateName().getLocaleValue()+"失败，未获取到核算组织，请联系管理员");
		}
	}

	@Override
	List<String> getCustomConfigParam() {
		return Lists.newArrayList(InvoiceOpParamContant.BILLTYPE, InvoiceOpParamContant.BILLNO
				, InvoiceOpParamContant.BILLID, InvoiceOpParamContant.ENTITYID
				, InvoiceOpParamContant.ORGID, InvoiceOpParamContant.TAXNO
				, InvoiceOpParamContant.NAME, InvoiceOpParamContant.CALLBACKPLUGIN
				, InvoiceOpParamContant.CALLBACK);
	}
}
