/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.consumer;

import java.util.Date;
import java.util.Iterator;
import kd.bos.algo.Collector;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.bal.business.consumer.IdxInfo;

class AsyncTxMsgReduceGroup
extends ReduceGroupFunctionWithCollector {
    private RowMeta rowMeta;
    private int idIdx;
    private int createTimeIdx;
    private int idsDelIdx;

    public AsyncTxMsgReduceGroup(RowMeta rowMeta, IdxInfo idxInfo) {
        this.rowMeta = rowMeta;
        this.idIdx = idxInfo.idIdx;
        this.createTimeIdx = idxInfo.createTimeIdx;
        this.idsDelIdx = idxInfo.idsDelIdx;
    }

    private long getTime(Row row) {
        Date time = row.getDate(this.createTimeIdx);
        return time == null ? 0L : time.getTime();
    }

    public void reduce(Iterator<Row> it, Collector ct) {
        StringBuilder idsDel = new StringBuilder();
        long time = 0L;
        long resultId = 0L;
        Object[] result = null;
        while (it.hasNext()) {
            long delId;
            Row row = it.next();
            if (result == null) {
                result = RowUtil.toArray((Row)row);
                time = this.getTime(row);
                resultId = row.getLong(this.idIdx);
                continue;
            }
            long currTime = this.getTime(row);
            if (currTime > time) {
                result = RowUtil.toArray((Row)row);
                time = currTime;
                delId = resultId;
                resultId = row.getLong(this.idIdx);
            } else {
                delId = row.getLong(this.idIdx);
            }
            if (idsDel.length() > 0) {
                idsDel.append(',');
            }
            idsDel.append(delId);
        }
        if (result != null) {
            result[this.idsDelIdx] = idsDel.toString();
            ct.collect(result);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

