/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.consumer;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.bal.business.consumer.AsyncTxMsgReduceGroup;
import kd.bos.bal.business.consumer.IdxInfo;
import kd.bos.bal.business.consumer.NotifyMsg;
import kd.bos.bal.business.consumer.TxMsg;
import kd.bos.bal.business.core.BalConfig;
import kd.bos.bal.business.core.BalEngineUtil;
import kd.bos.bal.business.core.BalManager;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.bal.common.QFUtil;
import kd.bos.bal.servicehelper.BalServiceHelper;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.support.partition.PartitionStrategy;
import org.apache.commons.lang3.StringUtils;

class BalTxNotifyTask
implements Runnable {
    private static final IAppCache cache = AppCache.get((String)"bal");
    private final NotifyMsg info;
    private DBRoute occDb;
    private String balName;
    private String notifyMsgTb;
    private int notifyTxBatch;
    private int notifyBillBatch;
    private int notifyDelayMs;
    private int notifyPartAsyncMin;
    private int notifyAllAsyncMin;
    private boolean useMq;
    private boolean singleThreadMode;
    private String updateSql;
    private String serviceName;
    private final List<ReTryMsg> reTryMsgs = new ArrayList<ReTryMsg>(8);
    private String tempAsyncInfoTb;
    private final Set<Long> publishedCacheIds = new TreeSet<Long>();

    BalTxNotifyTask(NotifyMsg info) {
        this.info = info;
    }

    private void initInfo() {
        this.occDb = DBRoute.of((String)this.info.getDbKey());
        this.balName = this.info.getBal();
        BalanceTB bal = BalanceTB.getBalanceTB(this.balName);
        String string = this.notifyMsgTb = this.info.isPartAsyncMsg() ? bal.getOrCreateTxTb(this.occDb) : bal.getOrCreateAsyncInfoTb(this.occDb);
        if (!this.info.isPartAsyncMsg()) {
            this.tempAsyncInfoTb = bal.getOrCreateTempAsyncInfoTb(this.occDb);
        }
        BalConfig cfg = BalConfig.loadBalConfig(this.balName);
        this.notifyTxBatch = cfg.getNotifyTxBatch();
        this.notifyDelayMs = cfg.getNotifyDelayMs();
        this.notifyPartAsyncMin = cfg.getNotifyPartAsyncMin();
        this.notifyAllAsyncMin = cfg.getNotifyAllAsyncMin();
        this.notifyBillBatch = cfg.getNotifyBillBatch();
        this.singleThreadMode = cfg.isSingleThreadMode();
        this.useMq = BalConfig.isServiceByMQ();
    }

    private void pubTxMsg() {
        if (this.info.isPartAsyncMsg()) {
            this.pubPartAsyncTxMsg();
        } else {
            this.moveAllAsyncTxMsg();
            this.pubAllAsyncTxMsg();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveAllAsyncTxMsg() {
        BalLogUtil.info("BalTxNotifyTask.moveAllAsyncTxMsg started", new Object[0]);
        if (this.tempAsyncInfoTb == null) {
            return;
        }
        String sql = " SELECT TOP 100000 FID,FBILLID,FRULEID,FCREATETIME FROM " + this.tempAsyncInfoTb + " ORDER BY FCREATETIME ASC ";
        try (DataSet datas = null;){
            datas = DB.queryDataSet((String)"BalTxNotifyTask.moveAllAsyncTxMsg", (DBRoute)this.occDb, (String)sql);
            datas = datas.addFields(new String[]{"''"}, new String[]{"ids_del"});
            RowMeta rowMeta = datas.getRowMeta();
            IdxInfo idxInfo = this.buildIdxInfo(rowMeta);
            datas = datas.groupBy(new String[]{"FBILLID", "FRULEID"}).reduceGroup((ReduceGroupFunctionWithCollector)new AsyncTxMsgReduceGroup(rowMeta, idxInfo));
            ArrayList<Long> billIds = new ArrayList<Long>(16);
            ArrayList<String> ruleIds = new ArrayList<String>(16);
            ArrayList<Long> ids = new ArrayList<Long>(16);
            LinkedList<Long> idsDel = new LinkedList<Long>();
            for (Row row : datas) {
                ids.add(row.getLong(idxInfo.idIdx));
                billIds.add(row.getLong(idxInfo.billIdIdx));
                ruleIds.add(row.getString(idxInfo.ruleIdIdx));
                this.parseLongIds(idsDel, row.getString(idxInfo.idsDelIdx));
                if (idsDel.size() > 1000) {
                    this.delTempAsyncInfoInNewTx(idsDel);
                    idsDel.clear();
                }
                if (ids.size() <= 1000) continue;
                this.moveAsyncMsgs(ids, billIds, ruleIds);
                ids.clear();
                billIds.clear();
                ruleIds.clear();
            }
            if (idsDel.size() > 0) {
                this.delTempAsyncInfoInNewTx(idsDel);
            }
            if (ids.size() > 0) {
                this.moveAsyncMsgs(ids, billIds, ruleIds);
            }
        }
    }

    private void moveAsyncMsgs(List<Long> ids, List<Long> billIds, List<String> ruleIds) {
        String sql = "SELECT FBILLID,FRULEID FROM " + this.notifyMsgTb + " WHERE FBILLID " + QFUtil.getIdsFilter(new HashSet<Long>(billIds)) + " AND FRULEID " + QFUtil.getIdsFilter(new HashSet<String>(ruleIds), true);
        HashSet<String> billRules = new HashSet<String>(8);
        try (DataSet dataSet = DB.queryDataSet((String)"BalTxNotifyTask.moveAsyncMsgs", (DBRoute)this.occDb, (String)sql);){
            RowMeta rowMeta = dataSet.getRowMeta();
            int billIdIdx = rowMeta.getFieldIndex("FBILLID");
            int ruleIdx = rowMeta.getFieldIndex("FRULEID");
            for (Row row : dataSet) {
                billRules.add(row.getLong(billIdIdx) + row.getString(ruleIdx));
            }
        }
        ArrayList<Long> resultIds = new ArrayList<Long>(ids.size());
        int len = ids.size();
        for (int i = 0; i < len; ++i) {
            if (billRules.contains(billIds.get(i) + ruleIds.get(i))) continue;
            resultIds.add(ids.get(i));
        }
        if (!resultIds.isEmpty()) {
            String fs = QFUtil.getIdsFilter(resultIds);
            String cols = "FID,FBILLID,FRULEID,FBAL,FBILLENTITY,FOP,FDB,FXDBFLAG,FCREATERID,FCREATETIME";
            String insertSql = "INSERT INTO " + this.notifyMsgTb + "(" + cols + ") SELECT " + cols + " FROM " + this.tempAsyncInfoTb + " WHERE FID " + fs;
            String delSql = this.getDelSql(fs);
            try (TXHandle tx = TX.requiresNew((String)"moveAsyncMsgs");){
                try {
                    DB.execute((DBRoute)this.occDb, (String)insertSql);
                    DB.execute((DBRoute)this.occDb, (String)delSql);
                }
                catch (Exception e) {
                    tx.markRollback();
                    BalLogUtil.error("moveAsyncMsgs error : resultIds.size = " + resultIds.size(), e);
                }
            }
        }
    }

    private void delTempAsyncInfoInNewTx(List<Long> idsDel) {
        try (TXHandle tx = TX.requiresNew((String)"delTempAsyncInfoInNewTx");){
            try {
                this.delTempAsyncInfoById(idsDel);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private void delTempAsyncInfoById(List<Long> idsDel) {
        String sql = this.getDelSql(QFUtil.getIdsFilter(idsDel));
        DB.update((DBRoute)this.occDb, (String)sql);
    }

    private String getDelSql(String fs) {
        return "DELETE FROM " + this.tempAsyncInfoTb + " WHERE FID " + fs;
    }

    private void parseLongIds(List<Long> ids, String idsStr) {
        if (StringUtils.isNotBlank((CharSequence)idsStr)) {
            String[] idStrs;
            for (String idStr : idStrs = idsStr.split(",")) {
                ids.add(Long.valueOf(idStr));
            }
        }
    }

    private IdxInfo buildIdxInfo(RowMeta rowMeta) {
        IdxInfo idxInfo = new IdxInfo();
        idxInfo.idIdx = rowMeta.getFieldIndex("FID");
        idxInfo.billIdIdx = rowMeta.getFieldIndex("FBILLID");
        idxInfo.ruleIdIdx = rowMeta.getFieldIndex("FRULEID");
        idxInfo.createTimeIdx = rowMeta.getFieldIndex("FCREATETIME");
        idxInfo.idsDelIdx = rowMeta.getFieldIndex("ids_del");
        return idxInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pubAllAsyncTxMsg() {
        BalLogUtil.info("BalTxNotifyTask.pubAllAsyncTxMsg started: useMq = " + this.useMq, new Object[0]);
        MessagePublisher pub = null;
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(12, -this.notifyAllAsyncMin);
        Date limitTime = calendar.getTime();
        DataSet datas = null;
        try {
            String sql = " SELECT TOP 100000 FID,FRULEID,FXDBFLAG,FOP FROM " + this.notifyMsgTb + " WHERE (FPUBLISHTIME < ? OR FPUBLISHTIME IS NULL) AND FBAL = ? ORDER BY FCREATETIME ASC ";
            datas = DB.queryDataSet((String)"BalTxNotifyTask.pubAllAsyncTxMsg", (DBRoute)this.occDb, (String)sql, (Object[])new Object[]{limitTime, this.balName});
            datas = datas.orderBy(new String[]{"FRULEID ASC", "FOP ASC", "FXDBFLAG ASC"});
            if (this.useMq) {
                pub = MQFactory.get().createPartitionPublisher("bal_queue", "bal.recal", PartitionStrategy.APP_ID);
                this.updateSql = "UPDATE " + this.notifyMsgTb + " SET FPUBLISHTIME = ? WHERE FID = ?";
            } else {
                this.serviceName = "mockReUpdateMsg";
            }
            TreeSet<Long> ids = new TreeSet<Long>();
            String preRuleId = null;
            String preOp = null;
            int preXdbFlag = -1;
            RowMeta rowMeta = datas.getRowMeta();
            int idxRuleId = rowMeta.getFieldIndex("FRULEID");
            int idxXdbFlag = rowMeta.getFieldIndex("FXDBFLAG");
            int idxId = rowMeta.getFieldIndex("FID");
            int idxOp = rowMeta.getFieldIndex("FOP");
            for (Row row : datas) {
                String ruleId = row.getString(idxRuleId);
                int xdbFlag = row.getInteger(idxXdbFlag);
                Long id = row.getLong(idxId);
                String op = row.getString(idxOp);
                if (preRuleId == null) {
                    ids.add(id);
                    preRuleId = ruleId;
                    preXdbFlag = xdbFlag;
                    preOp = op;
                    continue;
                }
                if (this.isSameGroup(preRuleId, preXdbFlag, preOp, ruleId, xdbFlag, op)) {
                    ids.add(id);
                    if (ids.size() < this.notifyBillBatch) continue;
                    this.pubAllAsyncTxMsg(this.info.getAppId(), pub, ids, ruleId, op);
                    ids.clear();
                    continue;
                }
                this.pubAllAsyncTxMsg(this.info.getAppId(), pub, ids, preRuleId, preOp);
                ids.clear();
                ids.add(id);
                preRuleId = ruleId;
                preXdbFlag = xdbFlag;
                preOp = op;
            }
            if (!ids.isEmpty()) {
                this.pubAllAsyncTxMsg(this.info.getAppId(), pub, ids, preRuleId, preOp);
            }
        }
        finally {
            if (datas != null) {
                datas.close();
            }
            if (pub != null) {
                pub.close();
            }
        }
    }

    private void pubAllAsyncTxMsg(String appId, MessagePublisher pub, TreeSet<Long> ids, String ruleId, String op) {
        if (ids.isEmpty()) {
            return;
        }
        BalLogUtil.info("BalTxNotifyTask.pubAllAsyncTxMsg started: ids.size={},ruleId={},op={}", ids.size(), ruleId, op);
        JSONObject param = new JSONObject();
        param.put("db", (Object)this.occDb.getRouteKey());
        param.put("appid", (Object)appId);
        param.put("op", (Object)op);
        param.put("ids", ids);
        param.put("ruleId", (Object)ruleId);
        try {
            if (pub != null) {
                pub.publish((Object)param.toJSONString(), appId);
                for (Long id : ids) {
                    this.addPublished(id);
                }
            } else if (!this.invokeBalService(appId, param)) {
                this.addReTryMsgs(new ReTryMsg(appId, param));
            }
        }
        catch (Throwable e) {
            BalLogUtil.saveError("BalTxNotifyTask", String.valueOf(param), "pubAllAsyncTxMsg", e);
        }
        BalLogUtil.info("NotifyAllAsyncTask.pubAllAsyncTxMsg end", new Object[0]);
    }

    private void addReTryMsgs(ReTryMsg msg) {
        this.reTryMsgs.add(msg);
        if (this.reTryMsgs.size() > 100) {
            this.tryFlushMsgs();
        }
    }

    private boolean isSameGroup(String preRuleId, int preXdbFlag, String preOp, String ruleId, int xdbFlag, String op) {
        return preXdbFlag == xdbFlag && preRuleId.equals(ruleId) && preOp.equals(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pubPartAsyncTxMsg() {
        BalLogUtil.info("BalTxNotifyTask.pubPartAsyncTxMsg started: useMq ={}, singleThreadMode={} ", this.useMq, this.singleThreadMode);
        MessagePublisher pub = null;
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(12, -this.notifyPartAsyncMin);
        Date limitTime = calendar.getTime();
        DataSet txData = null;
        try {
            String sql = " SELECT TOP 100000 FTXID,FXDBFLAG FROM " + this.notifyMsgTb + " WHERE (FPUBLISHTIME < ? OR FPUBLISHTIME IS NULL) AND FBAL = ? ORDER BY FTXID ASC ";
            txData = DB.queryDataSet((String)"BalTxNotifyTask.pubPartAsyncTxMsg", (DBRoute)this.occDb, (String)sql, (Object[])new Object[]{limitTime, this.balName});
            txData = txData.orderBy(new String[]{"FXDBFLAG ASC", "FTXID ASC"});
            if (this.useMq) {
                pub = MQFactory.get().createPartitionPublisher("bal_queue", "bal.tx_update", PartitionStrategy.APP_ID);
                this.updateSql = "UPDATE " + this.notifyMsgTb + " SET FPUBLISHTIME = ? WHERE FTXID = ? ";
            } else {
                this.serviceName = "mockTxMsg";
            }
            TreeSet<Long> txs = new TreeSet<Long>();
            int preXdbFlag = -1;
            RowMeta rowMeta = txData.getRowMeta();
            int idxXdbFlag = rowMeta.getFieldIndex("FXDBFLAG");
            int idxTx = rowMeta.getFieldIndex("FTXID");
            for (Row row : txData) {
                int xdbFlag = row.getInteger(idxXdbFlag);
                Long tx = row.getLong(idxTx);
                if (preXdbFlag == -1) {
                    txs.add(tx);
                    preXdbFlag = xdbFlag;
                    continue;
                }
                if (preXdbFlag == xdbFlag) {
                    txs.add(tx);
                    if (txs.size() < this.notifyTxBatch) continue;
                    this.pubPartAsyncTxMsg(this.info.getAppId(), pub, txs);
                    txs.clear();
                    continue;
                }
                this.pubPartAsyncTxMsg(this.info.getAppId(), pub, txs);
                txs.clear();
                txs.add(tx);
                preXdbFlag = xdbFlag;
            }
            if (!txs.isEmpty()) {
                this.pubPartAsyncTxMsg(this.info.getAppId(), pub, txs);
            }
        }
        finally {
            if (txData != null) {
                txData.close();
            }
            if (pub != null) {
                pub.close();
            }
        }
    }

    private void addPublished(Long recordId) {
        this.publishedCacheIds.add(recordId);
        if (this.publishedCacheIds.size() >= 200) {
            this.tryFlushPublished2DB();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryFlushPublished2DB() {
        if (this.publishedCacheIds.isEmpty()) {
            return;
        }
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(this.publishedCacheIds.size());
        try (TXHandle tx = TX.requiresNew((String)"tryFlushPublished2DB");){
            try {
                Date now = new Date();
                for (Long publishedCacheId : this.publishedCacheIds) {
                    sqlParams.add(new Object[]{now, publishedCacheId});
                }
                DB.executeBatch((DBRoute)this.occDb, (String)this.updateSql, sqlParams);
                this.publishedCacheIds.clear();
            }
            catch (Throwable e) {
                try {
                    tx.markRollback();
                    BalLogUtil.saveError("BalTxNotifyTask", String.valueOf(this.publishedCacheIds), "tryFlushPublished2DB", e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.publishedCacheIds.clear();
                }
            }
        }
    }

    private void pubPartAsyncTxMsg(String appId, MessagePublisher pub, TreeSet<Long> txs) {
        if (txs.isEmpty()) {
            return;
        }
        BalLogUtil.info("BalTxNotifyTask.pubPartAsyncTxMsg started: txs.size={}", txs.size());
        if (this.singleThreadMode) {
            BalEngineUtil.handleTxMsg(new TxMsg(BalanceTB.getBalanceTB(this.balName), this.occDb, new HashSet<Long>(txs)));
        } else {
            String txFs = StringUtils.join(txs, (String)",");
            JSONObject param = new JSONObject();
            param.put("db", (Object)this.occDb.getRouteKey());
            param.put("txs", (Object)txFs);
            param.put("bal", (Object)this.balName);
            param.put("appid", (Object)appId);
            try {
                if (pub != null) {
                    pub.publish((Object)param.toJSONString(), appId);
                    for (Long tx : txs) {
                        this.addPublished(tx);
                    }
                } else if (!this.invokeBalService(appId, param)) {
                    this.addReTryMsgs(new ReTryMsg(appId, param));
                }
            }
            catch (Throwable e) {
                BalLogUtil.saveError("BalTxNotifyTask", String.valueOf(param), "pubPartAsyncTxMsg", e);
            }
        }
        BalLogUtil.info("BalTxNotifyTask.pubPartAsyncTxMsg end", new Object[0]);
    }

    private boolean invokeBalService(String appId, JSONObject param) {
        Object result = BalServiceHelper.invokeBalService(appId, this.serviceName, this.balName, param.toJSONString());
        boolean success = "1".equals(result);
        if (!success) {
            BalLogUtil.warn("invokeBalService faild, result = {}, param = {}", result, param);
        }
        return success;
    }

    private void doNotify() throws InterruptedException {
        BalLogUtil.info("BalTxNotifyTask.doNotify started: notifyDelayMs={0}", this.notifyDelayMs);
        String lockKey = this.info.getDLockKey();
        boolean locked = false;
        try (DLock lock = DLock.create((String)lockKey);){
            if (lock.tryLock()) {
                cache.remove(lockKey);
                locked = true;
                if (this.notifyDelayMs > 0) {
                    Thread.sleep(this.notifyDelayMs);
                }
                this.pubTxMsg();
            } else {
                cache.put(lockKey, (Object)"1");
            }
        }
        if (locked && cache.get(lockKey, String.class) != null) {
            BalLogUtil.info("BalTxNotifyTask.doNotify republish", new Object[0]);
            BalManager.notifyMQConsumer(this.info);
        }
        BalLogUtil.info("BalTxNotifyTask.doNotify end", new Object[0]);
    }

    @Override
    public void run() {
        try {
            this.initInfo();
            this.doNotify();
        }
        catch (Throwable e) {
            BalLogUtil.saveError("BalTxNotifyTask", String.valueOf(this.info), "run", e);
        }
        finally {
            if (this.useMq) {
                this.tryFlushPublished2DB();
            } else {
                this.tryFlushMsgs();
            }
        }
    }

    private void tryFlushMsgs() {
        if (this.reTryMsgs.isEmpty()) {
            return;
        }
        try {
            for (ReTryMsg reTryMsg : this.reTryMsgs) {
                this.tryPublishMsg(reTryMsg);
            }
        }
        finally {
            this.reTryMsgs.clear();
        }
    }

    private void tryPublishMsg(ReTryMsg reTryMsg) {
        try {
            this.invokeBalService(reTryMsg.app, reTryMsg.param);
        }
        catch (Throwable e) {
            BalLogUtil.error("BalTxNotifyTask", reTryMsg.param.toString(), "tryPublishMsg", e);
        }
    }

    private static class ReTryMsg {
        final String app;
        final JSONObject param;

        private ReTryMsg(String app, JSONObject param) {
            this.app = app;
            this.param = param;
        }
    }
}

