/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.core;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.instance.Instance;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BalConfig
implements Serializable {
    public static final String ENTITY_NAME = "bal_config";
    private static final int EXPIRE_LIMIT = 60000;
    private static final Map<String, BalConfig> CFG_CACHE = new ConcurrentHashMap<String, BalConfig>(32);
    private static final long serialVersionUID = -7491982632701545897L;
    @Conf(tag="nt_delay_ms", fromVal=0, toVal=5000)
    private int notifyDelayMs = 1000;
    @Conf(tag="nt_tx_bs", fromVal=1, toVal=1000)
    private int notifyTxBatch = 50;
    @Conf(tag="nt_bill_bs", fromVal=0, toVal=1000)
    private int notifyBillBatch = 100;
    @Conf(tag="nt_allasync_min", fromVal=5, toVal=30)
    private int notifyAllAsyncMin = 10;
    @Conf(tag="nt_partasync_min", fromVal=5, toVal=30)
    private int notifyPartAsyncMin = 10;
    @Conf(tag="eg_addsp_bs", fromVal=100, toVal=20000)
    private int engineAddSpBatch = 10000;
    @Conf(tag="eg_addbal_bs", fromVal=100, toVal=20000)
    private int engineAddBalBatch = 1000;
    @Conf(tag="eg_dist_entryid")
    private boolean engineDistinctEntryId = false;
    @Conf(tag="eg_ignore_cover")
    private boolean ignoreCover4Zero = false;
    @Conf(tag="eg_check_spcount")
    private boolean checkSpCount = true;
    @Conf(tag="cl_invalid_min", fromVal=15, toVal=600)
    private int clearInvalidMin = 60;
    @Conf(tag="cl_safe_min", fromVal=1, toVal=15)
    private int clearSafeMin = 5;
    @Conf(tag="cl_checktx_bs", fromVal=100, toVal=10000)
    private int clearCheckTxBatch = 1000;
    @Conf(tag="cl_pubtx_bs", fromVal=100, toVal=1000)
    private int clearPubTxBatch = 200;
    @Conf(tag="mv_updateper_bs", fromVal=20, toVal=20000)
    private int moveUpdatePerBatch = 10000;
    @Conf(tag="mv_updatereal_bs", fromVal=20, toVal=20000)
    private int moveUpdateRealBatch = 10000;
    @Conf(tag="mv_tpdata_bs", fromVal=100, toVal=20000)
    private int moveTpDataBatch = 10000;
    @Conf(tag="mv_maxquery_bs", fromVal=100000, toVal=5000000)
    private int moveMaxQueryBatch = 2000000;
    @Conf(tag="cr_data_bs", fromVal=10, toVal=1000)
    private int repairDataBatch = 200;
    @Conf(tag="mv_merge_sql")
    private boolean mergeSql = true;
    @Conf(tag="mv_keycol_bs", fromVal=1, toVal=10000)
    private int moveKeycolBatch = 200;
    @Conf(tag="nt_async_op")
    private boolean notityAsyncInfo4Op = true;
    @Conf(tag="nt_updating_op")
    private boolean notityUpdating4Op = true;
    @Conf(tag="nt_reupdate_limit", fromVal=0, toVal=10)
    private int reUpdateMsgSemaphore = 6;
    @Conf(tag="nt_tx_limit", fromVal=0, toVal=10)
    private int txMsgSemaphore = 6;
    @Conf(tag="nt_threadmode")
    private boolean singleThreadMode = false;
    private long createTime;

    public static Map<String, Object> getDevConf() {
        BalConfig balConf = new BalConfig();
        Field[] cols = BalConfig.class.getDeclaredFields();
        HashMap<String, Object> vals = new HashMap<String, Object>(cols.length);
        for (Field col : cols) {
            Conf annotation = col.getAnnotation(Conf.class);
            if (annotation == null) continue;
            vals.put(annotation.tag(), BalConfig.getDevConf(col, balConf));
        }
        return vals;
    }

    private static Object getDevConf(Field col, BalConfig balConf) {
        try {
            return col.get(balConf);
        }
        catch (Throwable e) {
            BalLogUtil.error("", e);
            return null;
        }
    }

    public int getMoveKeycolBatch() {
        return this.moveKeycolBatch;
    }

    private boolean isExpire() {
        return System.currentTimeMillis() - this.createTime > 60000L;
    }

    public boolean isNotityAsyncInfo4Op() {
        return this.notityAsyncInfo4Op;
    }

    public boolean isNotityUpdating4Op() {
        return this.notityUpdating4Op;
    }

    public static BalConfig loadBalConfig(String balName) {
        BalConfig cfg = null;
        try {
            String cacheKey = CacheKeyUtil.getAcctId() + balName;
            cfg = CFG_CACHE.get(cacheKey);
            if (cfg == null || cfg.isExpire()) {
                if (cfg != null) {
                    cfg.createTime = System.currentTimeMillis();
                }
                cfg = BalConfig.load(balName);
                cfg.createTime = System.currentTimeMillis();
                CFG_CACHE.put(cacheKey, cfg);
            }
            return cfg;
        }
        catch (Throwable e) {
            try {
                cfg = new BalConfig();
                CFG_CACHE.put(CacheKeyUtil.getAcctId() + balName, cfg);
                BalLogUtil.saveError("BalConfig", balName, "loadBalConfig", e);
            }
            catch (Throwable t) {
                BalLogUtil.error("BalConfig.loadBalConfig error", t);
            }
            return cfg;
        }
    }

    private static Set<String> getAllTags() {
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)ENTITY_NAME);
        Map allFields = type.getAllFields();
        HashSet<String> cols = new HashSet<String>(allFields.size() + 1);
        for (Map.Entry entry : allFields.entrySet()) {
            if (!StringUtils.isNotBlank((CharSequence)((IDataEntityProperty)entry.getValue()).getAlias())) continue;
            cols.add((String)entry.getKey());
        }
        cols.add("id");
        return cols;
    }

    private static DynamicObject getMergedConf(String balName) {
        QFilter fs = new QFilter("id", "=", (Object)1);
        if (StringUtils.isNotBlank((CharSequence)balName)) {
            fs.or("bal", "=", (Object)balName);
        }
        Set<String> cols = BalConfig.getAllTags();
        DynamicObject privateConf = null;
        DynamicObject publicConf = null;
        try (TXHandle tx = TX.notSupported((String)"getMergedConf");){
            DynamicObjectCollection confs = QueryServiceHelper.query((String)ENTITY_NAME, (String)String.join((CharSequence)",", cols), (QFilter[])fs.toArray(), null, (int)2);
            for (DynamicObject conf : confs) {
                if (conf.getLong("id") == 1L) {
                    publicConf = conf;
                    continue;
                }
                if (!conf.getString("bal").equals(balName)) continue;
                privateConf = conf;
            }
        }
        return privateConf == null ? publicConf : privateConf;
    }

    private BalConfig() {
    }

    private static BalConfig load(String balName) {
        BalConfig cfg = new BalConfig();
        DynamicObject conf = BalConfig.getMergedConf(balName);
        if (conf == null) {
            return cfg;
        }
        cfg.setVal(conf);
        return cfg;
    }

    private void setVal(DynamicObject info, Field col, Conf annotation) {
        try {
            if (col.getType() == Integer.TYPE) {
                int val = info.getInt(annotation.tag());
                if (val >= annotation.fromVal() && val <= annotation.toVal()) {
                    col.setInt(this, val);
                }
            } else if (col.getType() == Boolean.TYPE) {
                col.setBoolean(this, info.getBoolean(annotation.tag()));
            }
        }
        catch (Throwable e) {
            try {
                BalLogUtil.saveError("BalConfig", annotation.tag(), "setVal", e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void setVal(DynamicObject info) {
        Field[] cols;
        for (Field col : cols = BalConfig.class.getDeclaredFields()) {
            Conf annotation = col.getAnnotation(Conf.class);
            if (annotation == null) continue;
            this.setVal(info, col, annotation);
        }
    }

    public int getEngineAddSpBatch() {
        return this.engineAddSpBatch;
    }

    public int getEngineAddBalBatch() {
        return this.engineAddBalBatch;
    }

    public int getNotifyDelayMs() {
        return this.notifyDelayMs;
    }

    public int getNotifyPartAsyncMin() {
        return this.notifyPartAsyncMin;
    }

    public int getNotifyAllAsyncMin() {
        return this.notifyAllAsyncMin;
    }

    public int getNotifyBillBatch() {
        return this.notifyBillBatch;
    }

    public int getNotifyTxBatch() {
        return this.notifyTxBatch;
    }

    public int getClearInvalidMin() {
        return this.clearInvalidMin;
    }

    public int getClearSafeMin() {
        return this.clearSafeMin;
    }

    public int getClearCheckTxBatch() {
        return this.clearCheckTxBatch;
    }

    public int getClearPubTxBatch() {
        return this.clearPubTxBatch;
    }

    public int getMoveUpdatePerBatch() {
        return this.moveUpdatePerBatch;
    }

    public int getMoveUpdateRealBatch() {
        return this.moveUpdateRealBatch;
    }

    public int getMoveTpDataBatch() {
        return this.moveTpDataBatch;
    }

    public int getRepairDataBatch() {
        return this.repairDataBatch;
    }

    public boolean isEngineDistinctEntryId() {
        return this.engineDistinctEntryId;
    }

    public int getMoveMaxQueryBatch() {
        return this.moveMaxQueryBatch;
    }

    public boolean isCheckSpCount() {
        return this.checkSpCount;
    }

    public boolean isMergeSql() {
        return this.mergeSql;
    }

    public JSONObject showParams() {
        JSONObject allParams = new JSONObject(3);
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)ENTITY_NAME);
        Field[] cols = BalConfig.class.getDeclaredFields();
        JSONObject params = new JSONObject(cols.length);
        for (Field col : cols) {
            Conf annotation = col.getAnnotation(Conf.class);
            if (annotation == null) continue;
            params.put(this.buildKey(type, annotation), this.buildVal(col));
        }
        allParams.put("nodeId", (Object)Instance.getInstanceId());
        allParams.put("useMQ", (Object)BalConfig.isServiceByMQ());
        allParams.put("params", (Object)params);
        allParams.put("createTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(this.createTime)));
        return allParams;
    }

    private Object buildVal(Field col) {
        try {
            return col.get(this);
        }
        catch (Exception e) {
            return "error";
        }
    }

    private String buildKey(MainEntityType type, Conf annotation) {
        String name = annotation.tag();
        try {
            return type.findProperty(name).getDisplayName().getLocaleValue() + "(" + name + ")";
        }
        catch (Exception e) {
            return name;
        }
    }

    public boolean isIgnoreCover4Zero() {
        return this.ignoreCover4Zero;
    }

    public int getTxMsgSemaphore() {
        return this.txMsgSemaphore;
    }

    public int getReUpdateMsgSemaphore() {
        return this.reUpdateMsgSemaphore;
    }

    public boolean isSingleThreadMode() {
        return this.singleThreadMode;
    }

    public static boolean isServiceByMQ() {
        return "mq".equalsIgnoreCase(System.getProperty("bal.service.type", "mq"));
    }

    public boolean isUseCache4Keycol() {
        return false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    private static @interface Conf {
        public String tag();

        public int fromVal() default -1;

        public int toVal() default -1;
    }
}

