/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.core;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.MapFunction;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BooleanType;
import kd.bos.algo.datatype.NumericType;
import kd.bos.algo.datatype.StringType;
import kd.bos.bal.business.consumer.TxMsg;
import kd.bos.bal.business.core.BalConfig;
import kd.bos.bal.business.core.BalKeyHandle;
import kd.bos.bal.business.core.DistinctEntryIdReduceGroup;
import kd.bos.bal.business.core.HandleNullMapFunc;
import kd.bos.bal.business.core.Key;
import kd.bos.bal.business.core.SpDataHandle4Async;
import kd.bos.bal.business.core.SpDataHandle4Sync;
import kd.bos.bal.business.core.SpDataMapFunc;
import kd.bos.bal.business.core.TaskResult;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.bal.common.BalUtil;
import kd.bos.bal.common.QFUtil;
import kd.bos.bal.servicehelper.BalServiceHelper;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.biz.balance.model.IBalance;
import kd.bos.biz.balance.model.IBalanceUpdatePlugin;
import kd.bos.biz.balance.model.IDataTransform;
import kd.bos.biz.balance.model.UpdateCtx;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IBillEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.balance.BizDataType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.monitor.service.LivingServiceUtils;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.support.partition.PartitionStrategy;
import kd.bos.orm.ORM;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BalEngineUtil {
    static final String IDS_MOVE = "ids_move";
    static final String IDS_DEL = "ids_del";
    private static final String AS = " AS ";
    private static final String EQ = "=?";
    private static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static ThreadLocal<Map<String, List<Long>>> localTxs = ThreadLocal.withInitial(() -> new HashMap());

    static Object[] parseQtyParam(Row row, List<String> paramCols, Set<String> qtyCols) {
        Object[] params = new Object[paramCols.size()];
        boolean allZero = true;
        int len = params.length;
        for (int i = 0; i < len; ++i) {
            String col = paramCols.get(i);
            if (qtyCols.contains(col)) {
                BigDecimal qty = row.getBigDecimal(col);
                if (allZero && qty.compareTo(BigDecimal.ZERO) != 0) {
                    allZero = false;
                }
                params[i] = qty;
                continue;
            }
            params[i] = row.get(col);
        }
        return allZero ? null : params;
    }

    static boolean isDbDefaultValue(Object value) {
        if (value == null) {
            return true;
        }
        if (value.getClass() == String.class) {
            return StringUtils.isBlank((CharSequence)((String)value));
        }
        if (value.getClass() == BigDecimal.class) {
            return ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0;
        }
        return value.toString().equals("0");
    }

    static DataSet getData(UpdateRule rule, Set<Object> billIds, Set<Object> entryIds, boolean enableUpdatedFs) {
        QFilter ruleFilter;
        QFilter ruleUpdatedFs;
        QFilter fs = new QFilter("id", "in", billIds);
        if (enableUpdatedFs && (ruleUpdatedFs = BalEngineUtil.getRuleUpdatedFs(rule)) != null) {
            fs.and(ruleUpdatedFs);
        }
        if (entryIds != null && rule.getEntryName() != null) {
            fs.and(rule.getEntryPkName(), "in", entryIds);
        }
        if ((ruleFilter = rule.getFilter()) != null) {
            fs.and(ruleFilter);
        }
        String selectCols = BalEngineUtil.getBillCols4Select(rule);
        ORM orm = ORM.create();
        String entryName = rule.getEntryName();
        if (entryName != null) {
            orm.hint().setJoinHinter(name -> entryName.equals(name) || entryName.startsWith(name + ".") ? ORMHint.JoinHint.INNER : ORMHint.JoinHint.DEFAULT);
        }
        DataSet srcData = orm.queryDataSet("BalanceUtil.getSrcData", rule.getEntityNumber(), selectCols, fs.toArray(), null);
        srcData = BalEngineUtil.addFields(srcData, rule);
        return BalEngineUtil.transformData(rule, srcData);
    }

    static QFilter getRuleUpdatedFs(UpdateRule rule) {
        QFilter fs = new QFilter("ruleentry.rule", "=", (Object)rule.getId());
        DynamicObject data = QueryServiceHelper.queryOne((String)"bal_check_repair_setting", (String)"ruleentry.rule.sourceentitynumber.number,ruleentry.hasfilter,ruleentry.billfs_tag", (QFilter[])fs.toArray());
        if (data == null) {
            return new QFilter("billstatus", "=", (Object)"C");
        }
        String filter = data.getString("ruleentry.hasfilter");
        if ("A".equals(filter)) {
            String billName = data.getString("ruleentry.rule.sourceentitynumber.number");
            String fsStr = data.getString("ruleentry.billfs_tag");
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)fsStr, CRCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(MetadataServiceHelper.getDataEntityType((String)billName), condition.getFilterCondition());
            filterBuilder.buildFilter();
            return filterBuilder.getQFilter();
        }
        if ("B".equals(filter)) {
            return null;
        }
        if ("C".equals(filter)) {
            return new QFilter("billstatus", "=", (Object)"C");
        }
        throw new KDBizException("CheckRepairUtil.getRuleUpdatedFs error : hasfilter=" + filter);
    }

    private static DataSet transformData(UpdateRule rule, DataSet srcData) {
        BalanceTB bal = rule.getBalanceTB();
        ArrayList<IDataTransform> transCollector = new ArrayList<IDataTransform>();
        List<IBalanceUpdatePlugin> ps = BalEngineUtil.getTbPlugin(bal);
        for (IBalanceUpdatePlugin plugin : ps) {
            plugin.addTransform(transCollector, rule);
        }
        for (IDataTransform transform : transCollector) {
            BalLogUtil.info("IDataTransform :" + transform.getClass().getName(), new Object[0]);
            srcData = transform.doTransform(srcData);
        }
        srcData = BalEngineUtil.addCols(rule, srcData);
        srcData = srcData.map((MapFunction)new SpDataMapFunc(srcData.getRowMeta(), rule));
        return srcData;
    }

    private static DataSet addCols(UpdateRule rule, DataSet srcData) {
        BalanceTB balanceTB = rule.getBalanceTB();
        ArrayList<String> names = new ArrayList<String>(8);
        ArrayList<String> exprs = new ArrayList<String>(8);
        Set<String> balQtyCols = BalEngineUtil.getBalQtyCols(balanceTB);
        Set<String> qtyCols = rule.getOccCol4Update();
        for (String occCol : balQtyCols) {
            if (qtyCols.contains(occCol)) continue;
            names.add(occCol);
            exprs.add("0.0");
        }
        Map<String, DataType> coverColType = balanceTB.getCoverColType();
        Set<String> coverCols = rule.getCoverCol4Update();
        for (Map.Entry<String, DataType> entry : coverColType.entrySet()) {
            String col = entry.getKey();
            if (coverCols.contains(col)) continue;
            names.add(col);
            exprs.add(BalEngineUtil.getDefValExprs(entry.getValue()));
        }
        if (balanceTB.isPerBal()) {
            names.add(balanceTB.getPeriodCol());
            exprs.add("0");
        }
        if (!names.isEmpty()) {
            srcData = srcData.addFields(exprs.toArray(new String[0]), names.toArray(new String[0]));
        }
        return srcData;
    }

    static Set<String> getBalQtyCols(BalanceTB balanceTB) {
        return balanceTB.getColsByDataType(BizDataType.OCC, BizDataType.IN, BizDataType.INIT, BizDataType.OUT);
    }

    private static String getDefValExprs(DataType value) {
        if (value instanceof NumericType) {
            return "0";
        }
        if (value instanceof StringType || value instanceof BooleanType) {
            return "''";
        }
        return "null";
    }

    static DataSet queryOldSpData(UpdateRule rule, Set<Object> billIds, Set<Object> entryIds) {
        BalanceTB balanceTB = rule.getBalanceTB();
        Set<String> qtyCols = BalEngineUtil.getBalQtyCols(balanceTB);
        Set<String> otherCols = balanceTB.getColsByDataType(BizDataType.COVER, BizDataType.PER);
        int size = qtyCols.size() + otherCols.size() + 5;
        ArrayList<String> colExprs = new ArrayList<String>(size);
        colExprs.add(BalEngineUtil.buildColExpr("fid", balanceTB.toOldSpCol("id")));
        colExprs.add(BalEngineUtil.buildColExpr("fkeycol", balanceTB.toOldSpCol("keycol")));
        colExprs.add(BalEngineUtil.buildColExpr("fbillno", balanceTB.toOldSpCol("billno")));
        colExprs.add(BalEngineUtil.buildColExpr("fbillid", balanceTB.toOldSpCol("billid")));
        colExprs.add(BalEngineUtil.buildColExpr("fentryid", balanceTB.toOldSpCol("entryid")));
        colExprs.add(BalEngineUtil.buildColExpr("fentryseq", balanceTB.toOldSpCol("entryseq")));
        Map<String, String> colFieldMap = balanceTB.getColFieldMap();
        ArrayList<String> qtyColsAs = new ArrayList<String>(qtyCols.size());
        for (String qtyCol : qtyCols) {
            String colAs = balanceTB.toOldSpCol(qtyCol);
            qtyColsAs.add(colAs);
            colExprs.add(BalEngineUtil.buildColExpr("0-" + BalanceTB.parse2SnapName(colFieldMap.get(qtyCol)), colAs));
        }
        for (String otherCol : otherCols) {
            colExprs.add(BalEngineUtil.buildColExpr(colFieldMap.get(otherCol), balanceTB.toOldSpCol(otherCol)));
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append(" SELECT ", new Object[0]).append(String.join((CharSequence)",", colExprs), new Object[0]).append(" FROM ", new Object[0]).append(balanceTB.getSnapshotTb(), new Object[0]);
        sql.append(" WHERE ", new Object[0]).appendIn("fbillid", billIds.toArray());
        sql.append(" AND ", new Object[0]).append("fstatus=?", new Object[]{"A"});
        sql.append(" AND ", new Object[0]).append("fupdateruleid=?", new Object[]{rule.getId()});
        if (entryIds != null && rule.getEntryName() != null) {
            sql.append(" AND ", new Object[0]).appendIn("fentryid", entryIds.toArray());
        }
        DataSet oldSpData = DB.queryDataSet((String)"BalUpdate.queryOldSpData", (DBRoute)balanceTB.getDbRoute(), (SqlBuilder)sql);
        oldSpData = oldSpData.map((MapFunction)new HandleNullMapFunc(oldSpData.getRowMeta(), qtyColsAs));
        return oldSpData;
    }

    private static String buildColExpr(String name, String asName) {
        return BalUtil.buildColExpr(name, asName);
    }

    private static Map<String, Object> getExprVals(Map<String, Expr> colExpr, UpdateRule rule) {
        String msg;
        HashMap<String, Object> values = new HashMap<String, Object>(colExpr.size());
        ArrayList<String> msgs = new ArrayList<String>(colExpr.size());
        for (Map.Entry<String, Expr> entry : colExpr.entrySet()) {
            try {
                Object val = FormulaEngine.execExcelFormula((Expr)entry.getValue());
                if (val == null) {
                    msg = ResManager.loadKDString((String)"\u5b57\u6bb5{0}\uff1a\u8ba1\u7b97\u540e\u4e0d\u80fd\u4e3aNULL\u3002", (String)"BalEngineUtil_0", (String)"bos-biz-balance", (Object[])new Object[]{entry.getKey()});
                    continue;
                }
                values.put(entry.getKey(), val);
            }
            catch (Throwable e) {
                msg = ResManager.loadKDString((String)"\u5b57\u6bb5{0}\uff1a{1}\u3002", (String)"BalEngineUtil_1", (String)"bos-biz-balance", (Object[])new Object[]{entry.getKey(), e.getMessage()});
                msgs.add(msg);
                BalLogUtil.error(msg, e);
            }
        }
        if (!msgs.isEmpty()) {
            String no = rule.getRuleNo();
            String tempMsg = StringUtils.join(msgs, (String)",");
            msg = ResManager.loadKDString((String)"\u89c4\u5219{0}\u8fd0\u884c\u65f6\uff0c\u8868\u8fbe\u5f0f\u8ba1\u7b97\u9519\u8bef\uff1a{1}\u3002", (String)"BalEngineUtil_2", (String)"bos-biz-balance", (Object[])new Object[]{no, tempMsg});
            throw new KDBizException(msg);
        }
        return values;
    }

    private static DataSet addFields(DataSet srcData, UpdateRule rule) {
        Map<String, Expr> colExpr = rule.getColExpr();
        ArrayList<String> names = new ArrayList<String>(colExpr.size() + 2);
        ArrayList<String> vals = new ArrayList<String>(colExpr.size() + 2);
        if (StringUtils.isBlank((CharSequence)rule.getSrcNumberCol())) {
            vals.add("'-'");
            names.add("billno");
        }
        if (rule.getEntryName() == null) {
            vals.add("0");
            names.add("entryseq");
        }
        if (!colExpr.isEmpty()) {
            Map<String, Object> exprVals = BalEngineUtil.getExprVals(colExpr, rule);
            SimpleDateFormat mat = null;
            for (Map.Entry<String, Object> entry : exprVals.entrySet()) {
                names.add(entry.getKey());
                Object val = entry.getValue();
                if (val == null) {
                    vals.add(null);
                    continue;
                }
                if (val instanceof String) {
                    vals.add("'" + val + "'");
                    continue;
                }
                if (val instanceof Date) {
                    if (mat == null) {
                        mat = new SimpleDateFormat(DATE_FORMAT_PATTERN);
                    }
                    vals.add("to_date('" + mat.format((Date)val) + "','" + DATE_FORMAT_PATTERN + "')");
                    continue;
                }
                vals.add(String.valueOf(val));
            }
        }
        if (!names.isEmpty()) {
            srcData = srcData.addFields(vals.toArray(new String[0]), names.toArray(new String[0]));
        }
        return srcData;
    }

    private static void appendCols(StringBuilder srcSelectCols, Map<String, String> targetSrcCol, Map<String, String> srcColFullNameMap) {
        for (Map.Entry<String, String> col : targetSrcCol.entrySet()) {
            srcSelectCols.append(',').append(srcColFullNameMap.get(col.getValue())).append(AS).append(col.getKey());
        }
    }

    private static String getBillCols4Select(UpdateRule rule) {
        StringBuilder srcSelectCols = new StringBuilder();
        Map<String, String> targetSrcColMap = rule.getTargetSrcColMap();
        Map<String, String> srcColFullNameMap = rule.getSrcColFullNameMap();
        srcSelectCols.append("id").append(AS).append("billid");
        srcSelectCols.append(',').append(rule.getEntryPkName()).append(AS).append("entryid");
        BalEngineUtil.appendCols(srcSelectCols, targetSrcColMap, srcColFullNameMap);
        BalEngineUtil.appendCols(srcSelectCols, rule.getPeriodColMap(), srcColFullNameMap);
        BalEngineUtil.appendCols(srcSelectCols, rule.getLogicColMap(), srcColFullNameMap);
        if (StringUtils.isNotBlank((CharSequence)rule.getSrcNumberCol())) {
            srcSelectCols.append(',').append(rule.getSrcNumberCol()).append(AS).append("billno");
        }
        if (rule.getEntryName() != null) {
            srcSelectCols.append(',').append(rule.getEntryName()).append(".seq").append(AS).append("entryseq");
        }
        return srcSelectCols.toString();
    }

    static boolean isTheSameKey(BalanceTB balanceTB, String key, String oldKey, Row row) {
        boolean isSame = key.equals(oldKey);
        return balanceTB.isPerBal() ? isSame && row.getInteger(balanceTB.getPeriodCol()).intValue() == row.getInteger(balanceTB.toOldSpCol(balanceTB.getPeriodCol())).intValue() : isSame;
    }

    static Object[] parseParams(Map<String, Object> param, List<String> cols) {
        Object[] params = new Object[cols.size()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = param.get(cols.get(i));
        }
        return params;
    }

    static Key calKey(Row row, List<String> keyCols) {
        HashMap<String, Object> values = new HashMap<String, Object>(keyCols.size());
        StringBuilder sb = new StringBuilder();
        for (String keyCol : keyCols) {
            Object value = row.get(keyCol);
            if (BalEngineUtil.isDbDefaultValue(value)) continue;
            sb.append(keyCol).append(':').append(value).append(',');
            values.put(keyCol, value);
        }
        return new Key(BalKeyHandle.getKeyStr((String)sb.toString()), values);
    }

    static void throwUpdatingMsg(UpdateCtx ctx, boolean allAsync) {
        String msg;
        String listPage;
        MainEntityType billType = ctx.getBillType();
        String string = listPage = allAsync ? ResManager.loadKDString((String)"\u5f85\u66f4\u65b0\u5355\u636e", (String)"BalEngineUtil_3", (String)"bos-biz-balance", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u66f4\u65b0\u4e2d\u5355\u636e", (String)"BalEngineUtil_4", (String)"bos-biz-balance", (Object[])new Object[0]);
        if (billType instanceof IBillEntityType) {
            String nos = String.join((CharSequence)",", BalEngineUtil.getBillNos(billType, ctx.getBillIds()));
            msg = ResManager.loadKDString((String)"\u4f59\u989d\u66f4\u65b0\u4e1a\u52a1\u6682\u672a\u5f02\u6b65\u5904\u7406\u5b8c\u6bd5\uff0c\u8bf7\u51e0\u5206\u949f\u540e\u518d\u91cd\u8bd5\uff0c\u8be6\u60c5\u53ef\u67e5\u770b{0}\u5217\u8868\uff0c\u5355\u636e\uff1a{1}\u3002", (String)"BalEngineUtil_5", (String)"bos-biz-balance", (Object[])new Object[]{listPage, nos});
        } else {
            msg = ResManager.loadKDString((String)"\u64cd\u4f5c\u6570\u636e\u4e2d\u8fd8\u6709\u4f59\u989d\u66f4\u65b0\u4e1a\u52a1\u6682\u672a\u5f02\u6b65\u5904\u7406\u5b8c\u6bd5\uff0c\u8bf7\u51e0\u5206\u949f\u540e\u518d\u91cd\u8bd5\uff0c\u8be6\u60c5\u53ef\u67e5\u770b{0}\u5217\u8868\u3002", (String)"BalEngineUtil_6", (String)"bos-biz-balance", (Object[])new Object[]{listPage});
        }
        throw new KDBizException(msg);
    }

    private static List<String> getBillNos(MainEntityType billType, Set<Object> billIds) {
        ArrayList<String> nos = new ArrayList<String>(billIds.size());
        try (TXHandle tx = TX.notSupported((String)"BalUtil.getBillNos");){
            String billNo = ((IBillEntityType)billType).getBillNo();
            DynamicObjectCollection datas = QueryServiceHelper.query((String)billType.getName(), (String)billNo, (QFilter[])new QFilter("id", "in", billIds).toArray());
            for (DynamicObject data : datas) {
                nos.add(data.getString(billNo));
            }
        }
        return nos;
    }

    static void syncUpdateBal(BalanceTB bal, long txId) {
        TreeSet<Long> txs = new TreeSet<Long>();
        txs.add(txId);
        new SpDataHandle4Sync(bal, txs, false).moveAndUpdate();
    }

    static void syncRollbackBal(BalanceTB bal, TreeSet<Long> txIds) {
        new SpDataHandle4Sync(bal, txIds, true).moveAndUpdate();
    }

    private static void groupTxs(TxMsg txMsg, TreeSet<Long> validTx, TreeSet<Long> invalidTx) {
        HashSet<Long> allTxs = new HashSet<Long>(txMsg.txs);
        String txFs = QFUtil.getIdsFilter(allTxs);
        try (DataSet datas = BalEngineUtil.queryTxs4Check(txMsg.bal, txMsg.billDB, txFs);){
            int idx = datas.getRowMeta().getFieldIndex("FTXID");
            for (Row row : datas) {
                Long txId = row.getLong(idx);
                allTxs.remove(txId);
                validTx.add(txId);
            }
        }
        invalidTx.addAll(allTxs);
    }

    public static void handleTxMsg(TxMsg txMsg) {
        BalLogUtil.info("BalEngineUtil.handleTxMsg start", new Object[0]);
        if (txMsg.txs.isEmpty()) {
            return;
        }
        TreeSet<Long> validTx = new TreeSet<Long>();
        TreeSet<Long> invalidTx = new TreeSet<Long>();
        BalEngineUtil.groupTxs(txMsg, validTx, invalidTx);
        if (!validTx.isEmpty()) {
            SpDataHandle4Async handle = new SpDataHandle4Async(txMsg.billDB, txMsg.bal, validTx, true);
            handle.moveAndUpdate();
            if (handle.hasError) {
                BalLogUtil.info("SpDataHandle4Async result: hasError = true", new Object[0]);
                handle = new SpDataHandle4Async(txMsg.billDB, txMsg.bal, validTx, true);
                handle.moveAndUpdate();
            }
        }
        if (!txMsg.isSkipInvaildTxs() && !invalidTx.isEmpty()) {
            new SpDataHandle4Async(txMsg.billDB, txMsg.bal, invalidTx, false).moveAndUpdate();
        }
    }

    static void clearUpdating(String txFs) {
        try (TXHandle tx = TX.requiresNew((String)"BalUtil.clearUpdating");){
            try {
                DB.execute((DBRoute)IBalance.BAL_DB, (String)("DELETE FROM T_BAL_UPDATING WHERE FTXID " + txFs));
            }
            catch (Throwable e) {
                tx.markRollback();
                BalLogUtil.error("BalUtil.clearUpdating", txFs, null, e);
                throw e;
            }
        }
    }

    static void clearBizTxs(BalanceTB bal, DBRoute occDb, String txFs) {
        try (TXHandle tx = TX.requiresNew((String)"BalUtil.clearBizTxs");){
            try {
                String sql = "DELETE FROM " + bal.getOrCreateTxTb(occDb) + " WHERE FTXID " + txFs;
                DB.execute((DBRoute)occDb, (String)sql);
            }
            catch (Throwable e) {
                tx.markRollback();
                BalLogUtil.error("BalUtil.clearBizTxs", occDb.getRouteKey() + "," + txFs, null, e);
                throw e;
            }
        }
    }

    static void clearUpdating(Collection<Long> txIds) {
        String idsFilter = QFUtil.getIdsFilter(txIds);
        BalEngineUtil.clearUpdating(idsFilter);
    }

    private static void handleTaskResult(List<Future<TaskResult>> results) {
        try {
            ArrayList<TaskResult> fails = new ArrayList<TaskResult>(8);
            for (Future<TaskResult> result : results) {
                TaskResult temp = result.get();
                if (temp.isSucces()) continue;
                fails.add(temp);
            }
            BalEngineUtil.throwAllEx(fails);
        }
        catch (Throwable e) {
            throw new RuntimeException("BalEngineUtil.moveSnapshot error:", e);
        }
    }

    private static void throwAllEx(List<TaskResult> fails) {
        if (fails.isEmpty()) {
            return;
        }
        StringBuilder msg = new StringBuilder("traceIds=[");
        int i = 0;
        for (TaskResult fail : fails) {
            if (i++ > 0) {
                msg.append(',');
            }
            msg.append(fail.getMsg());
        }
        msg.append("]").append("\r\n");
        throw new KDBizException("BalEngineUtil error:" + msg);
    }

    private static void addPollingTxParam(List<PollingTxParam> params, Row row) {
        try {
            PollingTxParam param = new PollingTxParam();
            param.db = DBRoute.of((String)row.getString("db"));
            param.app = row.getString("app");
            param.bal = BalanceTB.getBalanceTB(row.getString("bal"));
            params.add(param);
        }
        catch (Exception e) {
            BalLogUtil.saveError("BalEngineUtil", String.valueOf(row), "addPollingTxParam", e);
        }
    }

    private static List<PollingTxParam> buildPollingTxParams() {
        ArrayList<PollingTxParam> params = new ArrayList<PollingTxParam>(16);
        QFilter fs = new QFilter("type", "=", (Object)"2");
        try (DataSet data = QueryServiceHelper.queryDataSet((String)"buildPollingTxParams", (String)"bal_occurred_dbs", (String)"db,app,bal", (QFilter[])fs.toArray(), null).distinct();){
            for (Row row : data) {
                BalEngineUtil.addPollingTxParam(params, row);
            }
        }
        return params;
    }

    static void pollingAllTxs() {
        List<PollingTxParam> params = BalEngineUtil.buildPollingTxParams();
        for (PollingTxParam param : params) {
            try {
                BalEngineUtil.pollingAllTxs(param);
            }
            catch (Throwable e) {
                BalLogUtil.saveError("BalEngineUtil", param.toString(), "pollingAllTxs", e);
            }
        }
    }

    private static void pollingAllTxs(PollingTxParam param) {
        Long limitTxId;
        BalConfig cfg = BalConfig.loadBalConfig(param.bal.getName());
        param.aliveCache = new HashMap<String, Boolean>(8);
        Date now = new Date();
        param.expireTime = now.getTime() - (long)cfg.getClearInvalidMin() * 60000L;
        param.limitTime = new Date(now.getTime() - (long)cfg.getClearSafeMin() * 60000L);
        param.clearCheckTxBatch = cfg.getClearCheckTxBatch();
        param.clearPubTxBatch = cfg.getClearPubTxBatch();
        int i = 20;
        while (i-- > 0 && (limitTxId = BalEngineUtil.doPollingAllTxs(param)) != null) {
            param.limitTxId = limitTxId;
        }
    }

    private static boolean isInstanceAlive(Map<String, Boolean> cache, String instanceId) {
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            return false;
        }
        Boolean alive = cache.get(instanceId);
        if (alive == null) {
            boolean isAlive = LivingServiceUtils.isInstanceAlive((String)instanceId);
            if (!isAlive) {
                try {
                    Thread.sleep(30000L);
                    isAlive = LivingServiceUtils.isInstanceAlive((String)instanceId);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            alive = isAlive;
            cache.put(instanceId, alive);
        }
        return alive;
    }

    private static boolean isExpire(long limit, Map<String, Boolean> cache, Row data) {
        Date createTime = data.getDate("FCREATETIME");
        if (createTime == null || createTime.getTime() < limit) {
            return true;
        }
        return !BalEngineUtil.isInstanceAlive(cache, data.getString("FINSTANCEID"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Long doPollingAllTxs(PollingTxParam param) {
        Object[] objectArray;
        String sql;
        BalLogUtil.info("BalEngineUtil.doPollingAllTxs start: " + param, new Object[0]);
        String string = sql = param.limitTxId == null ? "SELECT DISTINCT TOP 50000 FTXID,FBILLENTITY,FINSTANCEID,FCREATETIME FROM T_BAL_UPDATING WHERE FBAL = ?  AND FDB = ? AND FAPP = ? AND FCREATETIME < ?  ORDER BY FTXID ASC " : "SELECT DISTINCT TOP 50000 FTXID,FBILLENTITY,FINSTANCEID,FCREATETIME FROM T_BAL_UPDATING WHERE FBAL = ?  AND FDB = ? AND FAPP = ? AND FCREATETIME < ? AND FTXID > ? ORDER BY FTXID ASC ";
        if (param.limitTxId == null) {
            Object[] objectArray2 = new Object[4];
            objectArray2[0] = param.bal.getName();
            objectArray2[1] = param.db.getRouteKey();
            objectArray2[2] = param.app;
            objectArray = objectArray2;
            objectArray2[3] = param.limitTime;
        } else {
            Object[] objectArray3 = new Object[5];
            objectArray3[0] = param.bal.getName();
            objectArray3[1] = param.db.getRouteKey();
            objectArray3[2] = param.app;
            objectArray3[3] = param.limitTime;
            objectArray = objectArray3;
            objectArray3[4] = param.limitTxId;
        }
        Object[] args = objectArray;
        try (DataSet datas = DB.queryDataSet((String)"POLLING_ALL_TXS", (DBRoute)IBalance.BAL_DB, (String)sql, (Object[])args);){
            HashSet<Long> allTxs = new HashSet<Long>(param.clearCheckTxBatch);
            ArrayList<Long> invalidTxs = new ArrayList<Long>(param.clearCheckTxBatch);
            int count = 0;
            Long lastTxId = null;
            try (MessagePublisher pub = null;){
                if (BalConfig.isServiceByMQ()) {
                    pub = MQFactory.get().createPartitionPublisher("bal_queue", "bal.tx_update", PartitionStrategy.APP_ID);
                }
                for (Row data : datas) {
                    lastTxId = data.getLong("FTXID");
                    ++count;
                    if (!BalEngineUtil.isExpire(param.expireTime, param.aliveCache, data)) continue;
                    allTxs.add(lastTxId);
                    if (allTxs.size() < param.clearCheckTxBatch) continue;
                    BalEngineUtil.collectInvalidTxs(invalidTxs, allTxs, param, pub);
                    allTxs.clear();
                }
                if (allTxs.size() > 0) {
                    BalEngineUtil.collectInvalidTxs(invalidTxs, allTxs, param, pub);
                    allTxs.clear();
                }
                if (invalidTxs.size() > 0) {
                    BalEngineUtil.publishInValidTx(invalidTxs, param, pub);
                    invalidTxs.clear();
                }
            }
            Long l = count < 50000 ? null : lastTxId;
            return l;
        }
    }

    private static void publishInValidTx(List<Long> txs, PollingTxParam param, MessagePublisher pub) {
        JSONObject msg = new JSONObject();
        msg.put("db", (Object)param.db.getRouteKey());
        msg.put("bal", (Object)param.bal.getName());
        msg.put("appid", (Object)param.app);
        msg.put("txs", (Object)StringUtils.join(txs, (char)','));
        if (pub != null) {
            pub.publish((Object)msg.toJSONString(), param.app);
        } else {
            BalServiceHelper.invokeBalService(param.app, "mockTxMsg", param.bal.getName(), msg.toJSONString());
        }
    }

    private static DataSet queryTxs4Check(BalanceTB bal, DBRoute occDb, String txFs) {
        String sql = "SELECT FTXID FROM " + bal.getOrCreateTxTb(occDb) + " WHERE FTXID" + txFs;
        DataSet datas = DB.queryDataSet((String)"queryTxs4Check_occdb", (DBRoute)occDb, (String)sql);
        DBRoute balDb = bal.getDbRoute();
        if (!balDb.getRouteKey().equals(occDb.getRouteKey())) {
            bal.getOrCreateTxTb(balDb);
            datas = datas.union(DB.queryDataSet((String)"queryTxs4Check_baldb", (DBRoute)balDb, (String)sql));
        }
        return datas;
    }

    private static void collectInvalidTxs(List<Long> invalidTxs, Set<Long> txs, PollingTxParam param, MessagePublisher pub) {
        String txIdFs = QFUtil.getIdsFilter(txs);
        try (DataSet datas = BalEngineUtil.queryTxs4Check(param.bal, param.db, txIdFs);){
            for (Row row : datas) {
                txs.remove(row.getLong("FTXID"));
            }
        }
        for (Long tx : txs) {
            invalidTxs.add(tx);
            if (invalidTxs.size() < param.clearPubTxBatch) continue;
            BalEngineUtil.publishInValidTx(invalidTxs, param, pub);
            invalidTxs.clear();
        }
    }

    static List<IBalanceUpdatePlugin> getTbPlugin(BalanceTB bal) {
        return BalEngineUtil.getTbPlugin(bal.getPlugins());
    }

    static List<IBalanceUpdatePlugin> getTbPlugin(List<String> pluginNames) {
        ArrayList<IBalanceUpdatePlugin> tempPlugins = new ArrayList<IBalanceUpdatePlugin>(pluginNames.size());
        String pluginName = null;
        try {
            Iterator<String> iterator = pluginNames.iterator();
            while (iterator.hasNext()) {
                String plugin;
                pluginName = plugin = iterator.next();
                Class<?> pluginClass = Class.forName(plugin);
                tempPlugins.add((IBalanceUpdatePlugin)pluginClass.newInstance());
            }
            return tempPlugins;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63d2\u4ef6{0}\u4e0d\u5b58\u5728\u6216\u8005\u8be5\u63d2\u4ef6\u6ca1\u6709\u5b9e\u73b0\u63a5\u53e3{1}\u3002", (String)"BalEngineUtil_7", (String)"bos-biz-balance", (Object[])new Object[]{pluginName, IBalanceUpdatePlugin.class.getName()}));
        }
    }

    static DataSet distinctEntryId(DataSet data, String entryCol, String oldEntryCol) {
        RowMeta meta = data.getRowMeta();
        int entryIdIdx = meta.getFieldIndex(entryCol);
        int oldEntryIdIdx = meta.getFieldIndex(oldEntryCol);
        return data.groupBy(new String[]{oldEntryCol}).reduceGroup((ReduceGroupFunctionWithCollector)new DistinctEntryIdReduceGroup(meta, entryIdIdx, oldEntryIdIdx));
    }

    static void addTx2ThreadLocal(String name, long txId) {
        Map<String, List<Long>> txMap = localTxs.get();
        List<Long> txs = txMap.get(name);
        if (txs == null) {
            txs = new ArrayList<Long>(4);
            txMap.put(name, txs);
        }
        if (txs.size() < 1000) {
            txs.add(txId);
        }
    }

    public static void collectTxFromThreadLocal(String name, Set<Long> txSet) {
        if (txSet == null) {
            return;
        }
        Map<String, List<Long>> txMap = localTxs.get();
        List<Long> txs = txMap.get(name);
        if (txs != null && txs.size() > 0) {
            txSet.addAll(txs);
        }
    }

    private static class PollingTxParam {
        BalanceTB bal;
        DBRoute db;
        String app;
        Long limitTxId;
        long expireTime;
        Date limitTime;
        Map<String, Boolean> aliveCache;
        int clearCheckTxBatch;
        int clearPubTxBatch;

        private PollingTxParam() {
        }
    }
}

