/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.core;

import com.alibaba.fastjson.JSON;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.bal.business.consumer.NotifyMsg;
import kd.bos.bal.business.consumer.ReUpdateMsg;
import kd.bos.bal.business.core.BalConfig;
import kd.bos.bal.business.core.BalEngine;
import kd.bos.bal.business.core.BalEngineUtil;
import kd.bos.bal.business.core.BalTxListener;
import kd.bos.bal.business.core.BalanceLog;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.bal.common.QFUtil;
import kd.bos.bal.common.TxInfo;
import kd.bos.bal.servicehelper.BalServiceHelper;
import kd.bos.biz.balance.engine.UpdateRuleCache;
import kd.bos.biz.balance.model.BalReUpdateParam;
import kd.bos.biz.balance.model.BalUpdateParam;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.biz.balance.model.IBalance;
import kd.bos.biz.balance.model.IRuleFilter;
import kd.bos.biz.balance.model.UpdateCtx;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.support.partition.PartitionStrategy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BalManager {
    public static void doUpdate(BalUpdateParam param) {
        BalLogUtil.info("BalManager.doUpdate start: BalUpdateParam", new Object[0]);
        UpdateCtx ctx = new UpdateCtx(param.getOp(), param.getEntityNumber(), param.getBillIds());
        ctx.setOpAlias(param.getOpAlias());
        ctx.setEntryIds(param.getEntryIds());
        ctx.setWaitType(param.getWaitType());
        BalTxListener listener = new BalTxListener(ctx);
        TX.addCommitListener((CommitListener)listener);
        BalManager.doUpdate(ctx);
    }

    public static void doUpdate(UpdateCtx ctx) {
        BalLogUtil.info("BalManager.doUpdate start: UpdateCtx", new Object[0]);
        BalanceLog balanceLog = new BalanceLog();
        try {
            List<UpdateRule> rules = BalManager.loadUpdateRule(ctx.getEntityNumber(), ctx.getOp());
            BalManager.sortRules(rules, ctx.getOp());
            BalManager.tryWaitUpdate(ctx, rules);
            BalManager.updateRules(balanceLog, ctx, rules, false);
            ctx.setOverAndSuccess(true);
        }
        catch (Throwable ex) {
            balanceLog.setFail(ctx, ex);
            BalManager.doRollBackData(ctx);
            throw ex;
        }
        finally {
            balanceLog.save();
        }
    }

    private static void sortRules(List<UpdateRule> rules, String op) {
        rules.sort((r1, r2) -> {
            int hashCode = r1.getBalanceNo().hashCode() - r2.getBalanceNo().hashCode();
            return hashCode == 0 ? BalManager.getIncreaseType(r2, op) - BalManager.getIncreaseType(r1, op) : hashCode;
        });
    }

    private static int getIncreaseType(UpdateRule rule, String op) {
        return rule.getUpdateType() * (rule.isForwardOp(op) ? 1 : -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void tryWaitUpdate(UpdateCtx ctx, List<UpdateRule> rules) {
        type = ctx.getWaitType();
        if (type == null) return;
        if (type.timeOut <= 0) {
            return;
        }
        BalLogUtil.info("BalManager.tryWaitUpdate start: " + type, new Object[0]);
        limitTime = System.currentTimeMillis() + (long)type.timeOut;
        sleepCount = 0;
        try {
            billDB = DBRoute.of((String)ctx.getBillType().getDBRouteKey());
            asyncInfoTbs = rules.stream().map((Function<UpdateRule, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$tryWaitUpdate$1(kd.bos.db.DBRoute kd.bos.biz.balance.model.UpdateRule ), (Lkd/bos/biz/balance/model/UpdateRule;)Ljava/lang/String;)((DBRoute)billDB)).collect(Collectors.toSet()).toArray(new String[0]);
            whereStr = QFUtil.getIdsFilter(ctx.getBillIds());
            while (limitTime > System.currentTimeMillis()) {
                if (BalManager.needWait(asyncInfoTbs, billDB, whereStr)) {
                    Thread.sleep(type.interval);
                    ++sleepCount;
                    continue;
                }
                ** GOTO lbl27
            }
            ** GOTO lbl30
        }
        catch (InterruptedException e) {
            try {
                BalLogUtil.error("wait error:", e);
            }
            catch (Throwable var11_12) {
                waitTime = System.currentTimeMillis() - limitTime + (long)type.timeOut;
                BalLogUtil.info("TotalWaitTime={}ms,SleepCount={}", new Object[]{waitTime, sleepCount});
                throw var11_12;
            }
lbl27:
            // 1 sources

            waitTime = System.currentTimeMillis() - limitTime + (long)type.timeOut;
            BalLogUtil.info("TotalWaitTime={}ms,SleepCount={}", new Object[]{waitTime, sleepCount});
            return;
lbl30:
            // 1 sources

            waitTime = System.currentTimeMillis() - limitTime + (long)type.timeOut;
            BalLogUtil.info("TotalWaitTime={}ms,SleepCount={}", new Object[]{waitTime, sleepCount});
            return;
            waitTime = System.currentTimeMillis() - limitTime + (long)type.timeOut;
            BalLogUtil.info("TotalWaitTime={}ms,SleepCount={}", new Object[]{waitTime, sleepCount});
            return;
        }
    }

    private static boolean needWait(String[] asyncInfoTbs, DBRoute billDB, String where) {
        try (DataSet data = DB.queryDataSet((String)"look_bal_updating", (DBRoute)IBalance.BAL_DB, (String)("SELECT TOP 1 FID FROM T_BAL_UPDATING WHERE FBILLID " + where));){
            boolean bl = !data.isEmpty();
            return bl;
        }
    }

    private static void doRollBackData(UpdateCtx ctx, boolean isReUpdate, boolean saveLog) {
        BalLogUtil.info("BalManager.doRollBackData start : isReUpdate = {}, saveLog = {}", isReUpdate, saveLog);
        if (ctx != null && !ctx.isRollBackOver()) {
            BalanceLog balanceLog = saveLog ? new BalanceLog() : null;
            ctx.setBizRollback(true);
            try {
                Map<Long, TxInfo> txInfo = ctx.getTxInfo();
                List<UpdateRule> rules = txInfo.values().stream().map(tx -> tx.getRule()).collect(Collectors.toList());
                if (balanceLog != null) {
                    balanceLog.startLog(rules, ctx);
                    BalManager.logStart(balanceLog, rules);
                }
                if (!txInfo.isEmpty()) {
                    Map<BalanceTB, List<TxInfo>> balTxs = BalManager.groupTxByBal(txInfo);
                    BalManager.rollBackSyncRules(ctx, balTxs);
                    BalEngineUtil.clearUpdating(txInfo.keySet());
                    BalManager.clearSpData(balTxs);
                }
                ctx.setRollBackOver(true);
                if (balanceLog != null) {
                    BalManager.logSuccess(balanceLog, rules);
                }
            }
            catch (Throwable ex) {
                if (balanceLog != null) {
                    balanceLog.setFail(ctx, ex);
                }
                throw ex;
            }
            finally {
                if (balanceLog != null) {
                    balanceLog.save();
                }
            }
        }
    }

    public static void doRollBackData(UpdateCtx ctx) {
        BalManager.doRollBackData(ctx, false, true);
    }

    static void tryMarkSpDataReadable(BalanceTB bal, List<Long> txs) {
        StringBuilder sql = new StringBuilder();
        try {
            sql.append(" UPDATE ").append(bal.getTmpSnapshotTb());
            sql.append(" SET ").append("freadtype").append("='").append("1").append("' WHERE ");
            sql.append("fupdatetime").append(QFUtil.getIdsFilter(txs));
            sql.append(" AND ").append("freadtype").append("='").append("0").append("' ");
            try (TXHandle tx = TX.requiresNew((String)"markSpDataReadable");){
                try {
                    DB.update((DBRoute)bal.getDbRoute(), (String)sql.toString());
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
        catch (Throwable t) {
            BalLogUtil.saveError("BalManager", sql.toString(), "markSpDataReadable", t);
        }
    }

    public static void doReUpdate(BalReUpdateParam param) {
        BalLogUtil.info("BalManager.doReUpdate(BalReUpdateParam) start", new Object[0]);
        try (TXHandle tx = TX.required();){
            Set<UpdateRule> rules = param.getReUpdateRules();
            Set<Object> billIds = param.getBillIds();
            if (rules.isEmpty() || billIds == null || billIds.isEmpty()) {
                return;
            }
            String billEntity = BalManager.getAndCheckEntity(rules);
            String op = StringUtils.isBlank((CharSequence)param.getOp()) ? (param.isRollBack() ? "#re_rollback#" : "#re_cal#") : param.getOp();
            rules = rules.stream().filter(rule -> rule.isMatchUpdate(op)).collect(Collectors.toSet());
            UpdateCtx ctx = new UpdateCtx(op, billEntity, billIds);
            ctx.setForceType(2);
            ctx.setEnableUpdatedFs(param.isEnableUpdatedFs());
            BalTxListener listener = new BalTxListener(ctx);
            TX.addCommitListener((CommitListener)listener);
            BalanceLog balanceLog = param.isSaveLog() ? new BalanceLog() : null;
            try {
                BalManager.updateRules(balanceLog, ctx, rules, true);
                ctx.setOverAndSuccess(true);
            }
            catch (Throwable ex) {
                BalManager.doRollBackData(ctx, true, param.isSaveLog());
                if (balanceLog != null) {
                    balanceLog.setFail(ctx, ex);
                }
                throw ex;
            }
            finally {
                if (balanceLog != null) {
                    balanceLog.setTypeAsyncTask();
                    balanceLog.save();
                }
            }
        }
    }

    public static void doReUpdate(Set<Object> billIds, UpdateRule rule) {
        BalReUpdateParam updateParam = new BalReUpdateParam(billIds, null, false);
        updateParam.addReUpdateRules(rule);
        BalManager.doReUpdate(updateParam);
    }

    private static void logSuccess(BalanceLog balanceLog, List<UpdateRule> rules) {
        for (UpdateRule rule : rules) {
            balanceLog.setSuccess(rule, 0L, 0);
        }
    }

    private static void logStart(BalanceLog balanceLog, List<UpdateRule> rules) {
        for (UpdateRule rule : rules) {
            balanceLog.startRule(rule);
        }
    }

    private static Map<BalanceTB, List<TxInfo>> groupTxByBal(Map<Long, TxInfo> txInfo) {
        HashMap<BalanceTB, List<TxInfo>> balTxs = new HashMap<BalanceTB, List<TxInfo>>(8);
        int size = txInfo.size();
        for (TxInfo info : txInfo.values()) {
            BalanceTB bal = info.getRule().getBalanceTB();
            ArrayList<TxInfo> txs = (ArrayList<TxInfo>)balTxs.get(bal);
            if (txs == null) {
                txs = new ArrayList<TxInfo>(size);
                balTxs.put(bal, txs);
            }
            txs.add(info);
        }
        return balTxs;
    }

    private static void rollBackSyncRules(UpdateCtx ctx, Map<BalanceTB, List<TxInfo>> balTxs) {
        BalLogUtil.info("BalManager.rollBackSyncRules start", new Object[0]);
        for (Map.Entry<BalanceTB, List<TxInfo>> entry : balTxs.entrySet()) {
            BalanceTB bal = entry.getKey();
            List txIds = entry.getValue().stream().filter(info -> info.isSync() && info.getStatus() == 2).map(info -> info.getTxid()).collect(Collectors.toList());
            if (txIds.isEmpty()) continue;
            BalManager.syncRollbackBal(ctx, bal, new TreeSet<Long>(txIds));
        }
    }

    private static void syncRollbackBal(UpdateCtx ctx, BalanceTB bal, TreeSet<Long> txIds) {
        BalLogUtil.info("BalManager.syncRollbackBal start", new Object[0]);
        try (TXHandle tx = TX.requiresNew((String)"syncRollbackBal");){
            try {
                BalEngineUtil.syncRollbackBal(bal, txIds);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private static void createAsyncInfo(UpdateCtx ctx, List<UpdateRule> asyncRules) {
        BalanceTB bal;
        BalLogUtil.info("BalManager.createAsyncInfo start", new Object[0]);
        Set<Object> billIds = ctx.getBillIds();
        int size = asyncRules.size() * billIds.size();
        if (size == 0) {
            return;
        }
        String billEntity = ctx.getEntityNumber();
        String op = ctx.getOp();
        Date now = new Date();
        int xdbFlag = ctx.getXdbFlag();
        String db = ctx.getBillType().getDBRouteKey();
        int i = 0;
        long[] ids = DB.genGlobalLongIds((int)size);
        long userId = RequestContext.getOrCreate().getCurrUserId();
        HashMap asyncInfoParams = new HashMap(4);
        for (UpdateRule rule : asyncRules) {
            bal = rule.getBalanceTB();
            ArrayList<Object[]> params = (ArrayList<Object[]>)asyncInfoParams.get(bal);
            if (params == null) {
                params = new ArrayList<Object[]>(size);
                asyncInfoParams.put(bal, params);
            }
            String ruleId = rule.getId();
            for (Object billId : billIds) {
                params.add(new Object[]{ids[i++], billId, ruleId, rule.getBalanceNo(), billEntity, op, db, xdbFlag, userId, now});
            }
        }
        String appId = ctx.getBillType().getAppId();
        DBRoute billDb = DBRoute.of((String)db);
        for (Map.Entry asyncInfoParam : asyncInfoParams.entrySet()) {
            bal = (BalanceTB)asyncInfoParam.getKey();
            BalManager.tryAddBizDBRecord(bal, appId, db, "1");
            BalManager.addAsyncInfo2BizDB(ctx, bal, (List)asyncInfoParam.getValue(), billDb);
        }
    }

    private static void createTxInfo(UpdateCtx ctx, List<BalEngine> engines) {
        BalanceTB bal;
        BalLogUtil.info("BalManager.createTxInfo start", new Object[0]);
        Date now = new Date();
        long userId = RequestContext.getOrCreate().getCurrUserId();
        int xdbFlag = ctx.getXdbFlag();
        String db = ctx.getBillType().getDBRouteKey();
        HashMap<BalanceTB, ArrayList<Object[]>> txParams = new HashMap<BalanceTB, ArrayList<Object[]>>(4);
        for (BalEngine engine : engines) {
            bal = engine.getRule().getBalanceTB();
            ArrayList<Object[]> params = (ArrayList<Object[]>)txParams.get(bal);
            if (params == null) {
                params = new ArrayList<Object[]>(2);
                txParams.put(bal, params);
            }
            params.add(new Object[]{engine.getTxId(), bal.getName(), db, xdbFlag, userId, now, null});
        }
        DBRoute billDb = DBRoute.of((String)db);
        String appId = ctx.getBillType().getAppId();
        for (Map.Entry txParam : txParams.entrySet()) {
            bal = (BalanceTB)txParam.getKey();
            BalManager.tryAddBizDBRecord(bal, appId, db, "2");
            BalManager.addTx2BizDB(bal, (List)txParam.getValue(), billDb);
        }
    }

    private static void updateRules(BalanceLog balanceLog, UpdateCtx ctx, Collection<UpdateRule> rules, boolean isReCal) {
        boolean saveLog;
        boolean bl = saveLog = balanceLog != null;
        if (saveLog) {
            balanceLog.startLog(rules, ctx);
        }
        ArrayList<BalEngine> engines = new ArrayList<BalEngine>(rules.size());
        ArrayList<UpdateRule> asyncRules = new ArrayList<UpdateRule>(rules.size());
        for (UpdateRule rule : rules) {
            if (!isReCal && rule.getBalanceTB().isAsyncUpdate()) {
                asyncRules.add(rule);
                ctx.getAllAsyncBals().add(rule.getBalanceNo());
                continue;
            }
            engines.add(new BalEngine(ctx, rule));
            ctx.getPartAsyncBals().add(rule.getBalanceNo());
        }
        BalManager.createTxInfo(ctx, engines);
        UpdateRule tempRule = null;
        BalEngine tempEngine = null;
        try {
            for (BalEngine engine : engines) {
                tempRule = engine.getRule();
                if (saveLog) {
                    balanceLog.startRule(tempRule);
                }
                if (isReCal) {
                    engine.doReCal();
                } else {
                    engine.doUpdate();
                }
                if (!saveLog) continue;
                balanceLog.setSuccess(tempRule, engine.getPluginUseTime(), engine.getSpDataCount());
            }
        }
        catch (Throwable ex) {
            if (tempRule != null && saveLog) {
                long useTime = 0L;
                int spDataCount = 0;
                if (tempEngine != null) {
                    useTime = tempEngine.getPluginUseTime();
                    spDataCount = tempEngine.getSpDataCount();
                }
                balanceLog.setFail(tempRule, useTime, spDataCount, ex);
            }
            throw ex;
        }
        BalManager.createAsyncInfo(ctx, asyncRules);
    }

    private static String getAndCheckEntity(Collection<UpdateRule> rules) {
        String entity = null;
        for (UpdateRule rule : rules) {
            String temp = rule.getEntityNumber();
            if (entity == null) {
                entity = temp;
                continue;
            }
            if (entity.equals(temp)) continue;
            throw new RuntimeException(ResManager.loadKDString((String)"\u91cd\u7b97\u7684\u89c4\u5219\u96c6\u5408\uff0c\u5fc5\u987b\u4e3a\u540c\u4e00\u4e2a\u5355\u636e\u7684\u89c4\u5219\u3002", (String)"BalManager_0", (String)"bos-biz-balance", (Object[])new Object[0]));
        }
        return entity;
    }

    private static void clearSpData(Map<BalanceTB, List<TxInfo>> balTxs) {
        BalLogUtil.info("BalManager.clearSpData start", new Object[0]);
        for (Map.Entry<BalanceTB, List<TxInfo>> entry : balTxs.entrySet()) {
            BalanceTB bal = entry.getKey();
            List txIds = entry.getValue().stream().map(info -> info.getTxid()).collect(Collectors.toList());
            if (txIds.isEmpty()) continue;
            BalManager.clearSpData(bal.getDbRoute(), String.format("DELETE FROM %s WHERE FUPDATETIME %s ", bal.getTmpSnapshotTb(), QFUtil.getIdsFilter(txIds)));
        }
    }

    private static void clearSpData(DBRoute db, String sql) {
        try (TXHandle tx = TX.requiresNew((String)"CLEAR_SPDATA");){
            try {
                DB.execute((DBRoute)db, (String)sql);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private static void addTx2BizDB(BalanceTB bal, List<Object[]> params, DBRoute billDb) {
        String txTb = bal.getOrCreateTxTb(billDb);
        String sql = "INSERT INTO " + txTb + " (FTXID,FBAL,FDB,FXDBFLAG,FCREATERID,FCREATETIME,FPUBLISHTIME) VALUES (?,?,?,?,?,?,?) ";
        DB.executeBatch((DBRoute)billDb, (String)sql, params);
    }

    private static void addAsyncInfo2BizDB(UpdateCtx ctx, BalanceTB bal, List<Object[]> params, DBRoute billDb) {
        try {
            String asyncInfoTb = bal.getOrCreateTempAsyncInfoTb(billDb);
            String sql = "INSERT INTO " + asyncInfoTb + " (FID,FBILLID,FRULEID,FBAL,FBILLENTITY,FOP,FDB,FXDBFLAG,FCREATERID,FCREATETIME) VALUES (?,?,?,?,?,?,?,?,?,?) ";
            DB.executeBatch((DBRoute)billDb, (String)sql, params);
        }
        catch (Exception e) {
            if (BalLogUtil.isUniqueError(e)) {
                BalManager.notifyAsyncInfo(ctx, bal, params, billDb);
                BalEngineUtil.throwUpdatingMsg(ctx, true);
            }
            throw e;
        }
    }

    private static void notifyAsyncInfo(UpdateCtx ctx, BalanceTB bal, List<Object[]> params, DBRoute billDb) {
        if (!BalConfig.loadBalConfig(bal.getName()).isNotityAsyncInfo4Op()) {
            return;
        }
        BalLogUtil.info("BalManager.notifyAsyncInfo start", new Object[0]);
        HashSet<String> ruleIds = new HashSet<String>(4);
        for (Object[] param : params) {
            ruleIds.add((String)param[2]);
        }
        HashMap<String, ReUpdateMsg> reUpdateMsgMap = new HashMap<String, ReUpdateMsg>(4);
        try (TXHandle tx = TX.requiresNew((String)"notifyAsyncInfo");){
            String sql = " SELECT FID, FBILLID,FRULEID,FOP FROM " + bal.getOrCreateAsyncInfoTb(billDb) + " WHERE FRULEID " + QFUtil.getIdsFilter(ruleIds, true) + " AND FBILLID " + QFUtil.getIdsFilter(ctx.getBillIds());
            try (DataSet datas = DB.queryDataSet((String)"BalManager.notifyAsyncInfo", (DBRoute)billDb, (String)sql);){
                RowMeta rowMeta = datas.getRowMeta();
                int fbillIdIdx = rowMeta.getFieldIndex("FBILLID");
                int fruleIdx = rowMeta.getFieldIndex("FRULEID");
                int fopIdx = rowMeta.getFieldIndex("FOP");
                int fidIdx = rowMeta.getFieldIndex("FID");
                for (Row data : datas) {
                    String ruleAndOp = data.getString(fruleIdx) + data.getString(fopIdx);
                    ReUpdateMsg reUpdateMsg = reUpdateMsgMap.computeIfAbsent(ruleAndOp, key -> new ReUpdateMsg(billDb, UpdateRuleCache.getUpdateRuleFromCache(data.getString(fruleIdx)), data.getString(fopIdx)));
                    reUpdateMsg.getBillIds().add(data.getLong(fbillIdIdx));
                    reUpdateMsg.getIds().add(data.getLong(fidIdx));
                    reUpdateMsgMap.put(ruleAndOp, reUpdateMsg);
                }
            }
        }
        for (ReUpdateMsg param : reUpdateMsgMap.values()) {
            try {
                BalManager.notifyAsyncInfoUpdateNow(param);
            }
            catch (Throwable e) {
                BalLogUtil.saveError("BalManager", String.valueOf(param), "notifyAsyncInfo", e);
            }
        }
    }

    private static void notifyAsyncInfoUpdateNow(ReUpdateMsg reUpdateMsg) {
        BalLogUtil.info("BalManager.notifyAsyncInfoUpdateNow start", new Object[0]);
        try (TXHandle tx = TX.requiresNew((String)"notifyAsyncInfoUpdateNow");){
            try {
                BalReUpdateParam updateParam = new BalReUpdateParam(reUpdateMsg.getBillIds(), null, false);
                updateParam.addReUpdateRules(reUpdateMsg.rule);
                updateParam.setOp(reUpdateMsg.op);
                BalManager.doReUpdate(updateParam);
                BalManager.checkMsgExists(reUpdateMsg, tx);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
        BalManager.clearUpdateInfo(reUpdateMsg);
    }

    public static void checkMsgExists(ReUpdateMsg param, TXHandle tx) {
        Set<Object> ids = param.getIds();
        String sql = "SELECT FID FROM " + param.rule.getBalanceTB().getOrCreateAsyncInfoTb(param.occDb) + " WHERE FID " + QFUtil.getIdsFilter(ids);
        HashSet<Object> errorIds = new HashSet<Object>(ids);
        try (DataSet dataSet = DB.queryDataSet((String)"checkMsgExists", (DBRoute)param.occDb, (String)sql);){
            int idx = dataSet.getRowMeta().getFieldIndex("FID");
            for (Row row : dataSet) {
                errorIds.remove(row.getLong(idx));
            }
        }
        if (errorIds.size() > 0) {
            tx.markRollback();
            String msg = ResManager.loadKDString((String)"\u8b66\u544a\u4fe1\u606f\uff1a\u5355\u636e\u5df2\u5728\u5176\u4ed6\u8bf7\u6c42\u5904\u7406\u5b8c\u6bd5\uff0c\u5f53\u524d\u8bf7\u6c42\u4e0d\u80fd\u91cd\u590d\u5904\u7406\uff0c\u5df2\u56de\u6eda\u3002", (String)"BalManager_1", (String)"bos-biz-balance", (Object[])new Object[0]);
            BalLogUtil.saveWarn("BalManager", "param=" + param + ", errorIds=" + errorIds, "checkMsgExist", msg);
            param.setMsgSuccess(false);
        } else {
            param.setMsgSuccess(true);
        }
    }

    public static void clearUpdateInfo(ReUpdateMsg param) {
        BalLogUtil.info("BalManager.clearUpdateInfo start: msgSuccess={},ids.size={}", param.isMsgSuccess(), param.getIds().size());
        if (param.getIds().size() == 0) {
            return;
        }
        if (param.isMsgSuccess()) {
            try (TXHandle tx = TX.requiresNew((String)"clearUpdateInfo");){
                String sql = "DELETE FROM " + param.rule.getBalanceTB().getOrCreateAsyncInfoTb(param.occDb) + " WHERE FID " + QFUtil.getIdsFilter(param.getIds());
                try {
                    DB.execute((DBRoute)param.occDb, (String)sql);
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    private static void addBizDBRecord(String balName, String appId, String dbKey, String type) {
        block16: {
            BalLogUtil.info("BalManager.addBizDBRecord start", new Object[0]);
            QFilter fs = new QFilter("db", "=", (Object)dbKey).and("bal", "=", (Object)balName).and("type", "=", (Object)type);
            if (!QueryServiceHelper.exists((String)"bal_occurred_dbs", (QFilter[])fs.toArray())) {
                try (TXHandle tx = TX.requiresNew((String)"ADD_BIZ_DB_RECORD");){
                    try {
                        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"bal_occurred_dbs");
                        record.set("bal", (Object)balName);
                        record.set("db", (Object)dbKey);
                        record.set("app", (Object)appId);
                        record.set("type", (Object)type);
                        record.set("creater", (Object)RequestContext.getOrCreate().getCurrUserId());
                        record.set("createtime", (Object)new Date());
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
                    }
                    catch (Throwable e) {
                        tx.markRollback();
                        if (BalLogUtil.isUniqueError(e)) {
                            BalLogUtil.saveError("BalManager", String.format("dbKey=%s", dbKey), "addBizDBRecord", e);
                            break block16;
                        }
                        throw e;
                    }
                }
            }
        }
    }

    private static void tryAddBizDBRecord(BalanceTB bal, String appId, String dbKey, String type) {
        String cacheKey = appId + type;
        if (bal.getOccAppCache().putIfAbsent(cacheKey, cacheKey) == null) {
            BalManager.addBizDBRecord(bal.getName(), appId, dbKey, type);
        }
    }

    public static List<UpdateRule> loadUpdateRule(String balanceTB) {
        BalanceTB bal = BalanceTB.getBalanceTB(balanceTB);
        List<Object> matchRules = new ArrayList();
        if (bal.isEnable()) {
            matchRules = UpdateRuleCache.getUpdateRuleByBal(balanceTB, null);
        }
        return Collections.unmodifiableList(matchRules);
    }

    private static List<UpdateRule> loadUpdateRule(String srcBillNumber, final String op) {
        List<UpdateRule> rules = UpdateRuleCache.getUpdateRuleByBill(srcBillNumber, new IRuleFilter(){

            @Override
            public boolean filter(UpdateRule rule) {
                return rule.isEnable() && rule.isMatchUpdate(op) && rule.getBalanceTB().isEnable();
            }
        });
        BalLogUtil.info("BalManager.loadUpdateRule size = " + rules.size(), new Object[0]);
        return rules;
    }

    static void publishTx(UpdateCtx ctx) {
        if (ctx != null) {
            MainEntityType billType = ctx.getBillType();
            String dbKey = billType.getDBRouteKey();
            String appId = billType.getAppId();
            ArrayList<NotifyMsg> notifyMsgs = new ArrayList<NotifyMsg>(4);
            for (String bal : ctx.getPartAsyncBals()) {
                notifyMsgs.add(new NotifyMsg(dbKey, appId, bal, true));
            }
            for (String bal : ctx.getAllAsyncBals()) {
                notifyMsgs.add(new NotifyMsg(dbKey, appId, bal, false));
            }
            BalManager.notifyMQConsumer(notifyMsgs);
        }
    }

    public static void notifyMQConsumer(Collection<NotifyMsg> notifyMsgs) {
        if (notifyMsgs != null) {
            BalManager.notifyMQConsumer(notifyMsgs.toArray(new NotifyMsg[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyMQConsumer(NotifyMsg ... notifyMsgs) {
        if (notifyMsgs == null || notifyMsgs.length == 0) {
            return;
        }
        boolean useMQ = BalConfig.isServiceByMQ();
        BalLogUtil.info("BalManager.notifyMQConsumer start: " + Arrays.toString(notifyMsgs) + ",useMQ: " + useMQ, new Object[0]);
        if (useMQ) {
            try (MessagePublisher pub = null;){
                pub = MQFactory.get().createPartitionPublisher("bal_queue", "bal.tx_notify", PartitionStrategy.APP_ID);
                for (NotifyMsg info : notifyMsgs) {
                    pub.publish((Object)JSON.toJSONString((Object)info), info.getAppId());
                }
            }
        } else {
            for (NotifyMsg info : notifyMsgs) {
                BalServiceHelper.invokeBalService(info.getAppId(), "mockNotifyMsg", JSON.toJSONString((Object)info));
            }
        }
        BalLogUtil.info("BalManager.notifyMQConsumer end", new Object[0]);
    }

    public static boolean pollingAllTxs() {
        BalLogUtil.info("BalManager.pollingAllTxs start", new Object[0]);
        try (DLock lock = DLock.create((String)"bal_pollingAllTxs");){
            boolean canDo = lock.tryLock();
            if (canDo) {
                BalEngineUtil.pollingAllTxs();
            }
            boolean bl = canDo;
            return bl;
        }
    }

    private static /* synthetic */ String lambda$tryWaitUpdate$1(DBRoute billDB, UpdateRule rule) {
        return rule.getBalanceTB().getOrCreateAsyncInfoTb(billDB);
    }
}

