/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bal.business.core.BalEngineUtil;
import kd.bos.bal.business.core.SpDataHandle;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.bal.common.QFUtil;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;

class SpDataHandle4Async
extends SpDataHandle {
    private final boolean isValid;
    private final DBRoute billDB;
    private final boolean isBalAndBillSameDb;
    private int tpRecordCount;

    SpDataHandle4Async(DBRoute billDB, BalanceTB bal, TreeSet<Long> txIds, boolean isValid) {
        super(bal, txIds);
        this.isValid = isValid;
        this.billDB = billDB;
        this.isBalAndBillSameDb = bal.getDbRoute().getRouteKey().equals(billDB.getRouteKey());
    }

    @Override
    protected void handleIDInfos(SpDataHandle.IDInfos idInfos, Row row) {
        this.parseIdsMove(idInfos, row);
        this.parseIdsDel(idInfos, row);
    }

    @Override
    protected void batchMoveSpData(SpDataHandle.IDInfos idInfos) {
        if (this.isValid) {
            this.deleteOrUpdateOldSpData(idInfos.idsDel);
            this.moveNewSpData(idInfos.idsMove);
        }
        List<Long> allIds = idInfos.getAllIds();
        this.tpRecordCount += allIds.size();
        this.clearSnapshotByIds(allIds);
    }

    public void moveAndUpdate() {
        if (!this.isValid) {
            this.clearTempSpDataByTxs();
        }
        try (DataSet datas = this.getKeyColByTxs();){
            int idx = datas.getRowMeta().getFieldIndex("fkeycol");
            ArrayList<String> keycols = new ArrayList<String>(100);
            for (Row row : datas) {
                keycols.add(row.getString(idx));
                if (keycols.size() <= this.moveKeycolBatch) continue;
                this.handleTxs(keycols);
                keycols.clear();
            }
            if (!keycols.isEmpty()) {
                this.handleTxs(keycols);
            }
        }
        if (!this.hasError) {
            String txIdFs = this.getTxFs();
            BalEngineUtil.clearUpdating(txIdFs);
            if (this.isValid) {
                BalEngineUtil.clearBizTxs(this.bal, this.billDB, txIdFs);
            }
        }
    }

    private void handleTxs(List<String> keycols) {
        if (this.isValid) {
            this.tpRecordCount = 0;
            this.handleSpData4Valid(keycols);
            if (this.tpRecordCount >= this.moveMaxQueryBatch) {
                this.hasError = true;
                BalLogUtil.warn("handleSpData4Valid : tpRecordCount = " + this.tpRecordCount + ",moveMaxQueryBatch = " + this.moveMaxQueryBatch + ", keys=" + keycols, new Object[0]);
            }
        } else {
            this.handleSpData4UnValid(keycols);
        }
    }

    private DataSet getKeyColByTxs() {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT DISTINCT ").append("fkeycol").append(" FROM ").append(this.bal.getTmpSnapshotTb());
        sql.append(" WHERE ").append("fupdatetime").append(this.getTxFs());
        return DB.queryDataSet((String)"getKeyColByTxs", (DBRoute)this.bal.getDbRoute(), (String)sql.toString()).orderBy(new String[]{"fkeycol ASC "});
    }

    @Override
    protected void batchExecuteUpdate(List<String> updateSqls, Map<String, List<Object[]>> paramGroups, SpDataHandle.IDInfos idInfos, Set<String> keycolHints) {
        try (TXHandle tx = TX.requiresNew((String)"SpDataHandle4Async.batchExecuteUpdate");){
            try {
                super.batchExecuteUpdate(updateSqls, paramGroups, idInfos, keycolHints);
            }
            catch (Throwable e) {
                this.hasError = true;
                tx.markRollback();
                BalLogUtil.saveError("SpDataHandle4Async", null, "batchExecuteUpdate", e);
            }
        }
    }

    private void handleSpData4Valid(List<String> keycols) {
        List<Object[]> params = this.buildTxParams(keycols);
        try (TXHandle lockTx = TX.requiresNew((String)"handleSpData4Valid").setRollback(true);){
            this.applyTxLock(params);
            try (DataSet datas = this.getAllSpDataByKeycol(keycols, false);){
                this.batchUpdateBal(datas, false);
            }
            this.justMoveSpData(keycols);
        }
    }

    private void justMoveSpData(List<String> keycols) {
        ArrayList<String> colExprs = new ArrayList<String>(2);
        colExprs.add(this.buildColExpr("fid", "id"));
        colExprs.add(this.buildColExpr("fmovetype", "movetype"));
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ").append(String.join((CharSequence)",", colExprs)).append(" FROM ").append(this.bal.getTmpSnapshotTb());
        sql.append(" WHERE ").append((CharSequence)this.buildWhere(keycols, true));
        try (DataSet spData = DB.queryDataSet((String)"justMoveSpData", (DBRoute)this.bal.getDbRoute(), (String)sql.toString());){
            int idIdx = spData.getRowMeta().getFieldIndex("id");
            int typeIdx = spData.getRowMeta().getFieldIndex("movetype");
            SpDataHandle.IDInfos idInfos = new SpDataHandle.IDInfos();
            int count = 0;
            for (Row row : spData) {
                String type = row.getString(typeIdx);
                if ("1".equals(type)) {
                    idInfos.idsMove.add(row.getLong(idIdx));
                } else {
                    idInfos.idsDel.add(row.getLong(idIdx));
                }
                if (++count < this.moveTpDataBatch) continue;
                this.justMoveSpData(idInfos);
                count = 0;
            }
            this.justMoveSpData(idInfos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void justMoveSpData(SpDataHandle.IDInfos idInfos) {
        try (TXHandle tx = TX.requiresNew((String)"MoveSnapshotTask.handelSpData");){
            try {
                this.deleteOrUpdateOldSpData(idInfos.idsDel);
                this.moveNewSpData(idInfos.idsMove);
                this.clearSnapshotByIds(idInfos.getAllIds());
                idInfos.clear();
            }
            catch (Throwable e) {
                try {
                    this.hasError = true;
                    tx.markRollback();
                    BalLogUtil.saveError("SpDataHandle4Async", null, "justMoveSpData", e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    idInfos.clear();
                }
            }
        }
    }

    private void handleSpData4UnValid(List<String> keycols) {
        List<Object[]> params = this.buildTxParams(keycols);
        try (TXHandle lockTx = TX.requiresNew((String)"MoveSnapshotTask.applyTxLock").setRollback(true);){
            this.applyTxLock(params);
            try (DataSet datas = this.getAllSpDataByKeycol(keycols, true);){
                this.batchUpdateBal(datas, true);
            }
        }
    }

    private void clearTempSpDataByTxs() {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ").append(this.bal.getTmpSnapshotTb());
        sql.append(" WHERE ").append("fupdatetime").append(this.getTxFs());
        sql.append(" AND ").append("fsync").append("='").append("0").append("' ");
        try (TXHandle lockTx = TX.requiresNew((String)"MoveSnapshotTask.applyTxLock");){
            DB.execute((DBRoute)this.bal.getDbRoute(), (String)sql.toString());
        }
    }

    private StringBuilder buildWhere(List<String> keycols, boolean isSyncSpData) {
        StringBuilder where = new StringBuilder();
        where.append("fkeycol").append(QFUtil.getIdsFilter(keycols, true));
        where.append(" AND ").append("fsync").append("='").append(isSyncSpData ? "1" : "0").append("' ");
        if (this.isValid && this.isBalAndBillSameDb) {
            where.append(" AND ").append("fupdatetime").append(" IN (SELECT FTXID FROM ").append(this.bal.getOrCreateTxTb(this.bal.getDbRoute())).append(") ");
        } else {
            where.append(" AND ").append("fupdatetime").append(this.getTxFs());
        }
        return where;
    }

    private DataSet getAllSpDataByKeycol(List<String> keycols, boolean isSyncSpData) {
        StringBuilder where = this.buildWhere(keycols, isSyncSpData);
        return this.queryTempSpData(where, this.isValid ? this.moveMaxQueryBatch : -1);
    }

    private List<Object[]> buildTxParams(List<String> keycols) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(this.txIds.size());
        for (String keycol : keycols) {
            params.add(new Object[]{keycol});
        }
        return params;
    }
}

