/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.sparse;

import java.io.Serializable;
import java.util.Locale;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.MetadataServiceHelper;

public class SparseSeqParam
implements Serializable {
    private static final long serialVersionUID = 8014293469570073888L;
    private String entity;
    private String entityTb;
    private String actualtb;
    private DBRoute dbRoute;
    private String sparseCol;
    private int sparseSize;

    public SparseSeqParam(String entity, String actualtb) {
        this.entity = entity;
        MainEntityType meta = MetadataServiceHelper.getDataEntityType((String)entity);
        this.sparseCol = meta.getPrimaryKey().getAlias();
        this.dbRoute = DBRoute.of((String)meta.getDBRouteKey());
        this.entityTb = meta.getAlias();
        this.actualtb = actualtb;
        this.toLowerCase();
    }

    private void toLowerCase() {
        if (this.entity != null) {
            this.entity = this.entity.toLowerCase(Locale.ENGLISH);
        }
        if (this.sparseCol != null) {
            this.sparseCol = this.sparseCol.toLowerCase(Locale.ENGLISH);
        }
        if (this.entityTb != null) {
            this.entityTb = this.entityTb.toLowerCase(Locale.ENGLISH);
        }
        if (this.actualtb != null) {
            this.actualtb = this.actualtb.toLowerCase(Locale.ENGLISH);
        }
    }

    public SparseSeqParam(DBRoute dbRoute, String entityTb, String actualtb, String idCol) {
        this.dbRoute = dbRoute;
        this.entityTb = entityTb;
        this.actualtb = actualtb;
        this.sparseCol = idCol;
        this.toLowerCase();
    }

    public String getEntity() {
        return this.entity;
    }

    public String getEntityTb() {
        return this.entityTb;
    }

    public String getActualtb() {
        return this.actualtb;
    }

    public DBRoute getDBRoute() {
        return this.dbRoute;
    }

    public int getSparseSize() {
        return this.sparseSize;
    }

    public String getSparseCol() {
        return this.sparseCol;
    }

    public void setSparseSize(int sparseSize) {
        this.sparseSize = (sparseSize = sparseSize / 1000 * 1000) > 100000 || sparseSize < 1000 ? 10000 : sparseSize;
    }
}

