/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.formplugin.updaterule;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.metadata.balance.BalanceUpdateRuleElement;
import kd.bos.metadata.balance.BalanceUpdateRuleMetadata;
import kd.bos.metadata.balance.policy.BalanceCondition;
import kd.bos.metadata.balance.policy.BalanceDataFilterPolicy;
import kd.bos.metadata.balance.policy.BalanceFieldMapItem;
import kd.bos.metadata.balance.policy.BalanceFieldMapPolicy;
import kd.bos.metadata.balance.policy.BalanceFormula;
import kd.bos.metadata.balance.policy.BalanceLogicConf;
import kd.bos.metadata.balance.policy.BalanceSortCol;
import org.apache.commons.lang3.StringUtils;

class RulePackager {
    RulePackager() {
    }

    public static void packageRule(BalanceUpdateRuleMetadata ruleMeta, DynamicObject data) {
        RulePackager.packageBaseInfo(ruleMeta, data);
        RulePackager.packageEntrys(ruleMeta, data);
    }

    private static void packageBaseInfo(BalanceUpdateRuleMetadata ruleMeta, DynamicObject data) {
        BalanceUpdateRuleElement rule = ruleMeta.getRuleElement();
        DynamicObject parentRule = data.getDynamicObject("masterid");
        if (parentRule != null) {
            ruleMeta.setMasterId(parentRule.getString("id"));
        }
        ruleMeta.setDevType(data.getString("devtype"));
        ruleMeta.setIsv(data.getString("isv"));
        String id = data.getString("id");
        if (StringUtils.isBlank((CharSequence)id)) {
            id = String.valueOf(DB.genGlobalLongId());
        }
        ruleMeta.setId(id);
        rule.setId(id);
        String number = data.getString("number");
        ruleMeta.setNumber(number);
        rule.setNumber(number);
        ILocaleString name = data.getLocaleString("name");
        for (Map.Entry nameItem : name.entrySet()) {
            rule.getName().put((String)nameItem.getKey(), nameItem.getValue());
        }
        rule.setBalanceTableNumber(data.getDynamicObject("bal").getString("id"));
        rule.setSourceEntityNumber(data.getDynamicObject("bill").getString("id"));
        rule.setUpdate(data.getString("update"));
        rule.setRollback(data.getString("rollback"));
        rule.setUpdateType(data.getString("updatetype"));
        rule.setPeriodFilterType(data.getString("periodpolicy"));
        rule.setSrcMainField(data.getString("billmaincol"));
        rule.setBizDateField(data.getString("bizdatefield"));
        rule.setPeriodField(data.getString("periodfield"));
        rule.setMonthField(data.getString("monthfield"));
        rule.setYearField(data.getString("yearfield"));
        rule.setPeriodQtyType(data.getString("periodqtytype"));
        rule.setReadableType(data.getString("readabletype"));
        String fsJson = data.getString("datafilterformula_tag");
        if (StringUtils.isNotBlank((CharSequence)fsJson)) {
            BalanceCondition bc = (BalanceCondition)SerializationUtils.fromJsonString((String)fsJson, BalanceCondition.class);
            BalanceDataFilterPolicy policy = rule.getDfPolicy();
            policy.setBalanceCondition(bc);
        }
        rule.setCustStatus(data.getBoolean("enable") ? "1" : "2");
    }

    private static void packageEntrys(BalanceUpdateRuleMetadata ruleMeta, DynamicObject data) {
        String balCol;
        BalanceUpdateRuleElement rule = ruleMeta.getRuleElement();
        BalanceFieldMapPolicy policy = rule.getFieldMapPolicy();
        List items = policy.getBalanceFieldMapItems();
        items.clear();
        DynamicObjectCollection rows = data.getDynamicObjectCollection("dimentry");
        BalanceFieldMapItem item = null;
        boolean partMatch = false;
        for (DynamicObject row : rows) {
            String expr;
            item = new BalanceFieldMapItem();
            balCol = row.getString("dimbalcol");
            if (StringUtils.isBlank((CharSequence)balCol)) continue;
            item.setTargetField(balCol);
            item.setSourceField(row.getString("dimbillcol"));
            item.setValType(row.getString("dimvaltype"));
            if ("5".equals(item.getValType())) {
                partMatch = true;
            }
            if (StringUtils.isNotBlank((CharSequence)(expr = row.getString("dimexprformula_tag")))) {
                BalanceFormula formula = (BalanceFormula)SerializationUtils.fromJsonString((String)expr, BalanceFormula.class);
                item.setExpr(formula);
            }
            items.add(item);
        }
        rows = data.getDynamicObjectCollection("occentry");
        for (DynamicObject row : rows) {
            item = new BalanceFieldMapItem();
            balCol = row.getString("occbalcol");
            if (StringUtils.isBlank((CharSequence)balCol)) continue;
            item.setTargetField(balCol);
            item.setSourceField(row.getString("occbillcol"));
            item.setValType(row.getString("occvaltype"));
            String formulaJson = row.getString("occavbqtyformula");
            if (StringUtils.isNotBlank((CharSequence)formulaJson)) {
                BalanceFormula sortformula = (BalanceFormula)SerializationUtils.fromJsonString((String)formulaJson, BalanceFormula.class);
                item.setOccAvbQtyFormula(sortformula);
            }
            items.add(item);
        }
        if (partMatch) {
            List sortCols = rule.getSortEntryRows();
            sortCols.clear();
            BalanceSortCol sortCol = null;
            rows = data.getDynamicObjectCollection("sortentry");
            for (DynamicObject row : rows) {
                sortCol = new BalanceSortCol();
                sortCol.setCol(row.getString("sortcol"));
                sortCol.setSortType(row.getString("sorttype"));
                sortCols.add(sortCol);
            }
        }
        List logicConfs = rule.getLogicConfs();
        logicConfs.clear();
        rows = data.getDynamicObjectCollection("logicentry");
        BalanceLogicConf conf = null;
        for (DynamicObject row : rows) {
            conf = new BalanceLogicConf();
            conf.setLogicCol(row.getDynamicObject("logiccol").getString("no"));
            conf.setLogicSrc(row.getString("logicsrc"));
            logicConfs.add(conf);
        }
    }
}

