/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.mservice;

import java.util.concurrent.RejectedExecutionException;
import kd.bos.bal.business.consumer.BalCheckTaskConsumer;
import kd.bos.bal.business.consumer.BalReCalConsumer;
import kd.bos.bal.business.consumer.BalTxNotifyConsumer;
import kd.bos.bal.business.consumer.BalTxUpdateConsumer;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.bal.common.BalPoolUtil;
import kd.bos.bal.common.TaskMsg;
import kd.bos.bal.servicehelper.BalServiceHelper;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.instance.Instance;
import kd.bos.threads.DynamicExecutorService;
import kd.bos.trace.util.TraceIdUtil;
import org.apache.commons.lang3.StringUtils;

public class BalUpdateService {
    public BalUpdateService() {
        BalLogUtil.info("BalUpdateService init", new Object[0]);
    }

    public String mockTest(String appId) {
        BalLogUtil.info("BalUpdateService.mockTest start", new Object[0]);
        String currentMsg = ResManager.loadKDString((String)"\u670d\u52a1\u8282\u70b9{0}\uff0c\u8fd0\u884c\u6210\u529f", (String)"BalUpdateService_0", (String)"bos-biz-balance", (Object[])new Object[]{Instance.getInstanceId()});
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            String nextMsg = "";
            try {
                nextMsg = (String)BalServiceHelper.invokeBalServiceByRpc(appId, "mockTest", "");
            }
            catch (Exception ex) {
                String traceId = TraceIdUtil.getCurrentTraceIdString();
                nextMsg = ResManager.loadKDString((String)"\u4e0b\u4e00\u670d\u52a1\u8282\u70b9\u8c03\u7528\u6709\u5f02\u5e38\uff0c\u67e5\u770bTraceId = {0}", (String)"BalUpdateService_1", (String)"bos-biz-balance", (Object[])new Object[]{traceId});
                BalLogUtil.error("BalUpdateService.mockTest error ", ex);
            }
            return ResManager.loadKDString((String)"\u68c0\u6d4b\u7ed3\u675f\uff1a{0}\uff0c{1}\u3002", (String)"BalUpdateService_2", (String)"bos-biz-balance", (Object[])new Object[]{currentMsg, nextMsg});
        }
        return currentMsg;
    }

    public String mockReUpdateMsg(String bal, String msg) {
        String taskType = "ReCal_" + bal;
        return this.mockMsg(taskType, 6, 64, new BalReCalConsumer(msg));
    }

    public void mockNotifyMsg(String msg) {
        new BalTxNotifyConsumer().mockMsg(msg);
    }

    public String mockTxMsg(String bal, String msg) {
        String taskType = "Tx_" + bal;
        return this.mockMsg(taskType, 6, 128, new BalTxUpdateConsumer(msg));
    }

    public String mockCheckTaskMsg(TaskMsg taskMsg) {
        try {
            DynamicExecutorService exec = BalPoolUtil.getCheckExecutor();
            boolean success = this.doExecutor(exec, new BalCheckTaskConsumer(taskMsg));
            return success ? "1" : "2";
        }
        catch (Throwable e) {
            BalLogUtil.saveError("BalUpdateService", taskMsg.toString(), "mockCheckTaskMsg", e);
            return "3";
        }
    }

    private String mockMsg(String taskType, int taskLimit, int queueSize, Runnable task) {
        try {
            DynamicExecutorService exec = BalPoolUtil.getUpdateExecutor();
            boolean success = this.doExecutor(exec, task);
            if (!success) {
                exec = BalPoolUtil.getUpdateExecutor(taskType, taskLimit, taskLimit, queueSize, true);
                success = this.doExecutor(exec, task);
            }
            return success ? "1" : "2";
        }
        catch (Throwable e) {
            BalLogUtil.saveError("BalUpdateService", "taskType=" + taskType, "mockMsg", e);
            return "3";
        }
    }

    private boolean doExecutor(DynamicExecutorService exec, Runnable task) {
        try {
            exec.execute(task);
            return true;
        }
        catch (RejectedExecutionException e) {
            return false;
        }
    }
}

