/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.opplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import org.apache.commons.lang3.StringUtils;

public class BalCheckRepairSettingSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SettingSaveValidator());
    }

    private static class SettingSaveValidator
    extends AbstractValidator {
        private SettingSaveValidator() {
        }

        public void validate() {
            ExtendedDataEntity[] dataExts;
            for (ExtendedDataEntity dataExt : dataExts = this.getDataEntities()) {
                this.checkData(dataExt);
            }
        }

        private void checkData(ExtendedDataEntity dataExt) {
            DynamicObject data = dataExt.getDataEntity();
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("ruleentry");
            String hasFilter = null;
            for (DynamicObject entry : entrys) {
                hasFilter = entry.getString("hasfilter");
                if (!"A".equals(hasFilter)) {
                    entry.set("billfs_tag", null);
                    continue;
                }
                if (!StringUtils.isBlank((CharSequence)entry.getString("billfs_tag"))) continue;
                String ruleNo = entry.getString("rule.number");
                this.addErrorMessage(dataExt, ResManager.loadKDString((String)"\u89c4\u5219{0}\uff0c\u9700\u8bbe\u7f6e\u91cd\u7b97\u6761\u4ef6\u3002", (String)"BalCheckRepairSettingSaveOp_0", (String)"bos-biz-balance", (Object[])new Object[]{ruleNo}));
                return;
            }
            if (StringUtils.isBlank((CharSequence)data.getString("no"))) {
                data.set("no", (Object)data.getString("bal.id"));
            }
        }
    }
}

