/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Future;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.bal.common.BalPoolUtil;
import kd.bos.bal.task.BalAutoRepairTask;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class BalAutoRepair
extends AbstractTask {
    private String getScheduleId() {
        TaskInfo info = ScheduleServiceHelper.queryTask((String)this.taskId);
        return info.getScheduleId();
    }

    public void execute(RequestContext ctx, Map<String, Object> param) throws KDException {
        String scheduleId = this.getScheduleId();
        if (scheduleId == null) {
            throw new KDException(new ErrorCode("BalAutoRepair error", "scheduleId is null"), new Object[0]);
        }
        try {
            QFilter fs = new QFilter("status", "=", (Object)"1").and("schedule", "=", (Object)scheduleId);
            DynamicObjectCollection datas = QueryServiceHelper.query((String)"bal_auto_repair", (String)"bal,checkitem", (QFilter[])fs.toArray());
            ArrayList<Future<String>> results = new ArrayList<Future<String>>(datas.size());
            for (DynamicObject data : datas) {
                results.add(BalPoolUtil.submitByOtherExecutor(new BalAutoRepairTask(data)));
            }
            ArrayList<String> msgs = new ArrayList<String>(results.size());
            for (Future future : results) {
                String msg = (String)future.get();
                if (msg == null) continue;
                msgs.add(msg);
            }
            if (msgs.size() > 0) {
                throw new KDBizException("BalAutoRepair error:" + String.join((CharSequence)",", msgs));
            }
        }
        catch (Throwable e) {
            throw new KDException(new ErrorCode("BalAutoRepair error", "execute error"), null, e);
        }
    }

    public static void clearInvalidTasks() {
        BalPoolUtil.executeByOtherExecutor(() -> {
            try {
                long limit = System.currentTimeMillis() - 1296000000L;
                QFilter fs = new QFilter("createdate", "<", (Object)new Date(limit));
                DeleteServiceHelper.delete((String)"bal_check_repair_task", (QFilter[])fs.toArray());
            }
            catch (Throwable e) {
                BalLogUtil.saveError("BalAutoRepair", null, "clearInvalidTasks", e);
            }
        });
    }
}

