/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bal.business.core.BalRepairManager;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.util.TraceIdUtil;

class BalAutoRepairTask
implements Callable<String> {
    private final String balName;
    private final Map<Long, Integer> retryCount;
    private final Set<String> checkItems;

    public BalAutoRepairTask(DynamicObject data) {
        this.balName = data.getString("bal");
        this.retryCount = new HashMap<Long, Integer>();
        String[] split = data.getString("checkitem").split(",");
        this.checkItems = new HashSet<String>(4);
        for (int i = 0; i < split.length; ++i) {
            this.checkItems.add(split[i]);
        }
    }

    @Override
    public String call() {
        try {
            String msg;
            ArrayList<String> msgs = new ArrayList<String>(4);
            if (this.checkItems.contains("B") && (msg = this.buildTask("H")) != null) {
                msgs.add(msg);
            }
            if (this.checkItems.contains("A") && (msg = this.buildTask("G")) != null) {
                msgs.add(msg);
            }
            if (this.checkItems.contains("C") && (msg = this.buildTask("I")) != null) {
                msgs.add(msg);
            }
            return msgs.isEmpty() ? null : String.join((CharSequence)",", msgs);
        }
        catch (Throwable e) {
            BalLogUtil.error("BalAutoRepairTask.call", e);
            return String.format("tractId=%s,msg=%s", TraceIdUtil.getCurrentTraceIdString(), BalLogUtil.parseMsg(e, 1000));
        }
    }

    private String buildTask(String taskType) {
        DynamicObject task = this.newTask(taskType);
        task = BusinessDataServiceHelper.loadSingle((Object)task.getPkValue(), (String)task.getDynamicObjectType().getName());
        BalRepairManager.buildCheckRepairTask((DynamicObject)task);
        return this.checkOver(task);
    }

    private String checkOver(DynamicObject task) {
        long limit = System.currentTimeMillis() + 0x6DDD00L;
        try {
            do {
                Thread.sleep(300000L);
                if (System.currentTimeMillis() <= limit) continue;
                return "Task TimeOut 2H";
            } while (!this.isTaskOver(task));
            return null;
        }
        catch (InterruptedException e) {
            return "Task Interrupted";
        }
    }

    private boolean isTaskOver(DynamicObject task) {
        QFilter fs = new QFilter("parenttask", "=", (Object)task.getLong("id"));
        fs.and("status", "!=", (Object)"F");
        int batch = 100;
        boolean hasData = false;
        try (DataSet data = QueryServiceHelper.queryDataSet((String)"isTaskOver", (String)"bal_check_repair_task", (String)"id,status,runstatus", (QFilter[])fs.toArray(), null);){
            ArrayList<Object> goonTaskIds = new ArrayList<Object>(batch);
            ArrayList<Object> reTryTaskIds = new ArrayList<Object>(batch);
            for (Row row : data) {
                Long id = row.getLong("id");
                hasData = true;
                String status = row.getString("status");
                String runStatus = row.getString("runstatus");
                if ("A".equals(status) || "B".equals(status) && !"1".equals(runStatus)) {
                    reTryTaskIds.add(id);
                    if (reTryTaskIds.size() < batch) continue;
                    this.batchHandle(reTryTaskIds, "retry");
                    continue;
                }
                if (!"E".equals(status) || "1".equals(runStatus) || !this.needReTry(id)) continue;
                goonTaskIds.add(id);
                if (goonTaskIds.size() < batch) continue;
                this.batchHandle(goonTaskIds, "goon");
            }
            if (goonTaskIds.size() > 0) {
                this.batchHandle(goonTaskIds, "goon");
            }
            if (reTryTaskIds.size() > 0) {
                this.batchHandle(goonTaskIds, "retry");
            }
        }
        return !hasData;
    }

    private boolean needReTry(Long id) {
        Integer val = this.retryCount.get(id);
        int count = val == null ? 1 : val + 1;
        this.retryCount.put(id, count);
        return count <= 2;
    }

    private void batchHandle(List<Object> subTaskIds, String opName) {
        OperationServiceHelper.executeOperate((String)opName, (String)"bal_check_repair_task", (Object[])subTaskIds.toArray(), null);
    }

    private DynamicObject newTask(String tasktype) {
        DynamicObject task = BusinessDataServiceHelper.newDynamicObject((String)"bal_check_repair");
        task.set("id", (Object)DB.genGlobalLongId());
        task.set("taskno", (Object)("Auto_" + ID.longTo36Radix((long)DB.genGlobalLongId())));
        task.set("tasktype", (Object)tasktype);
        task.set("oprange", (Object)"A");
        task.set("reason", (Object)"BalAutoRepairTask");
        task.set("bal", (Object)this.balName);
        task.set("opresult", (Object)"A");
        task.set("creater", (Object)1);
        task.set("createdate", (Object)new Date());
        try (TXHandle tx = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
        return task;
    }
}

