/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.biz.balance.rule;

import java.util.HashSet;
import kd.bos.bal.business.core.BalManager;
import kd.bos.bal.business.core.WaitType;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.biz.balance.model.BalUpdateParam;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import org.apache.commons.lang3.StringUtils;

public class BalanceUpdateAction
extends AbstractOpBizRuleAction {
    public BalanceUpdateAction() {
        BalLogUtil.info("BalanceUpdateAction create", new Object[0]);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        BalLogUtil.info("BalanceUpdateAction start", new Object[0]);
        DynamicObject[] datas = e.getDataEntities();
        HashSet<Object> ids = new HashSet<Object>(datas.length);
        for (DynamicObject data : datas) {
            ids.add(data.getPkValue());
        }
        BalUpdateParam param = new BalUpdateParam(e.getOperationKey(), datas[0].getDataEntityType().getName(), ids);
        this.setCtxOtherInfo(param);
        BalManager.doUpdate(param);
        BalLogUtil.info("BalanceUpdateAction end", new Object[0]);
    }

    private void setCtxOtherInfo(BalUpdateParam param) {
        OperateOption option = this.getOption();
        if (option != null) {
            String opAlis = option.getVariableValue("balance_update_op_alias", null);
            param.setOpAlias(opAlis);
            this.buildWaitType(param, option);
        }
    }

    private void buildWaitType(BalUpdateParam param, OperateOption option) {
        try {
            String timeOutStr = option.getVariableValue("bal_waittype_timeout", null);
            String intervalStr = option.getVariableValue("bal_waittype_interval", null);
            boolean hasTimeOut = StringUtils.isNotBlank((CharSequence)timeOutStr);
            boolean hasInterval = StringUtils.isNotBlank((CharSequence)intervalStr);
            if (!hasTimeOut && !hasInterval) {
                return;
            }
            int timeOut = hasTimeOut ? Integer.parseInt(timeOutStr) : 300000;
            int interval = hasInterval ? Integer.parseInt(intervalStr) : 1000;
            param.setWaitType(new WaitType(timeOut, interval));
        }
        catch (Exception e) {
            BalLogUtil.error("buildWaitType error:", e);
        }
    }
}

