/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.balance;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.metadata.balance.BalanceUpdateRuleElement;
import kd.bos.metadata.balance.BalanceUpdateRuleReader;
import kd.bos.metadata.balance.BalanceUpdateRuleWriter;
import kd.bos.metadata.balance.RuleDeleteChecker;
import kd.bos.metadata.balance.RuleEnabledChecker;

public class BalanceUpdateRuleOpPlugin
extends AbstractOperationServicePlugIn {
    private static final String KEY_FID = "fid";
    private static final String KEY_DEVTYPE = "devtype";
    private static final String KEY_MASTERID = "masterid";
    private static final String KEY_BIZAPP = "bizappid";
    private static final String KEY_SOURCEENTITYNUMBER = "sourceentitynumber";
    private static final String TABLE_CUSTSTATUS = "T_BAL_UpdateRuleDesign_S";
    private static final String ENABLE_STR = "enable";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add(KEY_FID);
        e.getFieldKeys().add(KEY_DEVTYPE);
        e.getFieldKeys().add(KEY_MASTERID);
        e.getFieldKeys().add(KEY_BIZAPP);
        e.getFieldKeys().add(KEY_SOURCEENTITYNUMBER);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        String opType = (String)this.operateMeta.get("type");
        if (StringUtils.equalsIgnoreCase((CharSequence)ENABLE_STR, (CharSequence)opType)) {
            e.addValidator((AbstractValidator)new RuleEnabledChecker());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"delete", (CharSequence)opType)) {
            e.addValidator((AbstractValidator)new RuleDeleteChecker());
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        HashSet<String> entryNames = new HashSet<String>(16);
        ArrayList<String> ruleIds = new ArrayList<String>(16);
        for (DynamicObject obj : e.getDataEntities()) {
            ruleIds.add((String)obj.getPkValue());
            if (obj.getDynamicObject(KEY_SOURCEENTITYNUMBER) == null) continue;
            entryNames.add(obj.getDynamicObject(KEY_SOURCEENTITYNUMBER).getString("id"));
        }
        String opType = (String)this.operateMeta.get("type");
        if (StringUtils.equalsIgnoreCase((CharSequence)ENABLE_STR, (CharSequence)opType)) {
            this.updateCustStatus(ruleIds, "1");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"disable", (CharSequence)opType)) {
            this.updateCustStatus(ruleIds, "2");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"delete", (CharSequence)opType)) {
            BalanceUpdateRuleWriter.delete(ruleIds.toArray(new String[ruleIds.size()]));
            this.updateRuleBizOp(entryNames);
            this.deleteCustStatus(ruleIds);
        }
    }

    private void updateRuleBizOp(Set<String> entryNames) {
        List<BalanceUpdateRuleElement> rules = null;
        for (String entryName : entryNames) {
            rules = BalanceUpdateRuleReader.loadRulesBySrcBill(entryName);
            BalanceUpdateRuleWriter.updateRuleBizOp(entryName, rules);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        if (StringUtils.equals((CharSequence)ENABLE_STR, (CharSequence)((String)this.operateMeta.get("type"))) || StringUtils.equals((CharSequence)"disable", (CharSequence)((String)this.operateMeta.get("type")))) {
            HashSet<String> masterIds = new HashSet<String>();
            for (DynamicObject dataEntity : e.getDataEntities()) {
                String ruleId = (String)dataEntity.getPkValue();
                String devType = dataEntity.getString(KEY_DEVTYPE);
                DynamicObject masterObj = dataEntity.getDynamicObject(KEY_MASTERID);
                if (StringUtils.isNotBlank((CharSequence)devType) && devType.equals("2") && masterObj != null) {
                    masterIds.add((String)masterObj.getPkValue());
                    continue;
                }
                masterIds.add(ruleId);
            }
            for (String ruleId : masterIds) {
                BalanceUpdateRuleWriter.rebuildRuntimeMetaById(ruleId);
            }
        }
    }

    private void updateCustStatus(List<String> ruleIds, String status) {
        SqlParameter[] sqlParams;
        if (ruleIds.isEmpty()) {
            return;
        }
        String sqlExists = "select FID from T_BAL_UpdateRuleDesign_S where FId in (%s) ";
        ArrayList<String> list = new ArrayList<String>(10);
        Object[] params = new SqlParameter[ruleIds.size()];
        for (int i = 0; i < ruleIds.size(); ++i) {
            list.add("?");
            params[i] = new SqlParameter(":FId" + String.valueOf(i), 12, (Object)ruleIds.get(i));
        }
        sqlExists = String.format(sqlExists, StringUtils.join((Object[])list.toArray(), (String)","));
        ResultSetHandler<Set<String>> action = new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> idSet = new HashSet<String>(16);
                while (rs.next()) {
                    idSet.add(rs.getString(1));
                }
                return idSet;
            }
        };
        Set existsRuleIds = (Set)DB.query((DBRoute)DBRoute.meta, (String)sqlExists, (Object[])params, (ResultSetHandler)action);
        ArrayList<String> insertRuleIds = new ArrayList<String>();
        for (String ruleId : ruleIds) {
            if (existsRuleIds.contains(ruleId)) continue;
            insertRuleIds.add(ruleId);
        }
        if (!insertRuleIds.isEmpty()) {
            String strInsertSQL = "INSERT INTO T_BAL_UpdateRuleDesign_S (FID, FCustStatus) VALUES (?, ?) ";
            ArrayList<SqlParameter[]> insertParams = new ArrayList<SqlParameter[]>(10);
            for (String ruleId : insertRuleIds) {
                sqlParams = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)ruleId), new SqlParameter(":FCustStatus", 1, (Object)status)};
                insertParams.add(sqlParams);
            }
            DB.executeBatch((DBRoute)DBRoute.meta, (String)strInsertSQL, insertParams);
        }
        if (!existsRuleIds.isEmpty()) {
            String strUpdateSQL = "Update T_BAL_UpdateRuleDesign_S SET FCustStatus = ? WHERE FID = ? ";
            ArrayList<SqlParameter[]> updateParams = new ArrayList<SqlParameter[]>(existsRuleIds.size());
            for (String ruleId : existsRuleIds) {
                sqlParams = new SqlParameter[]{new SqlParameter(":FCustStatus", 1, (Object)status), new SqlParameter(":FId", 12, (Object)ruleId)};
                updateParams.add(sqlParams);
            }
            DB.executeBatch((DBRoute)DBRoute.meta, (String)strUpdateSQL, updateParams);
        }
    }

    private void deleteCustStatus(List<String> ruleIds) {
        if (ruleIds.isEmpty()) {
            return;
        }
        String sql = "DELETE FROM T_BAL_UpdateRuleDesign_S WHERE FID IN (%s)";
        ArrayList<String> list = new ArrayList<String>(10);
        Object[] params = new SqlParameter[ruleIds.size()];
        for (int i = 0; i < ruleIds.size(); ++i) {
            list.add("?");
            params[i] = new SqlParameter(":FId" + String.valueOf(i), 12, (Object)ruleIds.get(i));
        }
        sql = String.format(sql, StringUtils.join((Object[])list.toArray(), (String)","));
        DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])params);
    }
}

