/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.balance;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.OpBizRuleSetWriter;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.balance.BalanceRuleCacheUtils;
import kd.bos.metadata.balance.BalanceUpdateRuleElement;
import kd.bos.metadata.balance.BalanceUpdateRuleMetadata;
import kd.bos.metadata.balance.BalanceUpdateRuleReader;
import kd.bos.metadata.balance.DesignBalanceRuleMeta;
import kd.bos.metadata.balance.DesignBalanceRuleMetaL;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class BalanceUpdateRuleWriter {
    private static final String OPBIZRULE = "CallBalanceUpdate";

    public static Map<String, Object> save(BalanceUpdateRuleMetadata ruleMetadata) {
        BalanceUpdateRuleWriter.setBizappId(ruleMetadata);
        BalanceUpdateRuleWriter.updateVersion(ruleMetadata);
        MetadataWriter writer = new MetadataWriter("BalanceUpdateModel");
        Map result = writer.save(new AbstractMetadata[]{ruleMetadata});
        BalanceUpdateRuleWriter.updateRuleCache(ruleMetadata);
        return result;
    }

    private static void updateRuleCache(BalanceUpdateRuleMetadata ruleMetadata) {
        BalanceUpdateRuleElement ruleElement = ruleMetadata.getRuleElement();
        BalanceRuleCacheUtils.updateRuleVersion(ruleElement.getBalanceTableNumber());
        BalanceRuleCacheUtils.updateRuleVersion(ruleElement.getSourceEntityNumber());
    }

    private static void updateRuleCache(Set<String> balEntityNames) {
        for (String balEntityName : balEntityNames) {
            BalanceRuleCacheUtils.updateRuleVersion(balEntityName);
        }
    }

    public static Map<String, Object> delete(String[] ruleIds) {
        Object[] designRules;
        IDataEntityType designMetaType = OrmUtils.getDataEntityType(DesignBalanceRuleMeta.class);
        IDataEntityType designMetaType_Lang = OrmUtils.getDataEntityType(DesignBalanceRuleMetaL.class);
        MetadataWriter metadataWriter = new MetadataWriter("BalanceUpdateModel");
        HashSet<String> entityName = new HashSet<String>();
        for (Object designRule : designRules = BusinessDataReader.load((Object[])ruleIds, (IDataEntityType)designMetaType)) {
            DesignBalanceRuleMeta designMeta = (DesignBalanceRuleMeta)((Object)designRule);
            String number = designMeta.getNumber();
            String devType = designMeta.getDevType();
            String masterId = designMeta.getMasterId();
            metadataWriter.delete(designMeta.getId(), designMetaType, designMetaType_Lang);
            if (StringUtils.equals((CharSequence)"2", (CharSequence)devType)) {
                number = BalanceUpdateRuleReader.getNumberById(masterId);
                BalanceUpdateRuleWriter.rebuildRuntimeMetaByNumber(number);
                continue;
            }
            entityName.add(designMeta.getBalanceTableNumber());
            entityName.add(designMeta.getSourceEntityNumber());
        }
        BalanceUpdateRuleWriter.updateRuleCache(entityName);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("message", ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"BalanceUpdateRuleWriter_0", (String)"bos-bal-metadata", (Object[])new Object[0]));
        return result;
    }

    public static void rebuildRuntimeMetaByNumber(String number) {
        String id = BalanceUpdateRuleReader.getIdByNumber(number);
        if (id == null) {
            throw new KDException(BosErrorCode.metaNotFound, new Object[]{ResManager.loadKDString((String)"number\u4e3a{0}\u7684\u4f59\u989d\u66f4\u65b0\u89c4\u5219\u4e0d\u5b58\u5728\u3002", (String)"BalanceUpdateRuleWriter_1", (String)"bos-bal-metadata", (Object[])new Object[]{number})});
        }
        BalanceUpdateRuleWriter.delRuntimeMetaByNumber(number);
        BalanceUpdateRuleWriter.rebuildRuntimeMetaById(id);
    }

    public static void rebuildRuntimeMetaById(String id) {
        try (TraceSpan span = Tracer.create((String)"BalanceUpdateRuleWriter", (String)"rebuildRuntimeMetaById");){
            if (StringUtils.isEmpty((CharSequence)id)) {
                return;
            }
            try (DLock lock = DLock.createReentrant((String)("BalanceUpdateRuleWriter-" + id));){
                lock.lock();
                BalanceUpdateRuleReader reader = new BalanceUpdateRuleReader();
                BalanceUpdateRuleMetadata metadata = reader.loadMeta(id, true);
                if (metadata == null) {
                    throw new KDException(BosErrorCode.metaNotFound, new Object[]{ResManager.loadKDString((String)"id\u4e3a{0}\u7684\u4f59\u989d\u66f4\u65b0\u89c4\u5219\u4e0d\u5b58\u5728\u3002", (String)"BalanceUpdateRuleWriter_2", (String)"bos-bal-metadata", (Object[])new Object[]{id})});
                }
                BalanceUpdateRuleWriter.updateRuleCache(metadata);
                MetadataWriter metadataWriter = new MetadataWriter(metadata.getModelType());
                metadataWriter.rebuildRuntimeMeta(new AbstractMetadata[]{metadata});
            }
        }
    }

    private static void delRuntimeMetaByNumber(String number) {
        try (TraceSpan span = Tracer.create((String)"BalanceUpdateRuleWriter", (String)"delRuntimeMetaByNumber");
             TXHandle h = TX.required((String)"delRuntimeMetaByNumber");){
            String sql = "delete from t_bal_UpdateRule where fnumber=?";
            Object[] params = new SqlParameter[]{new SqlParameter(":FNumber", 12, (Object)number)};
            DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])params);
        }
    }

    private static void setBizappId(final BalanceUpdateRuleMetadata ruleMetadata) {
        if (StringUtils.isBlank((CharSequence)ruleMetadata.getBizappId())) {
            String sql = "SELECT FNumber, FSubsysId, FBizAppId FROM t_meta_entitydesign WHERE FNumber = ?";
            Object[] params = new SqlParameter[]{new SqlParameter(":FNumber", 12, (Object)ruleMetadata.getRuleElement().getSourceEntityNumber())};
            ResultSetHandler<Object> action = new ResultSetHandler<Object>(){

                public Object handle(ResultSet rs) throws Exception {
                    if (rs.next()) {
                        int subSysId = rs.getInt("FSubsysId");
                        String bizAppId = rs.getString("FBizAppId");
                        ruleMetadata.setSubSysId(subSysId);
                        ruleMetadata.setBizappId(bizAppId);
                    }
                    return null;
                }
            };
            DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
        }
    }

    private static void updateVersion(BalanceUpdateRuleMetadata ruleMetadata) {
        if (ruleMetadata.getDevType().equals("2")) {
            long extVersion = ruleMetadata.getRuleElement().getExtVersion() + 1L;
            ruleMetadata.getRuleElement().setExtVersion(extVersion);
        } else {
            long version = ruleMetadata.getRuleElement().getOriVersion() + 1L;
            ruleMetadata.getRuleElement().setOriVersion(version);
        }
    }

    public static void updateRuleBizOp(String entityNumber, List<BalanceUpdateRuleElement> rules) {
        String op = null;
        StringBuilder opKeyStr = new StringBuilder();
        for (BalanceUpdateRuleElement rule : rules) {
            op = rule.getUpdate();
            if (StringUtils.isNotBlank((CharSequence)op)) {
                opKeyStr.append(',').append(op);
            }
            if (!StringUtils.isNotBlank((CharSequence)(op = rule.getRollback()))) continue;
            opKeyStr.append(',').append(op);
        }
        String[] opArr = opKeyStr.toString().split(",");
        HashSet<String> opKeys = new HashSet<String>();
        for (String opKey : opArr) {
            if (!StringUtils.isNotBlank((CharSequence)opKey)) continue;
            opKeys.add(opKey);
        }
        if (!opKeys.isEmpty()) {
            OpBizRuleSetWriter.saveOpBizRuleSet((String)entityNumber, (String)OPBIZRULE, new ArrayList(opKeys));
        }
    }
}

