/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.balance;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.CheckMessage;
import kd.bos.entity.botp.CheckMessageType;
import kd.bos.entity.botp.CheckResult;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.metadata.balance.BalanceUpdateRuleMetadata;
import kd.bos.metadata.balance.BalanceUpdateRuleReader;

class RuleEnabledChecker
extends AbstractValidator {
    private boolean check = false;

    RuleEnabledChecker() {
    }

    public void initializeConfiguration() {
        super.initializeConfiguration();
        if (StringUtils.equalsIgnoreCase((CharSequence)"enable", (CharSequence)this.getOperateType())) {
            this.check = true;
        }
    }

    public void validate() {
        if (!this.check) {
            return;
        }
        BalanceUpdateRuleReader reader = new BalanceUpdateRuleReader();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String ruleId = (String)dataEntity.getDataEntity().getPkValue();
            BalanceUpdateRuleMetadata ruleMeta = reader.loadMeta(ruleId, true);
            CheckResult checkResult = new CheckResult();
            ruleMeta.getRuleElement().check(null, checkResult);
            if (checkResult.isPass()) continue;
            for (CheckMessage msg : checkResult.getMessages()) {
                if (msg.getMsgType() != CheckMessageType.Error) continue;
                this.addMessage(dataEntity, msg.getCheckPoint().getFullPoint(), msg.getMessage(), ErrorLevel.Error);
            }
        }
    }
}

