/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.balance.checker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.balance.BizDataType;
import kd.bos.exception.KDBizException;
import kd.bos.metadata.balance.BalanceEntity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.exception.ErrorInfo;
import org.apache.commons.lang3.StringUtils;

public class BalanceTbChecker {
    private EntityMetadata entityMeta;

    public BalanceTbChecker(EntityMetadata entityMeta) {
        if (entityMeta == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceTbChecker_0", (String)"bos-bal-metadata", (Object[])new Object[0]));
        }
        MainEntity rootEntity = entityMeta.getRootEntity();
        if (!(rootEntity instanceof BalanceEntity)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u8c61{0}\u4e0d\u662f\u4f59\u989d\u8868\u7c7b\u578b\u5143\u6570\u636e\u3002", (String)"BalanceTbChecker_1", (String)"bos-bal-metadata", (Object[])new Object[]{entityMeta.getId()}));
        }
        this.entityMeta = entityMeta;
    }

    public void checkMetadata() {
        BalanceEntity entity = (BalanceEntity)this.entityMeta.getRootEntity();
        if (entity.isTemplate()) {
            return;
        }
        String type = entity.getBalanceType();
        if ("period".equals(type)) {
            this.checkPeriodBalEntity();
        } else if ("realtime".equals(type)) {
            this.checkRealBalEntity();
        } else {
            this.addBuildError(null, ResManager.loadKDString((String)"\u4f59\u989d\u8868\u7c7b\u578b{0}\u4e0d\u5408\u6cd5\uff0c\u53ea\u80fd\u662f\u671f\u95f4\u4f59\u989d\u6216\u5373\u65f6\u4f59\u989d\u7c7b\u578b\u3002", (String)"BalanceTbChecker_2", (String)"bos-bal-metadata", (Object[])new Object[]{type}));
        }
    }

    private void addBuildError(String propertyName, String error) {
        ErrorInfo info = new ErrorInfo();
        info.setItemId(this.entityMeta.getId());
        info.setPropertyName(propertyName);
        info.setType("entity");
        info.setLevel(2);
        info.setError(error);
        this.entityMeta.addError(info);
    }

    private void checkBizDataType(Map<String, Field<?>> fields) {
        for (Field<?> entity : fields.values()) {
            String bizDataType = entity.getBizDataType();
            if (!StringUtils.isBlank((CharSequence)bizDataType)) continue;
            String fieldName = entity.getName().toString();
            this.addBuildError(fieldName, ResManager.loadKDString((String)"{0}\u5b57\u6bb5\u7684\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceTbChecker_3", (String)"bos-bal-metadata", (Object[])new Object[]{fieldName}));
        }
    }

    private void checkRealBalEntity() {
        Map<String, Field<?>> fields = this.getFieldMap();
        this.checkKeyCol(fields);
        this.checkMTCol(fields);
        this.checkBizDataType(fields);
        for (Field<?> qtyCol : fields.values()) {
            if (!BizDataType.OCC.getNumber().equals(qtyCol.getBizDataType())) continue;
            this.checkDecimalField(qtyCol, BizDataType.OCC);
        }
    }

    private Map<String, Field<?>> getFieldMap() {
        HashMap result = new HashMap(16);
        List items = this.entityMeta.getItems();
        for (EntityItem item : items) {
            if (!(item instanceof Field)) continue;
            result.put(item.getKey(), (Field)item);
        }
        return result;
    }

    private void checkKeyCol(Map<String, Field<?>> fields) {
        Field<?> field = fields.get("keycol");
        if (field != null) {
            if (field instanceof TextField) {
                TextField keycol = (TextField)field;
                if (!"fkeycol".equals(keycol.getFieldName())) {
                    this.addBuildError("keycol", ResManager.loadKDString((String)"keycol\u7269\u7406\u8868\u5b57\u6bb5\u5fc5\u987b\u4e3afkeycol\u3002", (String)"BalanceTbChecker_8", (String)"bos-bal-metadata", (Object[])new Object[0]));
                }
                if (StringUtils.isNotBlank((CharSequence)keycol.getSuffix())) {
                    this.addBuildError("keycol", ResManager.loadKDString((String)"keycol\u5b57\u6bb5\u4e0d\u80fd\u9009\u62e9\u62c6\u5206\u8868\u3002", (String)"BalanceTbChecker_9", (String)"bos-bal-metadata", (Object[])new Object[0]));
                }
                if (!BizDataType.AUX.getNumber().equals(keycol.getBizDataType())) {
                    this.addBuildError("keycol", ResManager.loadKDString((String)"keycol\u5b57\u6bb5\u4e1a\u52a1\u7c7b\u578b\u5fc5\u987b\u4e3a{0}\u3002", (String)"BalanceTbChecker_10", (String)"bos-bal-metadata", (Object[])new Object[]{BizDataType.AUX.getName()}));
                }
            } else {
                this.addBuildError("keycol", ResManager.loadKDString((String)"keycol\u5fc5\u987b\u4e3a\u6587\u672c\u7c7b\u578b\u5b57\u6bb5\u3002", (String)"BalanceTbChecker_11", (String)"bos-bal-metadata", (Object[])new Object[0]));
            }
        } else {
            this.addBuildError(null, ResManager.loadKDString((String)"\u4f59\u989d\u8868\u5fc5\u987b\u8981\u6709\u4e00\u4e2a\u6587\u672c\u7c7b\u578b\u7684keycol\u5b57\u6bb5\u3002", (String)"BalanceTbChecker_12", (String)"bos-bal-metadata", (Object[])new Object[0]));
        }
    }

    private void checkPeriodBalEntity() {
        Map<String, Field<?>> fields = this.getFieldMap();
        this.checkKeyCol(fields);
        this.checkMTCol(fields);
        this.checkBizDataType(fields);
        this.checkPeriodCol(fields);
        this.checkPeriodQtyCols(fields);
    }

    private void checkPeriodQtyCols(Map<String, Field<?>> fields) {
        Field item;
        String key;
        HashMap<String, Field> initCols = new HashMap<String, Field>(8);
        HashMap inCols = new HashMap(8);
        HashMap outCols = new HashMap(8);
        HashMap balCols = new HashMap(8);
        HashMap yearInCols = new HashMap(8);
        HashMap yearOutCols = new HashMap(8);
        for (Map.Entry<String, Field<?>> entry : fields.entrySet()) {
            key = entry.getKey();
            item = entry.getValue();
            if (BizDataType.INIT.getNumber().equals(item.getBizDataType())) {
                this.checkDecimalField(item, BizDataType.INIT);
                initCols.put(key, item);
                continue;
            }
            if (BizDataType.IN.getNumber().equals(item.getBizDataType())) {
                this.checkDecimalField(item, BizDataType.IN);
                inCols.put(key, item);
                continue;
            }
            if (BizDataType.OUT.getNumber().equals(item.getBizDataType())) {
                this.checkDecimalField(item, BizDataType.OUT);
                outCols.put(key, item);
                continue;
            }
            if (BizDataType.BAL.getNumber().equals(item.getBizDataType())) {
                this.checkDecimalField(item, BizDataType.BAL);
                balCols.put(key, item);
                continue;
            }
            if (BizDataType.YEAR_IN.getNumber().equals(item.getBizDataType())) {
                this.checkDecimalField(item, BizDataType.YEAR_IN);
                yearInCols.put(key, item);
                continue;
            }
            if (!BizDataType.YEAR_OUT.getNumber().equals(item.getBizDataType())) continue;
            this.checkDecimalField(item, BizDataType.YEAR_OUT);
            yearOutCols.put(key, item);
        }
        for (Map.Entry<String, Object> entry : initCols.entrySet()) {
            key = entry.getKey();
            item = (Field)entry.getValue();
            this.checkQtyGroup(item, (Field)inCols.remove(key + "_in"), BizDataType.IN, true);
            this.checkQtyGroup(item, (Field)outCols.remove(key + "_out"), BizDataType.OUT, true);
            this.checkQtyGroup(item, (Field)balCols.remove(key + "_bal"), BizDataType.BAL, true);
            this.checkQtyGroup(item, (Field)yearInCols.remove(key + "_yearin"), BizDataType.YEAR_IN, false);
            this.checkQtyGroup(item, (Field)yearOutCols.remove(key + "_yearout"), BizDataType.YEAR_OUT, false);
        }
        this.checkQtyCol(inCols, BizDataType.IN, "_in");
        this.checkQtyCol(outCols, BizDataType.OUT, "_out");
        this.checkQtyCol(balCols, BizDataType.BAL, "_bal");
        this.checkQtyCol(yearInCols, BizDataType.YEAR_IN, "_yearin");
        this.checkQtyCol(yearOutCols, BizDataType.YEAR_OUT, "_yearout");
    }

    private void checkQtyCol(Map<String, Field<?>> cols, BizDataType type, String suffix) {
        for (Map.Entry<String, Field<?>> entry : cols.entrySet()) {
            String key = entry.getKey();
            if (key.endsWith(suffix)) {
                this.addBuildError(key, ResManager.loadKDString((String)"{0}\u5b57\u6bb5\u6ca1\u6709\u627e\u5230\u4e0e\u5176\u5bf9\u5e94\u7684\u671f\u521d\u6570\u636e\u5b57\u6bb5\u3002", (String)"BalanceTbChecker_5", (String)"bos-bal-metadata", (Object[])new Object[]{key}));
                continue;
            }
            this.addBuildError(key, ResManager.loadKDString((String)"{0}\u5b57\u6bb5\u4e1a\u52a1\u7c7b\u578b\u4e3a{1}\uff0c\u6807\u8bc6\u5fc5\u987b\u4ee5{2}\u7ed3\u5c3e\uff0c\u4e14\u8981\u4e0e{3}\u5bf9\u5e94\u3002", (String)"BalanceTbChecker_6", (String)"bos-bal-metadata", (Object[])new Object[]{key, type.getName(), suffix, BizDataType.INIT.getName()}));
        }
    }

    private void checkDecimalField(Field<?> item, BizDataType type) {
        if (!(item instanceof DecimalField)) {
            this.addBuildError(item.getKey(), ResManager.loadKDString((String)"{0}\u5b57\u6bb5\u4e1a\u52a1\u7c7b\u578b\u4e3a{1}\uff0c\u5fc5\u987b\u4e3a\u6570\u503c\u7c7b\u578b\u5b57\u6bb5\u3002", (String)"BalanceTbChecker_4", (String)"bos-bal-metadata", (Object[])new Object[]{item.getKey(), type.getName()}));
        }
    }

    private void isSameTb(Field<?> init, Field<?> item) {
        String tb = init.getSuffix();
        if (!StringUtils.equals((CharSequence)tb, (CharSequence)item.getSuffix())) {
            this.addBuildError(item.getKey(), ResManager.loadKDString((String)"{0}\u5b57\u6bb5\u5fc5\u987b\u4e0e\u5bf9\u5e94\u7684{1}\u5b57\u6bb5\u5728\u76f8\u540c\u7684\u62c6\u5206\u8868\u3002", (String)"BalanceTbChecker_7", (String)"bos-bal-metadata", (Object[])new Object[]{item.getKey(), BizDataType.INIT.getName()}));
        }
    }

    private void checkQtyGroup(Field<?> init, Field<?> item, BizDataType type, boolean checkExists) {
        if (item == null) {
            if (checkExists) {
                this.addBuildError(init.getKey(), ResManager.loadKDString((String)"{0}\u5b57\u6bb5\u7f3a\u5c11\u5bf9\u5e94\u7684{1}\u5b57\u6bb5\u3002", (String)"BalanceTbChecker_20", (String)"bos-bal-metadata", (Object[])new Object[]{init.getKey(), type.getName()}));
            }
        } else {
            this.isSameTb(init, item);
        }
    }

    private void checkMTCol(Map<String, Field<?>> fields) {
        int count = 0;
        for (Field<?> item : fields.values()) {
            if (!BizDataType.MT.getNumber().equals(item.getBizDataType())) continue;
            if (++count > 1) {
                this.addBuildError(item.getKey(), ResManager.loadKDString((String)"{0}\u5b57\u6bb5\u53ea\u80fd\u6709\u4e00\u4e2a\u3002", (String)"BalanceTbChecker_13", (String)"bos-bal-metadata", (Object[])new Object[]{BizDataType.MT.getName()}));
            }
            if (!(item instanceof DateTimeField)) {
                this.addBuildError(item.getKey(), ResManager.loadKDString((String)"{0}\u5b57\u6bb5\u5fc5\u987b\u4e3a\u65f6\u95f4\u7c7b\u578b\u5b57\u6bb5\u3002", (String)"BalanceTbChecker_14", (String)"bos-bal-metadata", (Object[])new Object[]{BizDataType.MT.getName()}));
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)item.getSuffix())) continue;
            this.addBuildError(item.getKey(), ResManager.loadKDString((String)"{0}\u5b57\u6bb5\u4e0d\u80fd\u5728\u6269\u5c55\u8868\u4e2d\u3002", (String)"BalanceTbChecker_15", (String)"bos-bal-metadata", (Object[])new Object[]{BizDataType.MT.getName()}));
        }
    }

    private void checkPeriodCol(Map<String, Field<?>> fields) {
        ArrayList periodCol = new ArrayList(1);
        ArrayList endPeriodCol = new ArrayList(1);
        for (Field<?> field : fields.values()) {
            if (BizDataType.PER.getNumber().equals(field.getBizDataType())) {
                periodCol.add(field);
                continue;
            }
            if (!BizDataType.ENDPER.getNumber().equals(field.getBizDataType())) continue;
            endPeriodCol.add(field);
        }
        this.checkPeriodCol(periodCol, BizDataType.PER);
        this.checkPeriodCol(endPeriodCol, BizDataType.ENDPER);
    }

    private void checkPeriodCol(List<Field<?>> periodCol, BizDataType type) {
        if (periodCol.size() != 1) {
            String name = ResManager.loadKDString((String)"\u4f59\u989d\u8868", (String)"BalanceTbChecker_16", (String)"bos-bal-metadata", (Object[])new Object[0]);
            String error = ResManager.loadKDString((String)"\u671f\u95f4\u4f59\u989d\u8868\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a\u4e1a\u52a1\u7c7b\u578b\u4e3a{0}\u7684\u5b57\u6bb5\u3002", (String)"BalanceTbChecker_17", (String)"bos-bal-metadata", (Object[])new Object[]{type.getName()});
            this.addBuildError(name, error);
        } else {
            Field<?> col = periodCol.get(0);
            String colName = col.getName().toString();
            if (!(col instanceof IntegerField)) {
                this.addBuildError(colName, ResManager.loadKDString((String)"{0}\u5b57\u6bb5\u5fc5\u987b\u4e3a\u6574\u6570\u7c7b\u578b\u5b57\u6bb5\u3002", (String)"BalanceTbChecker_18", (String)"bos-bal-metadata", (Object[])new Object[]{type.getName()}));
            }
            if (StringUtils.isNotBlank((CharSequence)col.getSuffix())) {
                this.addBuildError(colName, ResManager.loadKDString((String)"{0}\u5b57\u6bb5\u4e0d\u80fd\u5728\u62c6\u5206\u8868\u4e2d\u3002", (String)"BalanceTbChecker_19", (String)"bos-bal-metadata", (Object[])new Object[]{type.getName()}));
            }
        }
    }
}

