/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.opplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.util.StringUtils;
import kd.data.idi.decision.model.SchemaDecisionRelation;
import kd.data.idi.decision.service.SchemaDecisionService;
import kd.data.idi.opplugin.IDISchemaSaveValidator;

public class IDISchemaSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new IDISchemaSaveValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        ArrayList<String> deleteSchemaNums = new ArrayList<String>(e.getDataEntities().length);
        ArrayList<SchemaDecisionRelation> saveRelations = new ArrayList<SchemaDecisionRelation>(8);
        for (DynamicObject schema : e.getDataEntities()) {
            String decisionTypeNums;
            String schemaNum = schema.getString("number");
            if (StringUtils.isEmpty((String)schemaNum)) continue;
            deleteSchemaNums.add(schemaNum);
            String decisionTypeKey = schemaNum + ".decisionTypeNums";
            if (!this.getOption().containsVariable(decisionTypeKey) || StringUtils.isEmpty((String)(decisionTypeNums = this.getOption().getVariableValue(decisionTypeKey)))) continue;
            List decisionTypeNumList = (List)SerializationUtils.fromJsonString((String)decisionTypeNums, List.class);
            for (String decisionTypeNum : decisionTypeNumList) {
                SchemaDecisionRelation relation = new SchemaDecisionRelation();
                relation.setSchemaNum(schemaNum);
                relation.setDecisionNum(decisionTypeNum);
                saveRelations.add(relation);
            }
        }
        SchemaDecisionService schemaDecisionService = new SchemaDecisionService();
        schemaDecisionService.deleteBySchemaNum(deleteSchemaNums.toArray(new String[0]));
        schemaDecisionService.save(saveRelations);
    }
}

