/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.api.external;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.isc.util.misc.NetUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.data.idi.api.external.impl.AbutmentParam;
import kd.data.idi.api.external.impl.UrlParam;
import kd.data.idi.util.IDIHttpUtils;

public interface IExternalApiAbutment<P extends AbutmentParam, T> {
    public UrlParam getUrlParam(String var1, AbutmentParam var2);

    public boolean validate(UrlParam var1, P var2);

    public String tokenService();

    public String getToken(UrlParam var1);

    public String getTokenFromCache(String var1);

    public String buildCacheKey(String var1);

    public String apiService();

    public String apiAction(UrlParam var1, P var2);

    public T parseResult(String var1, P var2);

    default public boolean importAPI(String apiNumber) {
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_apic_script", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)apiNumber)});
        if (object == null) {
            String fileName = "resources/" + apiNumber + ".dts";
            try (InputStream in = this.getClass().getClassLoader().getResource(fileName).openStream();){
                String jsonStr = NetUtil.readText((InputStream)in);
                Object object2 = DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscResourceService", (String)"importResourceWithPattern", (Object[])new Object[]{jsonStr, true});
            }
            catch (IOException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", ""), new Object[]{e.getMessage()});
            }
            return true;
        }
        return false;
    }

    default public String iscInvoke(String apiNumber, String dataMap, String url, int timeOut) {
        return this.iscInvoke(apiNumber, dataMap, url, timeOut, "application/json;charset=UTF-8");
    }

    default public String iscInvoke(String apiNumber, String dataMap, String url, int timeOut, String contentType) {
        HashMap params = new HashMap(10);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap cookiesMap = new HashMap();
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headersMap.put("Content-Type", contentType);
        String[] proxyStr = IDIHttpUtils.queryProxyHost();
        String urlParam = proxyStr == null ? url : url + "=>" + proxyStr[0] + ':' + proxyStr[1];
        paramMap.put("url", urlParam);
        paramMap.put("method", "POST");
        paramMap.put("charset", "utf-8");
        paramMap.put("data", dataMap);
        paramMap.put("cookies", cookiesMap);
        paramMap.put("headers", headersMap);
        paramMap.put("timeout", timeOut);
        params.put("paramMap", paramMap);
        return (String)DispatchServiceHelper.invokeExternalService((String)"idi", (String)apiNumber, params);
    }
}

