/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.api.external.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.api.external.IExternalApiAbutment;
import kd.data.idi.api.external.impl.AbutmentParam;
import kd.data.idi.api.external.impl.UrlParam;
import kd.data.idi.engine.CacheManager;
import kd.data.idi.engine.ParamFactory;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.courier.service.CourierLogisticParser;
import kd.data.idi.engine.courier.service.CourierParam;
import kd.data.idi.util.IDIEncryptUtils;
import kd.data.idi.util.IDIJSONUtils;

public class CourierLogisticsApiAbutmentImpl
implements IExternalApiAbutment<CourierParam, DynamicObject> {
    private static final String COMPANYNUM_SF = "shunfeng";
    private static final String KEY_MOBILE = "mobile";

    @Override
    public UrlParam getUrlParam(String number, AbutmentParam additionalConfig) {
        UrlParam urlParam = new UrlParam();
        HashMap<String, String> map = new HashMap<String, String>();
        String url = null;
        String app_key = null;
        String secret = null;
        String method = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"CourierLogisticsAbutmentImpl.getUrlParam", (String)"idi_api_config", (String)"number,url,clientid,clientsecret,httpmethod,paramentryentity.paramname,paramentryentity.paramtype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("enable", "=", (Object)"1")}, null);){
            if (dataSet != null) {
                for (Row row : dataSet) {
                    url = row.getString("url");
                    app_key = row.getString("clientid");
                    secret = row.getString("clientsecret");
                    method = row.getString("httpmethod");
                    String mobileName = row.getString("paramentryentity.paramname");
                    String mobile = row.getString("paramentryentity.paramtype");
                    map.put(mobileName, mobile);
                }
            }
        }
        urlParam.setUrl(url);
        urlParam.setCustomerKey(app_key);
        urlParam.setSecret(secret);
        urlParam.setRequestMethod(method);
        urlParam.setParamMap(map);
        return urlParam;
    }

    @Override
    public boolean validate(UrlParam urlParam, CourierParam courierParam) {
        String errorMesg = ResManager.loadKDString((String)"\u7f3a\u5c11API\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7ef4\u62a4", (String)"APIConfig_0", (String)"data-idi-core", (Object[])new Object[0]);
        if (urlParam == null) {
            SchemaExecutorLogger.error("CourierLogisticsAbutmentImpl-UrlParam is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)urlParam.getUrl())) {
            SchemaExecutorLogger.error("CourierLogisticsAbutmentImpl-UrlParam.url is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)urlParam.getCustomerKey())) {
            SchemaExecutorLogger.error("CourierLogisticsAbutmentImpl-UrlParam.client_id is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)urlParam.getSecret())) {
            SchemaExecutorLogger.error("CourierLogisticsAbutmentImpl-UrlParam.client_secret is null");
            throw new KDBizException(errorMesg);
        }
        Map<String, String> paramMap = urlParam.getParamMap();
        if (paramMap == null || paramMap.isEmpty()) {
            SchemaExecutorLogger.error("CourierLogisticsAbutmentImpl-UrlParam.paramMap is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)paramMap.get(KEY_MOBILE))) {
            SchemaExecutorLogger.error("CourierLogisticsAbutmentImpl-UrlParam.paramMap.mobile is null");
            throw new KDBizException(errorMesg);
        }
        if (courierParam == null) {
            SchemaExecutorLogger.error("CourierLogisticsAbutmentImpl-courierParam is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)courierParam.getCompanyNum())) {
            SchemaExecutorLogger.error("CourierLogisticsAbutmentImpl-CourierParam.companyNum is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)courierParam.getOrder())) {
            SchemaExecutorLogger.error("CourierLogisticsAbutmentImpl-CourierParam.order is null");
            throw new KDBizException(errorMesg);
        }
        if (COMPANYNUM_SF.equals(courierParam.getCompanyNum()) && StringUtils.isEmpty((String)courierParam.getMobile())) {
            SchemaExecutorLogger.error("CourierLogisticsAbutmentImpl-CourierParam.mobile is null");
            throw new KDBizException(errorMesg);
        }
        return true;
    }

    @Override
    public String tokenService() {
        return "/open/oauth/token";
    }

    @Override
    public String getToken(UrlParam urlParam) {
        Map contentJson;
        String token;
        TreeMap<String, Object> requestParam = new TreeMap<String, Object>();
        requestParam.put("client_id", urlParam.getCustomerKey());
        requestParam.put("client_secret", urlParam.getSecret());
        requestParam.put("timestamp", String.valueOf(System.currentTimeMillis()));
        requestParam.put("grant_type", "client_credentials");
        requestParam.put(KEY_MOBILE, urlParam.getParamMap().get(KEY_MOBILE));
        String sign = this.buildSign(urlParam.getSecret(), requestParam);
        SchemaExecutorLogger.info("getToken, sign=" + sign, new Object[0]);
        requestParam.put("sign", sign);
        String paramStr = this.processParam(requestParam);
        SchemaExecutorLogger.info("getToken, paramStr=" + paramStr, new Object[0]);
        String url = urlParam.getUrl() + this.tokenService();
        SchemaExecutorLogger.info("getToken, url=" + url, new Object[0]);
        int timeOut = ParamFactory.getTimeOut();
        String number = "data-idi-kuaidi100token";
        this.importAPI(number);
        String content = this.iscInvoke(number, paramStr, url, timeOut, "application/x-www-form-urlencoded;charset=ISO-8859-1");
        SchemaExecutorLogger.info("getToken, content=" + content, new Object[0]);
        if (StringUtils.isNotEmpty((String)content) && StringUtils.isNotEmpty((String)(token = String.valueOf((contentJson = (Map)IDIJSONUtils.cast((String)content, Map.class)).get("access_token"))))) {
            String expiresSecond = String.valueOf(contentJson.get("expires_in"));
            String cacheKey = this.buildCacheKey(null);
            CacheManager.put("token", cacheKey, token, Integer.parseInt(expiresSecond));
            SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u628atoken\u5b58\u5165\u7f13\u5b58, cacheKey:%s ", (String)"IDIInvoicePiaoZoneHelper_5", (String)"data-idi-core", (Object[])new Object[0]), CacheManager.makeCacheKey("token", cacheKey)), new Object[0]);
            return token;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6token\u5931\u8d25\uff0c\u68c0\u67e5API\u53c2\u6570\u662f\u5426\u6b63\u786e", (String)"CourierLogisticsHelper_0", (String)"data-idi-core", (Object[])new Object[0]));
    }

    private String buildSign(String clientSecret, Map<String, Object> requestParam) {
        Map<String, Object> paramsMap = null;
        if (requestParam instanceof TreeMap) {
            paramsMap = requestParam;
        } else {
            paramsMap = new TreeMap<String, Object>();
            paramsMap.putAll(requestParam);
        }
        StringBuilder strBuffer = new StringBuilder(clientSecret);
        Set<Map.Entry<String, Object>> entrySet = paramsMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            strBuffer.append(entry.getKey()).append(entry.getValue());
        }
        strBuffer.append(clientSecret);
        String paramStr = strBuffer.toString();
        String errorMessage = ResManager.loadKDString((String)"\u53c2\u6570\u8fde\u63a5\u5b57\u7b26\u4e32\uff1a", (String)"CourierLogisticsHelper_3", (String)"data-idi-core", (Object[])new Object[0]);
        SchemaExecutorLogger.info(errorMessage + paramStr, new Object[0]);
        return this.encode(paramStr);
    }

    public String processParam(Map<String, Object> requestParam) {
        StringBuilder sb = new StringBuilder();
        try {
            for (Map.Entry<String, Object> entry : requestParam.entrySet()) {
                String paramName = URLEncoder.encode(entry.getKey(), "UTF-8");
                String paramValue = URLEncoder.encode(String.valueOf(entry.getValue()), "UTF-8");
                sb.append(paramName).append('=').append(paramValue).append('&');
            }
        }
        catch (UnsupportedEncodingException e) {
            SchemaExecutorLogger.error("processParam error ", e);
            throw new KDBizException((Throwable)e, new ErrorCode("", ""), new Object[]{"processParam error "});
        }
        return sb.substring(0, sb.length() - 1);
    }

    public String encode(String s) {
        String encryptStr = IDIEncryptUtils.getMD5((String)s);
        if (encryptStr != null) {
            encryptStr = encryptStr.toUpperCase(Locale.ENGLISH);
        }
        return encryptStr;
    }

    @Override
    public String getTokenFromCache(String cacheKey) {
        String cacheToken = CacheManager.get("token", cacheKey);
        if (StringUtils.isNotEmpty((String)cacheToken)) {
            SchemaExecutorLogger.info("tokenStr in cache :" + cacheToken, new Object[0]);
        }
        return cacheToken;
    }

    @Override
    public String buildCacheKey(String fixKey) {
        return "kuaidi";
    }

    @Override
    public String apiService() {
        return "/v7/open/api/routeQuery";
    }

    @Override
    public String apiAction(UrlParam urlParam, CourierParam courierParam) {
        this.validate(urlParam, courierParam);
        String cacheKey = this.buildCacheKey(urlParam.getCustomerKey());
        String token = this.getTokenFromCache(cacheKey);
        boolean hasGetTokenFromInterface = false;
        if (StringUtils.isEmpty((String)token)) {
            token = this.getToken(urlParam);
            hasGetTokenFromInterface = true;
        }
        TreeMap<String, Object> requestParam = new TreeMap<String, Object>();
        requestParam.put("app_key", urlParam.getCustomerKey());
        requestParam.put("access_token", token);
        requestParam.put("timestamp", String.valueOf(System.currentTimeMillis()));
        HashMap<String, String> josn = new HashMap<String, String>();
        String company = courierParam.getCompanyNum();
        josn.put("kuaidi_com", company);
        josn.put("kuaidi_num", courierParam.getOrder());
        if (COMPANYNUM_SF.equals(company)) {
            josn.put(KEY_MOBILE, courierParam.getMobile());
        }
        requestParam.put("data", IDIJSONUtils.toJsonString(josn));
        String sign = this.buildSign(urlParam.getSecret(), requestParam);
        SchemaExecutorLogger.info("queryKuaidi, sign=" + sign, new Object[0]);
        requestParam.put("sign", sign);
        String paramStr = this.processParam(requestParam);
        SchemaExecutorLogger.info("queryKuaidi, paramStr=" + paramStr, new Object[0]);
        String url = urlParam.getUrl() + this.apiService();
        SchemaExecutorLogger.info("queryKuaidi, url=" + url, new Object[0]);
        int timeOut = ParamFactory.getTimeOut();
        String number = "data-idi-kuaidi100";
        this.importAPI(number);
        String content = this.iscInvoke(number, paramStr, url, timeOut, "application/x-www-form-urlencoded;charset=ISO-8859-1");
        SchemaExecutorLogger.info("queryKuaidi, content=" + content, new Object[0]);
        if (!hasGetTokenFromInterface && StringUtils.isNotEmpty((String)content) && content.contains("40018")) {
            CacheManager.del("token", cacheKey);
            return this.apiAction(urlParam, courierParam);
        }
        SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"result:%s", (String)"IDIInvoicePiaoZoneHelper_9", (String)"data-idi-core", (Object[])new Object[0]), content), new Object[0]);
        return content;
    }

    @Override
    public DynamicObject parseResult(String content, CourierParam courierParam) {
        DynamicObject result = CourierLogisticParser.parse(content);
        if (result == null) {
            return CourierLogisticParser.parseError(content, courierParam);
        }
        result.set("kuadicomname", (Object)courierParam.getComapnyName());
        return result;
    }
}

