/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.data.statistics;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.data.idi.data.Area;
import kd.data.idi.data.Decision;
import kd.data.idi.data.InvoiceConfig;
import kd.data.idi.data.InvoiceConfigCustom;
import kd.data.idi.data.MatchType;
import kd.data.idi.data.Schema;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.util.IDIJSONUtils;

public class SchemeQuantityStatistics {
    public static Map<String, Integer> getDecisionInfo(Date startTime, Date endTime) {
        int enableCount = 0;
        int enableSourceCount = 0;
        int enableConfigCount = 0;
        int totalCount = 0;
        QFilter[] enableFilter = new QFilter[]{new QFilter("enable", "=", (Object)"1")};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getDecisionInfo", (String)"idi_schema", (String)"id,sourceentitynumber,rule_tag", (QFilter[])enableFilter, (String)"id");){
            if (ds != null) {
                HashSet<String> sourceTypeSet = new HashSet<String>(16);
                while (ds.hasNext()) {
                    String sourceEntity;
                    Row next = ds.next();
                    ++enableCount;
                    String rule_tag = next.getString("rule_tag");
                    if (rule_tag != null && !rule_tag.isEmpty()) {
                        List<Area> areaList;
                        Schema schema = (Schema)IDIJSONUtils.cast((String)rule_tag, Schema.class);
                        if (schema == null || (areaList = schema.getArea()) == null || areaList.isEmpty()) continue;
                        for (Area area : areaList) {
                            List<Decision> decisionList = area.getDecision();
                            if (decisionList == null || decisionList.isEmpty()) continue;
                            for (Decision decision : decisionList) {
                                if (MatchType.INVOICE.getType().equals(decision.getMatchType())) {
                                    List<InvoiceConfigCustom> customList;
                                    InvoiceConfig invoiceConfig = decision.getInvoiceConfig();
                                    if (invoiceConfig == null) continue;
                                    if (invoiceConfig.isCertifiedOfInvoice()) {
                                        ++enableConfigCount;
                                    }
                                    if (invoiceConfig.isDuplicate()) {
                                        ++enableConfigCount;
                                    }
                                    if (invoiceConfig.isCheckInvoiceHeader()) {
                                        ++enableConfigCount;
                                    }
                                    if (invoiceConfig.isBuyerTaxCode()) {
                                        ++enableConfigCount;
                                    }
                                    if (invoiceConfig.isCompletedOfSalerInfo()) {
                                        ++enableConfigCount;
                                    }
                                    if (invoiceConfig.isCompletedOfBuyerInfo()) {
                                        ++enableConfigCount;
                                    }
                                    if (invoiceConfig.isFullAmountOfAllInvoices()) {
                                        ++enableConfigCount;
                                    }
                                    if (invoiceConfig.isCrossOneYear()) {
                                        ++enableConfigCount;
                                    }
                                    if (invoiceConfig.isContinuousNumber()) {
                                        ++enableConfigCount;
                                    }
                                    if ((customList = invoiceConfig.getCustomList()) == null) continue;
                                    enableConfigCount += customList.size();
                                    continue;
                                }
                                ++enableConfigCount;
                            }
                        }
                    }
                    if (!sourceTypeSet.add(sourceEntity = next.getString("sourceentitynumber"))) continue;
                    totalCount += SchemeQuantityStatistics.accumulatedSourceAccount(sourceEntity, startTime, endTime).intValue();
                }
                enableSourceCount = sourceTypeSet.size();
            }
        }
        catch (Exception ex) {
            SchemaExecutorLogger.error("getDecisionInfo error", ex);
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>(4);
        result.put("enableCount", enableCount);
        result.put("enableSourceCount", enableSourceCount);
        result.put("enableConfigCount", enableConfigCount);
        result.put("totalCount", totalCount);
        SchemaExecutorLogger.info(String.format("getDecisionInfo result\uff1a%s", IDIJSONUtils.toJsonString(result)), new Object[0]);
        return result;
    }

    private static Integer accumulatedSourceAccount(String sourceEntity, Date startTime, Date endTime) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)sourceEntity);
        if (dataEntityType == null || !dataEntityType.getFields().containsKey("createtime")) {
            return 0;
        }
        QFilter timeFilter = new QFilter("createtime", ">=", (Object)startTime).and("createtime", "<", (Object)endTime);
        int count = 0;
        try (DataSet sourceDs = QueryServiceHelper.queryDataSet((String)"SchemeQuantityStatistics#querySourceEntity", (String)sourceEntity, (String)"id", (QFilter[])new QFilter[]{timeFilter}, null);){
            count = sourceDs.count("id", true);
        }
        return count;
    }
}

