/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.decision.executor;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.util.CollectionUtils;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.decision.model.ExtDecisionInfo;
import kd.data.idi.decision.openapi.ApiDecisionResult;
import kd.data.idi.decision.openapi.ApiDecisionResultItem;
import kd.data.idi.engine.DecisionExecutor;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.util.IDIJSONUtils;

public abstract class AbstractExtDecisionExecutor
implements DecisionExecutor {
    protected ExtDecisionInfo extDecisionInfo;

    public AbstractExtDecisionExecutor(ExtDecisionInfo extDecisionInfo) {
        this.extDecisionInfo = extDecisionInfo;
    }

    @Override
    public DecisionResult execute(SchemaContext context, Decision decision) {
        this.verifyExtDecisionConfig(this.extDecisionInfo);
        String executeDecisionResult = this.executeDecision(context, decision, this.extDecisionInfo);
        DecisionResult result = new DecisionResult();
        result.setDecision(decision);
        ApiDecisionResult apiDecisionResult = (ApiDecisionResult)IDIJSONUtils.cast((String)executeDecisionResult, ApiDecisionResult.class);
        if (apiDecisionResult == null || CollectionUtils.isEmpty(apiDecisionResult.getResults())) {
            SchemaExecutorLogger.error("ext decision result is null or empty");
            String errorMessage = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u68c0\u67e5\u9879\u8c03\u7528\u5f02\u5e38", (String)"AbstractExtDecisionExecutor_2", (String)"data-idi-core", (Object[])new Object[0]);
            throw new KDBizException(errorMessage);
        }
        boolean failed = false;
        for (ApiDecisionResultItem resultItem : apiDecisionResult.getResults()) {
            if ("green".equals(resultItem.getStatus())) continue;
            failed = true;
        }
        result.setApiDecisionResultItems(apiDecisionResult.getResults());
        if (failed) {
            result.setDeductPercent(new BigDecimal(100));
        } else {
            result.setDeductPercent(BigDecimal.ZERO);
        }
        return result;
    }

    protected abstract String executeDecision(SchemaContext var1, Decision var2, ExtDecisionInfo var3);

    protected void verifyExtDecisionConfig(ExtDecisionInfo extDecisionInfo) {
        if (extDecisionInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u68c0\u67e5\u9879\u4e0d\u5b58\u5728", (String)"AbstractExtDecisionExecutor_0", (String)"data-idi-core", (Object[])new Object[0]));
        }
        if (!extDecisionInfo.isEnable()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u68c0\u67e5\u9879\u5df2\u7981\u7528", (String)"AbstractExtDecisionExecutor_1", (String)"data-idi-core", (Object[])new Object[0]));
        }
    }

    protected Map<String, String> buildServiceParams(ExtDecisionInfo extDecisionInfo) {
        HashMap<String, String> paramMap = new HashMap<String, String>(8);
        List<Map<String, String>> paramList = extDecisionInfo.getMethodParamsTag();
        if (CollectionUtils.isNotEmpty(paramList)) {
            for (Map<String, String> param : paramList) {
                String paramName = param.get("param_name");
                if (!StringUtils.isNotEmpty((CharSequence)paramName)) continue;
                paramMap.put(paramName, param.get("param_value"));
            }
        }
        return paramMap;
    }
}

