/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.decision.service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.decision.constant.CardRowDetailDisplayType;
import kd.data.idi.decision.constant.DecisionExtType;
import kd.data.idi.decision.constant.MicroServiceType;
import kd.data.idi.decision.model.ExtDecisionInfo;

public class DecisionTypeExtInfoService {
    public List<ExtDecisionInfo> findAvailableExtInfo(String srcEntityNum) {
        ArrayList<ExtDecisionInfo> extInfos = new ArrayList<ExtDecisionInfo>();
        if (srcEntityNum == null) {
            return extInfos;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("srcentitynums.fbasedataid", "=", (Object)srcEntityNum).or("srcentitynum", "=", (Object)srcEntityNum));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        extInfos.addAll(this.queryList(filters));
        extInfos.sort(Comparator.comparingLong(ExtDecisionInfo::getId));
        return extInfos;
    }

    public ExtDecisionInfo queryByMatchType(String matchType) {
        long matchTypeId = 0L;
        try {
            matchTypeId = Long.parseLong(matchType);
        }
        catch (Exception e) {
            return null;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("id", "=", (Object)matchTypeId));
        List<ExtDecisionInfo> extInfos = this.queryList(filters);
        if (CollectionUtils.isNotEmpty(extInfos)) {
            return extInfos.get(0);
        }
        return null;
    }

    private List<ExtDecisionInfo> queryList(List<QFilter> filters) {
        ArrayList<ExtDecisionInfo> extInfos = new ArrayList<ExtDecisionInfo>(8);
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"idi_decision_extinfo", (QFilter[])filters.toArray(new QFilter[0]));
        for (DynamicObject dObject : objectMap.values()) {
            ExtDecisionInfo extInfo = new ExtDecisionInfo();
            extInfo.setId(dObject.getLong("id"));
            extInfo.setNumber(dObject.getString("number"));
            extInfo.setName(dObject.getString("name"));
            extInfo.setExtType(DecisionExtType.parseType(dObject.getString("ext_type")));
            extInfo.setServiceType(MicroServiceType.parseType(dObject.getString("service_type")));
            extInfo.setCloudId(dObject.getString("cloudid"));
            extInfo.setAppId(dObject.getString("appid"));
            extInfo.setServiceName(dObject.getString("service_name"));
            extInfo.setMethodName(dObject.getString("method_name"));
            extInfo.setPluginClass(dObject.getString("pluginclass"));
            extInfo.setEnable("1".equals(dObject.getString("enable")));
            String detailDisplayType = dObject.getString("detaildisplaytype");
            if (StringUtils.isNotEmpty((String)detailDisplayType)) {
                extInfo.setDetailDisplayType(Integer.parseInt(detailDisplayType));
            } else {
                extInfo.setDetailDisplayType(CardRowDetailDisplayType.HOVER.getType());
            }
            String methodparams = dObject.getString("methodparams_tag");
            if (!StringUtils.isBlank((String)methodparams)) {
                extInfo.setMethodParamsTag((List)SerializationUtils.fromJsonString((String)methodparams.trim(), List.class));
            }
            extInfos.add(extInfo);
        }
        return extInfos;
    }
}

