/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.LogicOperate;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.data.AlarmConfig;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionFrontEndResult;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.DeductionGradeConfig;
import kd.data.idi.data.HoverContent;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.data.statistics.AlarmHoverSettingRow;
import kd.data.idi.engine.AlarmFormula;
import kd.data.idi.engine.DecisionExecutor;
import kd.data.idi.engine.DeductionGrade;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.ScriptUtils;
import kd.data.idi.engine.ai.service.ISimilarService;
import kd.data.idi.util.DeductionGradeConfigUtil;
import kd.data.idi.util.IDIDateUtils;
import kd.data.idi.util.IDIJSONUtils;

public class AlarmExecutor
implements DecisionExecutor {
    private Map<String, String> entryMarkMap;
    private MainEntityType billType;
    private DynamicObject billObj;
    private SchemaContext context;
    private static final Long ZERO = 0L;

    @Override
    public DecisionResult execute(SchemaContext context, Decision decision) {
        AlarmConfig alarmConfig = decision.getAlarm();
        if (alarmConfig == null) {
            return null;
        }
        FilterCondition filterCondition = alarmConfig.getFilterCondition();
        if (filterCondition == null || filterCondition.getFilterRow() == null || filterCondition.getFilterRow().isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u80fd\u7b5b\u9009\u51fa\u5386\u53f2\u5bf9\u6bd4\u5355\u636e", (String)"AlarmExecutor_1", (String)"data-idi-core", (Object[])new Object[0]));
        }
        DynamicObject billObj = ExecutorHelper.getSelfBill(context);
        MainEntityType billType = EntityMetadataCache.getDataEntityType((String)context.getEntityType());
        Map allEntities = billType.getAllEntities();
        HashMap<String, String> entryMarkMap = new HashMap<String, String>(50);
        for (Map.Entry typeEntry : allEntities.entrySet()) {
            if (!(typeEntry.getValue() instanceof EntryType)) continue;
            for (IDataEntityProperty property : ((EntityType)typeEntry.getValue()).getProperties()) {
                entryMarkMap.put(property.getName(), (String)typeEntry.getKey());
            }
        }
        List rows = filterCondition.getFilterRow();
        IDICondition startCondition = alarmConfig.getStartCondition();
        MainEntityType srcEntityType = context.getSrcEntityType();
        if (startCondition != null && StringUtils.isNotEmpty((String)startCondition.getScript())) {
            Set<String> propSet = ScriptUtils.getEntries(srcEntityType, startCondition.getScript(), new String[]{context.getEntityType()});
            if (propSet.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u542f\u52a8\u6761\u4ef6\u4e0d\u652f\u6301\u8de8\u6e90\u5355\u7684\u591a\u4e2a\u5206\u5f55\u3002", (String)"AlarmExecutor_6", (String)"data-idi-core", (Object[])new Object[0]));
            }
            String startConditionEntry = null;
            String selectFields = "id";
            if (propSet.size() == 1) {
                startConditionEntry = propSet.iterator().next();
                selectFields = selectFields + ", " + startConditionEntry + ".id";
            }
            FilterBuilder stratFilterBuilder = new FilterBuilder(srcEntityType, startCondition.getFilterCondition());
            try {
                stratFilterBuilder.buildFilter(false);
            }
            catch (Exception ex) {
                SchemaExecutorLogger.error(IDIJSONUtils.toJsonString((Object)filterCondition), ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u542f\u52a8\u6761\u4ef6\u6784\u5efa\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AlarmExecutor_7", (String)"data-idi-core", (Object[])new Object[0]));
            }
            QFilter qFilter = new QFilter("id", "=", (Object)billObj.getLong("id"));
            qFilter.and(stratFilterBuilder.getQFilter());
            DynamicObjectCollection matchData = QueryServiceHelper.query((String)srcEntityType.getName(), (String)selectFields, (QFilter[])new QFilter[]{qFilter});
            Set entrySet = billObj.getDataEntityType().getProperties().stream().filter(EntryProp.class::isInstance).map(IMetadata::getName).collect(Collectors.toSet());
            if (matchData != null && !matchData.isEmpty() && startConditionEntry != null && entrySet.contains(startConditionEntry)) {
                HashSet retainEntryObj = new HashSet(10);
                String entryIdLogo = startConditionEntry + ".id";
                DynamicObjectCollection entryCollection = billObj.getDynamicObjectCollection(startConditionEntry);
                Map entryMap = entryCollection.stream().collect(Collectors.toMap(obj -> obj.getLong("id"), Function.identity()));
                for (DynamicObject matchDatum : matchData) {
                    long entryId = matchDatum.getLong(entryIdLogo);
                    retainEntryObj.add(entryMap.get(entryId));
                }
                entryCollection.clear();
                entryCollection.addAll(retainEntryObj);
            } else if (matchData == null || matchData.isEmpty()) {
                return this.notMatchStartCondition(decision, new DeductionGrade(context));
            }
        }
        this.entryMarkMap = entryMarkMap;
        this.billType = billType;
        this.billObj = billObj;
        this.context = context;
        AlarmFormula formula = AlarmFormula.createFormula(rows, this);
        Map<Object, Map<String, Set<Object>>> sameIdMap = formula.calculate();
        SchemaExecutorLogger.info(decision.getName() + "\n sameId match count:" + sameIdMap.size(), new Object[0]);
        Map<Object, Map> collect = sameIdMap.entrySet().stream().limit(30L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        SchemaExecutorLogger.info(decision.getName() + "\n sameIdMap structure: " + IDIJSONUtils.toJsonString(collect), new Object[0]);
        DecisionResult result = new DecisionResult();
        result.setDecision(decision);
        DeductionGrade deductionGrade = new DeductionGrade(context);
        if (!sameIdMap.isEmpty()) {
            DecisionFrontEndResult decisionFrontEndResult = this.getDecisionFrontEndResult(alarmConfig, context, sameIdMap);
            result.setFrontEndResult(decisionFrontEndResult);
            result.setShowText(alarmConfig.getFailText());
            result.setStatus("alarming");
            if (alarmConfig.isCheckVote()) {
                result.setOneVoteVeto(true);
            }
            deductionGrade.deduct(100);
        } else {
            result.setShowText(alarmConfig.getSuccessText());
            result.setStatus("green");
            deductionGrade.deduct(0);
        }
        result.setDeductPercent(deductionGrade.getValue());
        return result;
    }

    public Map<Object, Map<String, Set<Object>>> executeFilter(List<SimpleFilterRow> rows) {
        ArrayList allFilters = new ArrayList(10);
        ArrayList<SimpleFilterRow> leftOrFilter = new ArrayList<SimpleFilterRow>(10);
        for (SimpleFilterRow row : rows) {
            leftOrFilter.add(row);
            if (!row.getLogic().equals("1")) continue;
            allFilters.add(leftOrFilter);
            leftOrFilter = new ArrayList(10);
        }
        if (!leftOrFilter.isEmpty()) {
            allFilters.add(leftOrFilter);
        }
        HashMap<Object, Map<String, Set<Object>>> sameIdMap = new HashMap<Object, Map<String, Set<Object>>>(10);
        for (List list : allFilters) {
            Map<Object, Map<String, Set<Object>>> idMap = this.checkRepetition(list, this.entryMarkMap, this.billType, this.billObj, this.context);
            if (idMap.isEmpty()) continue;
            for (Map.Entry<Object, Map<String, Set<Object>>> entry : idMap.entrySet()) {
                if (sameIdMap.get(entry.getKey()) == null || ((Map)sameIdMap.get(entry.getKey())).isEmpty()) {
                    sameIdMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                Map entryMap = (Map)sameIdMap.get(entry.getKey());
                for (Map.Entry<String, Set<Object>> entityEntry : entry.getValue().entrySet()) {
                    if (entryMap.get(entityEntry.getKey()) == null) {
                        entryMap.put(entityEntry.getKey(), entityEntry.getValue());
                        continue;
                    }
                    ((Set)entryMap.get(entityEntry.getKey())).addAll((Collection)entityEntry.getValue());
                }
            }
        }
        return sameIdMap;
    }

    private DecisionFrontEndResult getDecisionFrontEndResult(AlarmConfig alarmConfig, SchemaContext context, Map<Object, Map<String, Set<Object>>> sameIdMap) {
        MainEntityType billType = EntityMetadataCache.getDataEntityType((String)context.getEntityType());
        String noOrNumberField = billType instanceof BasedataEntityType ? "number" : "billno";
        Set<Object> billIds = sameIdMap.keySet();
        List firstThreeBillSByCreateTime = BusinessDataServiceHelper.loadFromCache((Object[])billIds.toArray(), (String)context.getEntityType()).values().stream().sorted(Comparator.comparing(bill -> {
            Date createTime = bill.getDate("createtime");
            return createTime != null ? createTime.getTime() : -1L;
        }, Comparator.reverseOrder())).limit(3L).collect(Collectors.toList());
        DecisionFrontEndResult frontEndResult = new DecisionFrontEndResult();
        ArrayList<String> headTitleList = new ArrayList<String>();
        headTitleList.add(ResManager.loadKDString((String)"\u7591\u4f3c\u91cd\u590d\u5355\u636e\u7f16\u53f7", (String)"AlarmExecutor_4", (String)"data-idi-core", (Object[])new Object[0]));
        headTitleList.addAll(alarmConfig.getHoverSetting().stream().map(row -> StringUtils.isNotEmpty((String)row.getDisplayName()) ? row.getDisplayName() : row.getPropDisplayName()).collect(Collectors.toList()));
        frontEndResult.setHeadTitleList(headTitleList);
        ArrayList<String> headFieldNumbers = new ArrayList<String>();
        LinkedHashMap<String, List> entryNumbers = new LinkedHashMap<String, List>();
        for (AlarmHoverSettingRow alarmHoverSettingRow : alarmConfig.getHoverSetting()) {
            String propName = alarmHoverSettingRow.getPropName();
            String firstName = propName.split("\\.")[0];
            DynamicProperty firstLevelOfProperty = billType.getProperty(firstName);
            if (firstLevelOfProperty instanceof EntryProp) {
                List values = entryNumbers.computeIfAbsent(firstName, key -> new ArrayList());
                if (values.contains(propName)) continue;
                values.add(propName);
                continue;
            }
            headFieldNumbers.add(propName);
        }
        for (DynamicObject bill2 : firstThreeBillSByCreateTime) {
            Long billId = bill2.getLong("id");
            Map<String, Set<Object>> entryIdsMap = sameIdMap.get(billId);
            if (CollectionUtils.isEmpty(entryNumbers) || CollectionUtils.isEmpty(entryIdsMap)) {
                ArrayList<HoverContent> hoverContentOfRow = new ArrayList<HoverContent>(10);
                hoverContentOfRow.add(HoverContent.createHref(bill2.getString(noOrNumberField), bill2.get("id"), context.getEntityType()));
                for (AlarmHoverSettingRow alarmHoverSettingRow : alarmConfig.getHoverSetting()) {
                    String propName = alarmHoverSettingRow.getPropName();
                    if (!headFieldNumbers.contains(propName)) continue;
                    String headFieldValue = (String)ExecutorHelper.alarmGetValueAndNameByName(bill2, propName, true).getValue();
                    HoverContent headFieldHoverContent = HoverContent.createText(StringUtils.isNotEmpty((String)headFieldValue) ? headFieldValue : "");
                    hoverContentOfRow.add(headFieldHoverContent);
                }
                frontEndResult.addHoverContent(hoverContentOfRow);
                continue;
            }
            for (Map.Entry currentEntryEntry : entryNumbers.entrySet()) {
                String currentEntryNumber = (String)currentEntryEntry.getKey();
                Set<Object> sameEntryIds = entryIdsMap.get(currentEntryNumber);
                if (CollectionUtils.isEmpty(sameEntryIds)) continue;
                for (Object sameEntryId : sameEntryIds) {
                    ArrayList<HoverContent> hoverContentOfRow = new ArrayList<HoverContent>(10);
                    hoverContentOfRow.add(HoverContent.createHref(bill2.getString(noOrNumberField), bill2.get("id"), context.getEntityType()));
                    for (AlarmHoverSettingRow alarmHoverSettingRow : alarmConfig.getHoverSetting()) {
                        String propName = alarmHoverSettingRow.getPropName();
                        if (headFieldNumbers.contains(propName)) {
                            Object headFieldValue = ExecutorHelper.alarmGetValueAndNameByName(bill2, propName, true).getValue();
                            HoverContent headFieldHoverContent = HoverContent.createText(ObjectUtils.isEmpty((Object)headFieldValue) ? "" : headFieldValue.toString());
                            hoverContentOfRow.add(headFieldHoverContent);
                            continue;
                        }
                        if (currentEntryNumber.equals(propName.split("\\.")[0])) {
                            ExecutorHelper.ValueAndName entryValueAndName = ExecutorHelper.alarmGetValueAndNameByName(bill2, propName, true);
                            List values = (List)entryValueAndName.getValue();
                            List<Object> entryIds = entryValueAndName.getEntryIds();
                            Object value = null;
                            if (!CollectionUtils.isEmpty(entryIds)) {
                                value = values.get(entryIds.indexOf(sameEntryId));
                            }
                            hoverContentOfRow.add(HoverContent.createText(value != null ? value.toString() : ""));
                            continue;
                        }
                        hoverContentOfRow.add(HoverContent.createText(""));
                    }
                    frontEndResult.addHoverContent(hoverContentOfRow);
                }
            }
        }
        HashMap<String, Object> customParamMap = new HashMap<String, Object>(2);
        customParamMap.put("entityNumber", context.getEntityType());
        customParamMap.put("sameBillIds", new ArrayList<Object>(billIds));
        frontEndResult.setCustomParamMap(customParamMap);
        return frontEndResult;
    }

    private Map<Object, Map<String, Set<Object>>> checkRepetition(List<SimpleFilterRow> filterRows, Map<String, String> entryMarkMap, MainEntityType billType, DynamicObject billObj, SchemaContext context) {
        String entityName = billType.getName();
        LinkedHashMap entryMap = new LinkedHashMap(10);
        entryMap.put(entityName, new ArrayList(0));
        for (SimpleFilterRow filterRow : filterRows) {
            String fieldName = filterRow.getFieldName();
            String[] prop = fieldName.split("\\.");
            String key = entityName;
            for (String s : prop) {
                if (entryMarkMap.get(s) == null) continue;
                key = entryMarkMap.get(s);
                break;
            }
            if (entryMap.get(key) == null) {
                entryMap.put(key, new ArrayList<SimpleFilterRow>(Collections.singletonList(filterRow)));
                continue;
            }
            ((List)entryMap.get(key)).add(filterRow);
        }
        String billStatusField = billType instanceof BillEntityType ? ((BillEntityType)billType).getBillStatus() : null;
        IDataEntityType currentBillType = billObj.getDataEntityType();
        Map fieldMap = null;
        if (currentBillType instanceof MainEntityType) {
            fieldMap = ((MainEntityType)currentBillType).getAllFields();
        }
        Map<Object, Map<String, Set<Object>>> lastSameIdMap = new HashMap<Object, Map<String, Set<Object>>>(10);
        for (Map.Entry entry : entryMap.entrySet()) {
            if (entry.getValue() == null || ((List)entry.getValue()).isEmpty()) continue;
            boolean mainType = entityName.equals(entry.getKey());
            Map<Object, Map<String, Set<Object>>> tempSameIdMap = this.checkSameEntityIds((List)entry.getValue(), billStatusField, billObj, fieldMap, billType, mainType, context, lastSameIdMap.keySet(), (String)entry.getKey());
            if (tempSameIdMap.isEmpty()) {
                lastSameIdMap = tempSameIdMap;
                break;
            }
            if (!mainType) {
                for (Map.Entry<Object, Map<String, Set<Object>>> mapEntry : tempSameIdMap.entrySet()) {
                    Map<String, Set<Object>> lastMap = lastSameIdMap.get(mapEntry.getKey());
                    if (lastMap == null) continue;
                    mapEntry.getValue().putAll(lastMap);
                }
            }
            lastSameIdMap = tempSameIdMap;
        }
        return lastSameIdMap;
    }

    private Map<Object, Map<String, Set<Object>>> checkSameEntityIds(List<SimpleFilterRow> filterRows, String billStatusField, DynamicObject billObj, Map<String, IDataEntityProperty> fieldMap, MainEntityType billType, boolean mainType, SchemaContext context, Set<Object> lastSameIds, String entityName) {
        HashMap<Object, Map<String, Set<Object>>> sameIdMap = new HashMap<Object, Map<String, Set<Object>>>(10);
        HashMap<String, List> entryValueMap = new HashMap<String, List>(10);
        int entryCount = 0;
        HashSet<String> similarProps = new HashSet<String>();
        int index = 0;
        while (index < filterRows.size()) {
            SimpleFilterRow filterRow = filterRows.get(index);
            String fieldName = filterRow.getFieldName();
            if (StringUtils.isNotEmpty((String)billStatusField) && billStatusField.equals(fieldName)) {
                ++index;
                continue;
            }
            String fullFieldName = this.getFullFieldName(fieldName, fieldMap, billType.getName());
            Object fieldValue = ExecutorHelper.alarmGetValueAndNameByName(billObj, fullFieldName, false).getValue();
            SchemaExecutorLogger.info("field:" + fieldName + ", value:" + fieldValue, new Object[0]);
            if (mainType) {
                if ("SIMILAR".equals(filterRow.getCompareType())) {
                    similarProps.add(filterRow.getFieldName());
                    filterRows.remove(index);
                    --index;
                } else {
                    this.constrcutFilterRow(filterRow, fieldValue);
                }
            } else if (fieldValue instanceof List) {
                entryValueMap.put(fieldName, (List)fieldValue);
                entryCount = ((List)fieldValue).size();
                if (entryCount == 0) {
                    Map allEntities = billType.getAllEntities();
                    if (fullFieldName != null) {
                        EntityType entityType = (EntityType)allEntities.get(fullFieldName.split("\\.")[0]);
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55: %s\u4e0d\u5b58\u5728\u5206\u5f55\u884c\uff0c\u65e0\u6cd5\u8fdb\u884c\u4e8b\u4ef6\u91cd\u590d\u68c0\u67e5\u3002", (String)"AlarmExecutor_5", (String)"data-idi-core", (Object[])new Object[0]), entityType.getDisplayName()));
                    }
                }
            }
            ++index;
        }
        QFilter totalFilter = null;
        if (!mainType) {
            ArrayList<String> entryFieldValueList = new ArrayList<String>(Math.max(10, entryCount));
            for (int i = 0; i < entryCount; ++i) {
                StringBuilder fieldValueSb = new StringBuilder();
                List collect = filterRows.stream().map(SimpleFilterRow::clone).collect(Collectors.toList());
                for (SimpleFilterRow filterRow : collect) {
                    Object value = ((List)entryValueMap.get(filterRow.getFieldName())).get(i);
                    fieldValueSb.append(filterRow.getFieldName()).append("-").append((Object)(value == null ? "" : value)).append(",");
                    this.constrcutFilterRow(filterRow, value);
                }
                if (entryFieldValueList.contains(fieldValueSb.toString())) continue;
                entryFieldValueList.add(fieldValueSb.toString());
                FilterCondition filterCondition = new FilterCondition();
                filterCondition.setFilterRow(collect);
                FilterBuilder filterBuilder = new FilterBuilder(billType, filterCondition);
                try {
                    filterBuilder.buildFilter(false);
                }
                catch (Exception ex) {
                    SchemaExecutorLogger.error(IDIJSONUtils.toJsonString((Object)filterCondition), ex);
                    filterBuilder.setQFilter(null);
                }
                QFilter qFilter = filterBuilder.getQFilter();
                if (qFilter == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672a\u80fd\u7b5b\u9009\u51fa\u5386\u53f2\u5bf9\u6bd4\u5355\u636e", (String)"AlarmExecutor_1", (String)"data-idi-core", (Object[])new Object[0]));
                }
                totalFilter = totalFilter == null ? qFilter : FilterUtil.combineFilter((QFilter)totalFilter, (QFilter)qFilter, (LogicOperate)LogicOperate.OR);
            }
        } else {
            FilterCondition filterCondition = new FilterCondition();
            filterCondition.setFilterRow(filterRows);
            FilterBuilder filterBuilder = new FilterBuilder(billType, filterCondition);
            try {
                filterBuilder.buildFilter(false);
            }
            catch (Exception ex) {
                SchemaExecutorLogger.error(IDIJSONUtils.toJsonString((Object)filterCondition), ex);
                filterBuilder.setQFilter(null);
            }
            totalFilter = filterBuilder.getQFilter();
            if (totalFilter == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u80fd\u7b5b\u9009\u51fa\u5386\u53f2\u5bf9\u6bd4\u5355\u636e", (String)"AlarmExecutor_1", (String)"data-idi-core", (Object[])new Object[0]));
            }
        }
        if (context.getBillId() != null) {
            QFilter ignoreSelfBill = new QFilter(billType.getPrimaryKey().getName(), "!=", (Object)context.getBillId());
            totalFilter = FilterUtil.combineFilter((QFilter)ignoreSelfBill, (QFilter)totalFilter);
        }
        if (lastSameIds != null && !lastSameIds.isEmpty()) {
            totalFilter = FilterUtil.combineFilter((QFilter)totalFilter, (QFilter)new QFilter(billType.getPrimaryKey().getName(), "in", lastSameIds));
        }
        String noOrNumberField = billType instanceof BasedataEntityType ? "number" : "billno";
        StringBuilder selectProperties = new StringBuilder(noOrNumberField);
        for (String similarProp : similarProps) {
            selectProperties.append(',').append(similarProp);
        }
        String entryName = null;
        if (!mainType) {
            entryName = entityName + ".id";
            selectProperties.append(',').append(entryName);
        }
        selectProperties.append(',').append("id");
        if (totalFilter == null) {
            return Collections.emptyMap();
        }
        DynamicObjectCollection sameBillList = QueryServiceHelper.query((String)context.getEntityType(), (String)selectProperties.toString(), (QFilter[])new QFilter[]{totalFilter});
        SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u91cd\u590d\u5355\u636e\u8fc7\u6ee4\u6761\u4ef6\uff1a%s", (String)"AlarmExecutor_2", (String)"data-idi-core", (Object[])new Object[0]), totalFilter), new Object[0]);
        SchemaExecutorLogger.info("checkSameEntityIds match count:" + (sameBillList == null ? 0 : sameBillList.size()), new Object[0]);
        if (sameBillList != null && !sameBillList.isEmpty()) {
            if (!similarProps.isEmpty()) {
                List<Integer> similarTextList = this.similar(similarProps, billObj, sameBillList);
                if (!similarTextList.isEmpty()) {
                    for (Integer integer : similarTextList) {
                        DynamicObject sameBill = (DynamicObject)sameBillList.get(integer.intValue());
                        sameIdMap.put(sameBill.get("id"), new HashMap(0));
                    }
                }
            } else {
                for (DynamicObject sameBill : sameBillList) {
                    Object pkId = sameBill.get("id");
                    if (mainType) {
                        sameIdMap.put(pkId, new HashMap(0));
                        continue;
                    }
                    Object value = sameBill.get(entryName);
                    if (ZERO.equals(value)) continue;
                    HashMap<String, HashSet<Object>> entryMap = (HashMap<String, HashSet<Object>>)sameIdMap.get(pkId);
                    if (entryMap == null) {
                        entryMap = new HashMap<String, HashSet<Object>>(6);
                        entryMap.put(entityName, new HashSet<Object>(Collections.singletonList(value)));
                        sameIdMap.put(pkId, entryMap);
                        continue;
                    }
                    if (entryMap.get(entityName) == null) {
                        entryMap.put(entityName, new HashSet<Object>(Collections.singletonList(value)));
                        continue;
                    }
                    ((Set)entryMap.get(entityName)).add(value);
                }
            }
        }
        SchemaExecutorLogger.info("checkSameEntityIds result match count:" + sameIdMap.size(), new Object[0]);
        return sameIdMap;
    }

    private void constrcutFilterRow(SimpleFilterRow filterRow, Object fieldValue) {
        Pattern pattern = Pattern.compile("^IDI_BETWEEN_([0-9]+)([MWC])$");
        DateFormat dateFormat = KDDateFormatUtils.getDateTimeFormat();
        Matcher matcher = pattern.matcher(filterRow.getCompareType());
        if (matcher.matches()) {
            if (fieldValue instanceof Date) {
                Date beginDate;
                Date endDate = (Date)fieldValue;
                filterRow.setCompareType(CompareTypeEnum.BETWEEN.getId());
                String d = matcher.group(1);
                String t = matcher.group(2);
                int dt = 1;
                if (!StringUtils.isEmpty((String)d)) {
                    try {
                        dt = Integer.parseInt(d);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if ("M".equals(t)) {
                    beginDate = KDDateUtils.addMonths((Date)endDate, (int)(-1 * dt));
                } else if ("W".equals(filterRow.getCompareType())) {
                    beginDate = KDDateUtils.addWeeks((Date)endDate, (int)(-1 * dt));
                } else if ("C".equals(t)) {
                    beginDate = IDIDateUtils.getTheMonthStartTime((Date)endDate);
                    endDate = IDIDateUtils.getTheMonthEndTime((Date)endDate);
                } else {
                    beginDate = KDDateUtils.addDays((Date)endDate, (int)-1);
                }
                ArrayList<FilterValue> fvList = new ArrayList<FilterValue>();
                FilterValue filterValue = new FilterValue();
                filterValue.setValue((Object)dateFormat.format(beginDate));
                fvList.add(filterValue);
                filterValue = new FilterValue();
                filterValue.setValue((Object)dateFormat.format(endDate));
                fvList.add(filterValue);
                filterRow.setValue(fvList);
            } else if (fieldValue == null || fieldValue instanceof OrmLocaleValue && fieldValue.toString() == null) {
                filterRow.setCompareType(CompareTypeEnum.ISNULL.getId());
                filterRow.setValue(Collections.emptyList());
            } else {
                filterRow.setCompareType(CompareTypeEnum.EQUAL.getId());
                FilterValue filterValue = new FilterValue();
                filterValue.setValue((Object)fieldValue.toString());
                filterRow.setValue(Collections.singletonList(filterValue));
            }
        } else if (!(CompareTypeEnum.TODAY.getId().equals(filterRow.getCompareType()) || CompareTypeEnum.YESTERDAY.getId().equals(filterRow.getCompareType()) || CompareTypeEnum.LESS.getId().equals(filterRow.getCompareType()) || CompareTypeEnum.LESSOREQUAL.getId().equals(filterRow.getCompareType()) || CompareTypeEnum.GREATER.getId().equals(filterRow.getCompareType()) || CompareTypeEnum.GREATEROREQUAL.getId().equals(filterRow.getCompareType()))) {
            if (fieldValue == null || fieldValue instanceof String && StringUtils.isEmpty((String)((String)fieldValue)) || fieldValue instanceof OrmLocaleValue && fieldValue.toString() == null) {
                filterRow.setCompareType(CompareTypeEnum.ISNULL.getId());
                filterRow.setValue(Collections.emptyList());
            } else {
                Object value;
                FilterValue filterValue = new FilterValue();
                if (fieldValue instanceof List) {
                    List mulValueList = (List)fieldValue;
                    if (mulValueList.isEmpty()) {
                        String error = ResManager.loadKDString((String)"%s\u4e0d\u5b58\u5728\u503c", (String)"AlarmExecutor_3", (String)"data-idi-core", (Object[])new Object[0]);
                        throw new KDBizException(String.format(error, filterRow.getFieldName()));
                    }
                    value = mulValueList.get(0);
                } else {
                    value = fieldValue;
                }
                filterValue.setValue((Object)value.toString());
                filterRow.setValue(Collections.singletonList(filterValue));
            }
        }
    }

    private String getFullFieldName(String fieldName, Map<String, IDataEntityProperty> fieldMap, String entityNumber) {
        if (fieldMap == null || fieldMap.isEmpty() || StringUtils.isEmpty((String)fieldName)) {
            return fieldName;
        }
        String onlyField = fieldName.indexOf(46) > 0 ? fieldName.substring(0, fieldName.indexOf(46)) : fieldName;
        String fullFieldName = fieldName;
        IDataEntityProperty property = fieldMap.get(onlyField);
        for (IDataEntityType entityType = property.getParent(); entityType != null && !entityNumber.equals(entityType.getName()); entityType = entityType.getParent()) {
            fullFieldName = entityType.getName() + "." + fullFieldName;
        }
        return fullFieldName;
    }

    private List<Integer> similar(Set<String> similarProps, DynamicObject billObj, DynamicObjectCollection sameBillList) {
        ArrayList<Integer> similarTextSeqList = new ArrayList<Integer>(10);
        for (String similarProp : similarProps) {
            List<String> theBillValues = this.getPropValues(billObj, similarProp);
            ArrayList<String> textList = new ArrayList<String>();
            for (DynamicObject sameBill : sameBillList) {
                String val = sameBill.getString(similarProp);
                textList.add(val);
            }
            for (String text : theBillValues) {
                List<Integer> similarTextSeqs = ISimilarService.getInstance().textSimilar(text, textList);
                if (similarTextSeqs == null || similarTextSeqs.isEmpty()) continue;
                if (similarTextSeqList.isEmpty()) {
                    similarTextSeqList.addAll(similarTextSeqs);
                    continue;
                }
                similarTextSeqList.retainAll(similarTextSeqs);
            }
        }
        return similarTextSeqList;
    }

    private List<String> getPropValues(DynamicObject billObj, String similarProp) {
        ArrayList<String> theBillValues = new ArrayList<String>();
        Object value = ExecutorHelper.alarmGetValueAndNameByName(billObj, similarProp, false).getValue();
        if (value instanceof List) {
            List objs = (List)value;
            for (Object val : objs) {
                String valStr = val.toString();
                if (!StringUtils.isNotEmpty((String)valStr)) continue;
                theBillValues.add(valStr);
            }
        } else {
            String valueStr;
            String string = valueStr = value == null ? null : value.toString();
            if (StringUtils.isNotEmpty((String)valueStr)) {
                theBillValues.add(valueStr);
            }
        }
        return theBillValues;
    }

    public Map<Object, Map<String, Set<Object>>> logicCalculate(Map<Object, Map<String, Set<Object>>> leftMap, Map<Object, Map<String, Set<Object>>> rightMap, String logic) {
        Map<Object, Map<String, Set<Object>>> result = new HashMap<Object, Map<String, Set<Object>>>(10);
        if (leftMap != null && rightMap != null) {
            SchemaExecutorLogger.info(String.format("leftMap count: %1$s , rightMap count: %2$s, Logic : %3$s", leftMap.size(), rightMap.size(), logic), new Object[0]);
            if ("1".equals(logic)) {
                for (Map.Entry<Object, Map<String, Set<Object>>> entry : leftMap.entrySet()) {
                    if (rightMap.get(entry.getKey()) == null || rightMap.get(entry.getKey()).isEmpty()) {
                        rightMap.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    Map<String, Set<Object>> entryMap = rightMap.get(entry.getKey());
                    for (Map.Entry<String, Set<Object>> entityEntry : entry.getValue().entrySet()) {
                        if (entryMap.get(entityEntry.getKey()) == null) {
                            entryMap.put(entityEntry.getKey(), entityEntry.getValue());
                            continue;
                        }
                        entryMap.get(entityEntry.getKey()).addAll((Collection<Object>)entityEntry.getValue());
                    }
                }
                result = rightMap;
            } else if ("0".equals(logic)) {
                result = new HashMap(10);
                for (Map.Entry<Object, Map<String, Set<Object>>> entry : leftMap.entrySet()) {
                    if (!rightMap.containsKey(entry.getKey())) continue;
                    Map<String, Set<Object>> rightEntryMap = rightMap.get(entry.getKey());
                    if (rightEntryMap == null || rightEntryMap.isEmpty()) {
                        result.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    Map<String, Set<Object>> leftEntryMap = entry.getValue();
                    if (leftEntryMap != null) {
                        for (Map.Entry<String, Set<Object>> leftEntry : leftEntryMap.entrySet()) {
                            String entityNumber = leftEntry.getKey();
                            if (rightEntryMap.containsKey(entityNumber)) {
                                rightEntryMap.get(entityNumber).retainAll((Collection)leftEntry.getValue());
                                continue;
                            }
                            rightEntryMap.put(entityNumber, leftEntry.getValue());
                        }
                    }
                    result.put(entry.getKey(), rightEntryMap);
                }
            }
        }
        return result;
    }

    public DecisionResult notMatchStartCondition(Decision decision, DeductionGrade deductionGrade) {
        SchemaExecutorLogger.info(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u542f\u52a8\u6761\u4ef6\uff01", (String)"LinkUpBillDecisionExecutor_7", (String)"data-idi-core", (Object[])new Object[0]), new Object[0]);
        AlarmConfig alarmConfig = decision.getAlarm();
        boolean isPass = DeductionGradeConfigUtil.findDeductionGradeConfigPass(alarmConfig.getDeductionGradeConfigList(), DeductionGradeConfig.DeductionGradeItem.STARTCONDITION_NOTMATCH);
        DecisionResult decisionResult = new DecisionResult();
        decisionResult.setStatus(isPass ? "empty" : "alarming");
        decisionResult.setShowText(ResManager.loadKDString((String)"\u542f\u52a8\u6761\u4ef6\u4e0d\u6ee1\u8db3", (String)"ExceptionTipEnum_2", (String)"data-idi-core", (Object[])new Object[0]));
        deductionGrade.deduct(alarmConfig.getDeductionGradeConfigList(), DeductionGradeConfig.DeductionGradeItem.STARTCONDITION_NOTMATCH);
        decisionResult.setDeductPercent(deductionGrade.getValue());
        decisionResult.setDecision(decision);
        return decisionResult;
    }
}

