/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.cache.IAppCache;

public class CacheManager {
    private static final String IDI_CHECK = "IDI_CHECK";

    private static IAppCache getLocalCache() {
        return AppCache.get((String)"kd.data.idi.engine.CacheManager");
    }

    public static String makeCacheKey(String type, String key) {
        return CacheKeyUtil.getAcctId() + ".data-idi." + type + "." + key;
    }

    public static void put(String type, String key, String val) {
        CacheManager.getLocalCache().put(CacheManager.makeCacheKey(type, key), (Object)val, 300);
    }

    public static String get(String type, String key) {
        return (String)CacheManager.getLocalCache().get(CacheManager.makeCacheKey(type, key), String.class);
    }

    public static void del(String type, String key) {
        CacheManager.getLocalCache().remove(CacheManager.makeCacheKey(type, key));
    }

    public static void put(String type, String key, String val, int invalid) {
        CacheManager.getLocalCache().put(CacheManager.makeCacheKey(type, key), (Object)val, invalid);
    }

    public static LocalMemoryCache getLocalMemoryCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(1200);
        info.setMaxMemSize(10000);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), IDI_CHECK, info);
    }
}

