/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.math.BigDecimal;
import java.util.List;
import kd.data.idi.data.AnalysisMode;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.DeductionGradeConfig;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.engine.SchemaExecutorLogger;

public class DeductionGrade {
    private BigDecimal value = null;
    private boolean isNeedDeductGrade;

    public DeductionGrade(SchemaContext context) {
        this.isNeedDeductGrade = AnalysisMode.SCORE.getType().equals(context.getSchema().getAnalysisMode());
        if (this.isNeedDeductGrade) {
            this.value = BigDecimal.ZERO;
        }
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public BigDecimal deductPercent(int rulePercent, BigDecimal percent) {
        BigDecimal ruleDeductionGrade = BigDecimal.ZERO;
        if (this.isNeedDeductGrade) {
            ruleDeductionGrade = BigDecimal.valueOf(rulePercent, 0).multiply(percent, DecisionResult.DECIMAL4).divide(DecisionResult.HUNDRED, DecisionResult.DECIMAL4);
            SchemaExecutorLogger.info("deduction Grade percent\uff1a%s", ruleDeductionGrade.toPlainString());
            this.value = this.value.add(ruleDeductionGrade);
        }
        return ruleDeductionGrade;
    }

    public void deduct(BigDecimal deductionGrade) {
        if (this.isNeedDeductGrade) {
            SchemaExecutorLogger.info("deduction Grade percent\uff1a%s", deductionGrade.toPlainString());
            this.value = this.value.add(deductionGrade);
        }
    }

    public void deductNegate(BigDecimal deductionGrade) {
        if (this.isNeedDeductGrade && deductionGrade != null) {
            SchemaExecutorLogger.info("deductionNegate Grade percent\uff1a%s", deductionGrade.negate().toPlainString());
            this.value = this.value.add(deductionGrade.negate());
        }
    }

    public void deduct(int deductionGrade) {
        if (this.isNeedDeductGrade) {
            SchemaExecutorLogger.info("deduction Grade percent\uff1a%s", deductionGrade);
            this.value = this.value.add(new BigDecimal(deductionGrade, DecisionResult.DECIMAL4));
        }
    }

    public void deduct(List<DeductionGradeConfig> deductionGradeConfigList, DeductionGradeConfig.DeductionGradeItem item) {
        if (!this.isNeedDeductGrade) {
            return;
        }
        if (deductionGradeConfigList == null || deductionGradeConfigList.isEmpty()) {
            return;
        }
        for (DeductionGradeConfig config : deductionGradeConfigList) {
            if (!config.getItem().getType().equals(item.getType())) continue;
            this.deduct(config.getPercent());
            break;
        }
    }

    public void deduct(List<DeductionGradeConfig> deductionGradeConfigList, DeductionGradeConfig.DeductionGradeItem item, BigDecimal percent) {
        if (!this.isNeedDeductGrade) {
            return;
        }
        if (deductionGradeConfigList == null || deductionGradeConfigList.isEmpty()) {
            return;
        }
        for (DeductionGradeConfig config : deductionGradeConfigList) {
            if (!config.getItem().getType().equals(item.getType())) continue;
            this.deductPercent(config.getPercent(), percent);
            break;
        }
    }
}

