/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.mservice.result.ServiceResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class FasindexHelper {
    public static List<Long> getDimensionFromFsaindex(long fsaindexId, long useOrgId) {
        ArrayList<Long> idList = new ArrayList<Long>(2);
        Map map = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"faf", (String)"FAFIndexCalculateService", (String)"querySelectableGroupDimensions", (Object[])new Object[]{fsaindexId, useOrgId});
        if (map == null || map.isEmpty()) {
            return idList;
        }
        List dimensionList = (List)map.get("alldimenisons");
        if (dimensionList == null || dimensionList.isEmpty()) {
            return idList;
        }
        for (DynamicObject obj : dimensionList) {
            idList.add(obj.getLong("id"));
        }
        return idList;
    }

    public static Map<String, Object> commitComparisonCalculate(long fsaPkValue, Map<Long, Object[]> params, Map<String, Object> comparison) {
        return (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"faf", (String)"FAFIndexCalculateService", (String)"commitComparisonCalculate", (Object[])new Object[]{fsaPkValue, params, comparison});
    }

    public static Long dateConvertPeriod(Long dimensionId, Date date) {
        ServiceResult result = (ServiceResult)DispatchServiceHelper.invokeBizService((String)"macc", (String)"faf", (String)"FAFDimensionService", (String)"queryPeriodValueIdByDimensionId", (Object[])new Object[]{date, dimensionId});
        return (Long)result.getData();
    }

    public static Map<Date, Long> dateConvertPeriod(Long dimensionId, List<Date> dateList) {
        ServiceResult result = (ServiceResult)DispatchServiceHelper.invokeBizService((String)"macc", (String)"faf", (String)"FAFDimensionService", (String)"queryPeriodIdMapByDimensionId", (Object[])new Object[]{dimensionId, dateList});
        return (Map)result.getData();
    }

    public static Set<Long> samePeriodOnPreviousYear(Long dimensionId, Object[] currentPeriod) {
        HashSet<Long> samePeriodSet = new HashSet<Long>(currentPeriod.length);
        ServiceResult result = (ServiceResult)DispatchServiceHelper.invokeBizService((String)"macc", (String)"faf", (String)"FAFDimensionService", (String)"queryLastYearPeriodMap", (Object[])new Object[]{dimensionId, Arrays.asList(currentPeriod)});
        Map resultMap = (Map)result.getData();
        samePeriodSet.addAll(resultMap.values());
        return samePeriodSet;
    }

    public static Set<Long> previousPeriod(Long dimensionId, Object[] currentPeriod) {
        HashSet<Long> previousPeriodSet = new HashSet<Long>(currentPeriod.length);
        ServiceResult result = (ServiceResult)DispatchServiceHelper.invokeBizService((String)"macc", (String)"faf", (String)"FAFDimensionService", (String)"queryLastPeriodMap", (Object[])new Object[]{dimensionId, Arrays.asList(currentPeriod)});
        Map resultMap = (Map)result.getData();
        previousPeriodSet.addAll(resultMap.values());
        return previousPeriodSet;
    }

    public static Map<Object, Object> queryDimensionValueDisplay(DynamicObject dimension, Set<Object> valueSet) {
        String dimensionType;
        HashMap<Object, Object> map = new HashMap<Object, Object>(valueSet.size());
        String baseEntityId = null;
        switch (dimensionType = dimension.getString("dimensiontype")) {
            case "1": 
            case "4": {
                DynamicObject dimensionSource = dimension.getDynamicObject("dimensionsource");
                baseEntityId = dimensionSource.getString("number");
                break;
            }
            case "2": {
                baseEntityId = "bos_assistantdata_detail";
            }
        }
        if (StringUtils.isNotEmpty((String)baseEntityId)) {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryDimensionValueDisplay", (String)baseEntityId, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", valueSet)}, null);){
                for (Row row : dataSet) {
                    map.put(row.getLong("id"), row.getString("name"));
                }
            }
        }
        return map;
    }

    public static Map<Object, DynamicObject> queryDimension(Set<Long> dimensionIdSet) {
        return BusinessDataServiceHelper.loadFromCache((Object[])dimensionIdSet.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pa_dimension"));
    }

    public static QFilter queryDimensionQFilter(Long dimensionId) {
        DynamicObject dimension = BusinessDataServiceHelper.loadSingle((Object)dimensionId, (String)"pa_dimension");
        String property = dimension.getString("typefield");
        Object groupId = dimension.get("group_id");
        return StringUtils.isEmpty((String)property) ? null : new QFilter(property, "=", groupId);
    }
}

