/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.data.idi.data.BillInfo;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.HoverContent;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.data.TableDataResult;
import kd.data.idi.data.TimeLine;
import kd.data.idi.engine.DecisionExecutor;
import kd.data.idi.engine.ExecutorHelper;

public class FutureExecutor
implements DecisionExecutor {
    /*
     * WARNING - void declaration
     */
    @Override
    public DecisionResult execute(SchemaContext context, Decision decision) {
        BillInfo matchBill;
        TimeLine timeLine = decision.getTimeLine();
        if (timeLine == null) {
            return null;
        }
        DynamicObject billObj = null;
        Map<String, HashSet<Long>> linkUpBillIds = ExecutorHelper.getLinkUpBills(context.getBillId(), context.getEntityType());
        HashSet<Long> matchBillIds = linkUpBillIds.get((matchBill = decision.getMatchBill()).getEntityNumber());
        if (matchBillIds != null && matchBillIds.size() > 0) {
            Long billId = matchBillIds.iterator().next();
            HashSet<String> propSet = new HashSet<String>();
            timeLine.extractProperties(propSet, matchBill.getEntityNumber());
            billObj = ExecutorHelper.loadObject(billId, matchBill.getEntityNumber(), propSet);
        }
        DecisionResult decisionResult = new DecisionResult();
        decisionResult.setDecision(decision);
        if (billObj != null) {
            Object valueStr;
            String content;
            int i;
            ArrayList<HoverContent> fieldValueList;
            List list;
            Object value;
            ExecutorHelper.ValueAndName valueAndName;
            TableDataResult tableDataResult = new TableDataResult();
            tableDataResult.setTitle(decision.getName());
            decisionResult.setTableDataResult(tableDataResult);
            ArrayList<List<HoverContent>> billData = new ArrayList<List<HoverContent>>();
            List<HoverContent> remarkData = null;
            int maxRow = 0;
            for (String field : timeLine.getRowFields()) {
                valueAndName = ExecutorHelper.getValueAndNameByName(billObj, field, true);
                value = valueAndName.getValue();
                if (value instanceof List) {
                    list = (List)value;
                    List list2 = (List)valueAndName.getRefValue();
                    fieldValueList = new ArrayList<HoverContent>(list.size());
                    for (i = 0; i < list.size(); ++i) {
                        content = list.get(i) == null ? " " : list.get(i).toString();
                        fieldValueList.add(valueAndName.isUser() ? HoverContent.createChat(content, list2.get(i)) : HoverContent.createText(content));
                    }
                    billData.add(fieldValueList);
                    if (list.size() <= maxRow) continue;
                    maxRow = list.size();
                    continue;
                }
                valueStr = value == null ? " " : value.toString();
                billData.add(Collections.singletonList(valueAndName.isUser() ? HoverContent.createChat((String)valueStr, valueAndName.getRefValue()) : HoverContent.createText((String)valueStr)));
                if (true <= maxRow) continue;
                maxRow = 1;
            }
            BillEntityType billEntityType = (BillEntityType)billObj.getDataEntityType();
            if (StringUtils.isNotEmpty((String)timeLine.getRemark())) {
                boolean isBillNo = timeLine.getRemark().equalsIgnoreCase(billEntityType.getBillNo());
                valueAndName = ExecutorHelper.getValueAndNameByName(billObj, timeLine.getRemark(), true);
                value = valueAndName.getValue();
                if (value instanceof List) {
                    list = (List)value;
                    List list3 = (List)valueAndName.getRefValue();
                    fieldValueList = new ArrayList(list.size());
                    for (i = 0; i < list.size(); ++i) {
                        String string = content = list.get(i) == null ? " " : list.get(i).toString();
                        fieldValueList.add(valueAndName.isUser() ? HoverContent.createChat(content, list3.get(i)) : (isBillNo ? HoverContent.createHref(content, billObj) : HoverContent.createText(content)));
                    }
                    remarkData = fieldValueList;
                } else {
                    Object object = valueStr = value == null ? " " : value.toString();
                    remarkData = Collections.singletonList(valueAndName.isUser() ? HoverContent.createChat((String)valueStr, valueAndName.getRefValue()) : (isBillNo ? HoverContent.createHref((String)valueStr, billObj) : HoverContent.createText((String)valueStr)));
                }
                if (remarkData.size() > maxRow) {
                    maxRow = remarkData.size();
                }
            }
            for (int i2 = 0; i2 < maxRow; ++i2) {
                void var15_26;
                HoverContent val;
                ArrayList<HoverContent> rowData = new ArrayList<HoverContent>(billData.size());
                int notEmptyCount = 0;
                for (List list4 : billData) {
                    HoverContent s;
                    HoverContent val2;
                    HoverContent hoverContent = val2 = list4.size() > i2 ? (HoverContent)list4.get(i2) : null;
                    if (val2 == null) {
                        s = HoverContent.createText(" ");
                    } else {
                        ++notEmptyCount;
                        s = val2;
                    }
                    rowData.add(s);
                }
                if (notEmptyCount == 0) continue;
                tableDataResult.addData(rowData);
                HoverContent hoverContent = val = remarkData != null && remarkData.size() > i2 ? remarkData.get(i2) : null;
                if (val == null) {
                    HoverContent hoverContent2 = HoverContent.createText(" ");
                } else {
                    HoverContent hoverContent3 = val;
                }
                tableDataResult.addPopover((HoverContent)var15_26);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u672a\u627e\u5230", (String)"FutureExecutor_0", (String)"data-idi-core", (Object[])new Object[0]));
        }
        return decisionResult;
    }
}

