/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.GeneralLedger;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.data.StatisticsResult;
import kd.data.idi.engine.DecisionExecutor;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.ScriptFormIdHandler;
import kd.data.idi.engine.ScriptLocaleFieldHandler;
import kd.data.idi.engine.ScriptUtils;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.IDIStringUtils;

public class GeneralLedgerExecutor
implements DecisionExecutor {
    private Set<String> balanceFields = new HashSet<String>(){
        private static final long serialVersionUID = -6545388749618009605L;
        {
            this.add("account");
            this.add("assgrp");
            this.add("currency");
            this.add("beginfor");
            this.add("debitfor");
            this.add("creditfor");
            this.add("endfor");
            this.add("beginlocal");
            this.add("debitlocal");
            this.add("creditlocal");
            this.add("endlocal");
            this.add("yeardebitfor");
            this.add("yeardebitlocal");
            this.add("yearcreditfor");
            this.add("yearcreditlocal");
            this.add("beginqty");
            this.add("debitqty");
            this.add("creditqty");
            this.add("endqty");
            this.add("yeardebitqty");
            this.add("yearcreditqty");
        }
    };

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public DecisionResult execute(SchemaContext context, Decision decision) {
        Object supplierId;
        String asstactType;
        HashMap<String, Object> param;
        GeneralLedger generalLedger;
        block24: {
            block23: {
                Long period;
                generalLedger = decision.getGeneralLedger();
                DynamicObject selfBill = ExecutorHelper.getSelfBill(context);
                if (selfBill != null && selfBill.getPkValue() != null && !this.checkStartCondition(generalLedger.getStartCondition(), context, selfBill.getPkValue())) {
                    DecisionResult result = new DecisionResult();
                    result.setStatus("empty");
                    result.setDecision(decision);
                    result.setShowText(String.format(ResManager.loadKDString((String)"%s : \u542f\u52a8\u6761\u4ef6\u4e0d\u6ee1\u8db3", (String)"GeneralLedgerExecutor_7", (String)"data-idi-core", (Object[])new Object[0]), decision.getName()));
                    return result;
                }
                String orgField = generalLedger.getOrgField();
                Object openOrgId = ExecutorHelper.getValueByName(selfBill, orgField, false);
                if (openOrgId != null && !(openOrgId instanceof Number) && orgField.contains(".")) {
                    openOrgId = ExecutorHelper.getParentObjectIdByName(selfBill, orgField);
                }
                if (openOrgId instanceof DynamicObject) {
                    openOrgId = ((DynamicObject)openOrgId).get("masterid");
                }
                if (!(openOrgId instanceof Number) || ((Number)openOrgId).intValue() == 0) {
                    SchemaExecutorLogger.error("open org id error![" + orgField + "][" + openOrgId + "]");
                    throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"GeneralLedgerExecutor_1", (String)"data-idi-core", (Object[])new Object[0]));
                }
                DynamicObject accountTable = this.getAccountTable((Number)openOrgId, generalLedger.getBookTypeId());
                if (accountTable == null) {
                    SchemaExecutorLogger.error("account table not found![" + openOrgId + "][" + generalLedger.getBookTypeId() + "]");
                    throw new KDBizException(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u4e0d\u5b58\u5728", (String)"GeneralLedgerExecutor_2", (String)"data-idi-core", (Object[])new Object[0]));
                }
                param = new HashMap<String, Object>();
                param.put("orgId", openOrgId);
                param.put("bookTypeId", generalLedger.getBookTypeId());
                param.put("currencyId", generalLedger.getCurrencyId());
                param.put("accountTableId", accountTable.getLong("accountTableId"));
                Long periodType = accountTable.getLong("periodTypeId");
                if (periodType <= 0L) {
                    periodType = 1L;
                }
                if ((period = this.getCurrentPeriodByDate(periodType)) == null) {
                    SchemaExecutorLogger.error("period is empty");
                    throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u8d26\u7c3f\u7c7b\u578b\u4e0a\u7684\u671f\u95f4\u7c7b\u578b\u4e0e\u5f53\u524d\u65e5\u671f\uff0c\u83b7\u5f97\u7684\u671f\u95f4\u4e3a\u7a7a", (String)"GeneralLedgerExecutor_3", (String)"data-idi-core", (Object[])new Object[0]));
                }
                param.put("periodId", String.valueOf(period));
                asstactType = generalLedger.getAsstactTypeFlexField();
                if (StringUtils.isEmpty((String)asstactType)) {
                    SchemaExecutorLogger.error("asstactType is empty");
                    throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u5b58\u5728", (String)"GeneralLedgerExecutor_4", (String)"data-idi-core", (Object[])new Object[0]));
                }
                supplierId = ExecutorHelper.getValueByName(selfBill, generalLedger.getFieldNumber(), false);
                if (supplierId instanceof DynamicObject) {
                    supplierId = ((DynamicObject)supplierId).get("masterid");
                }
                if (!(supplierId instanceof String)) break block23;
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bd_asstacttype", (String)"flexfield,valuetype,valuesource.number", (QFilter[])new QFilter[]{new QFilter("flexfield", "=", (Object)asstactType)});
                if (dynamicObject == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u5b58\u5728", (String)"GeneralLedgerExecutor_4", (String)"data-idi-core", (Object[])new Object[0]));
                }
                String entityNumber = dynamicObject.getString("valuesource.number");
                String valueType = dynamicObject.getString("valuetype");
                if ("1".equals(valueType) && StringUtils.isNotEmpty((String)entityNumber)) {
                    MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                    Class primaryType = mainEntityType.getPrimaryKey().getPropertyType();
                    if (primaryType.equals(Long.TYPE)) {
                        if (!IDIStringUtils.isInteger((String)((String)supplierId))) {
                            SchemaExecutorLogger.error(String.format("supplier id error! [%s]", String.valueOf(supplierId)));
                            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u503c\u4e0d\u5b58\u5728", (String)"GeneralLedgerExecutor_5", (String)"data-idi-core", (Object[])new Object[0]));
                        }
                        supplierId = Long.valueOf((String)supplierId);
                    }
                    break block24;
                } else if ("2".equals(valueType)) {
                    if (!IDIStringUtils.isInteger((String)((String)supplierId))) {
                        SchemaExecutorLogger.error(String.format("supplier id error! [%s]", String.valueOf(supplierId)));
                        throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u503c\u4e0d\u5b58\u5728", (String)"GeneralLedgerExecutor_5", (String)"data-idi-core", (Object[])new Object[0]));
                    }
                    supplierId = Long.valueOf((String)supplierId);
                }
                break block24;
            }
            if (!(supplierId instanceof Number) || ((Number)supplierId).intValue() == 0) {
                SchemaExecutorLogger.error(String.format("supplier id error! [%s]", String.valueOf(supplierId)));
                throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u503c\u4e0d\u5b58\u5728", (String)"GeneralLedgerExecutor_5", (String)"data-idi-core", (Object[])new Object[0]));
            }
        }
        HashMap<String, Object> supplierItem = new HashMap<String, Object>();
        supplierItem.put(asstactType, supplierId);
        ArrayList<HashMap<String, Object>> supplier = new ArrayList<HashMap<String, Object>>();
        supplier.add(supplierItem);
        List<Long> accountViewIds = generalLedger.getAccountViewIds();
        if (CollectionUtils.isEmpty(accountViewIds)) {
            accountViewIds = new ArrayList<Long>(1);
            accountViewIds.add(generalLedger.getAccountId());
        }
        HashMap<Long, ArrayList<HashMap<String, Object>>> accountAssgrp = new HashMap<Long, ArrayList<HashMap<String, Object>>>(accountViewIds.size());
        for (Long accountViewId : accountViewIds) {
            accountAssgrp.put(accountViewId, supplier);
        }
        param.put("accountAssgrp", accountAssgrp);
        param.put("selector", this.balanceFields);
        String paramStr = SerializationUtils.toJsonString(param);
        String balanceResult = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"gl", (String)"BalanceService", (String)"getBalance", (Object[])new Object[]{paramStr});
        if (StringUtils.isNotEmpty((String)balanceResult) && !"null".equals(balanceResult)) {
            StatisticsResult statisticsResult = new StatisticsResult();
            statisticsResult.setHeadMode(false);
            statisticsResult.setNotTable(true);
            statisticsResult.setTitleList(new ArrayList<String>(2));
            List list = SerializationUtils.fromJsonStringToList((String)balanceResult, Map.class);
            if (list.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u6570\u636e", (String)"GeneralLedgerExecutor_6", (String)"data-idi-core", (Object[])new Object[0]));
            }
            Map accountViewMap = BusinessDataServiceHelper.loadFromCache((Object[])list.stream().map(map -> map.get("account")).toArray(), (String)"bd_accountview");
            ArrayList<List<Object>> tableData = new ArrayList<List<Object>>(8);
            Iterator iterator = list.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    statisticsResult.setDataTable(tableData);
                    DecisionResult result = new DecisionResult();
                    result.setDecision(decision);
                    result.setStatisticsResult(statisticsResult);
                    SchemaExecutorLogger.info(decision.getName() + "\nparam:" + param + "\nresult:" + result + "\ndecisionResult:" + IDIJSONUtils.toJsonString((Object)result), new Object[0]);
                    return result;
                }
                Map dataMap = (Map)iterator.next();
                Number endLocalValue = (Number)dataMap.get("endlocal");
                String endLocalStr = endLocalValue.toString();
                if ("null".equals(endLocalStr) || "0".equals(endLocalStr)) continue;
                ArrayList<String> rowData = new ArrayList<String>(2);
                rowData.add(((DynamicObject)accountViewMap.get(dataMap.get("account"))).getString("name"));
                rowData.add(ExecutorHelper.currencyToString(endLocalValue));
                tableData.add(rowData);
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u6570\u636e", (String)"GeneralLedgerExecutor_6", (String)"data-idi-core", (Object[])new Object[0]));
    }

    private DynamicObject getAccountTable(Number orgId, Number bookTypeId) {
        SchemaContext schemaContext = SchemaContext.get();
        if (schemaContext != null && schemaContext.getCurrentGLAccountTable(orgId, bookTypeId) != null) {
            return schemaContext.getCurrentGLAccountTable(orgId, bookTypeId);
        }
        QFilter orgFilter = new QFilter("org.id", "=", (Object)orgId);
        QFilter bookFilter = new QFilter("bookstype.id", "=", (Object)bookTypeId);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"gl_accountbook", (String)"accounttable.id accountTableId, periodtype.id periodTypeId", (QFilter[])new QFilter[]{orgFilter, bookFilter}, null);
        if (!collection.isEmpty()) {
            DynamicObject object = (DynamicObject)collection.get(0);
            if (schemaContext != null) {
                schemaContext.setCurrentGLAccountTable(orgId, bookTypeId, object);
            }
            return object;
        }
        return null;
    }

    private Long getCurrentPeriodByDate(Long periodType) {
        Long periodId;
        SchemaContext schemaContext = SchemaContext.get();
        if (schemaContext != null && schemaContext.getCurrentGLPeriodId(periodType) != null) {
            return schemaContext.getCurrentGLPeriodId(periodType);
        }
        Date date = KDDateUtils.today();
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        QFilter f = new QFilter("beginDate", "<=", (Object)c.getTime());
        QFilter g = new QFilter("enddate", ">=", (Object)c.getTime());
        QFilter t = new QFilter("periodtype", "=", (Object)periodType);
        DynamicObjectCollection period = QueryServiceHelper.query((String)"bd_period", (String)"id,number,name", (QFilter[])new QFilter[]{f, g, t}, (String)"number");
        if (!period.isEmpty() && (periodId = Long.valueOf(((DynamicObject)period.get(0)).getLong("id"))) != null) {
            if (schemaContext != null) {
                schemaContext.setCurrentGLPeriodId(periodType, periodId);
            }
            return periodId;
        }
        return null;
    }

    private boolean checkStartCondition(IDICondition startCondition, SchemaContext context, Object pkValue) {
        if (startCondition != null && StringUtils.isNotEmpty((String)startCondition.getScript())) {
            DynamicObject loadAllFieldObj = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)context.getEntityType());
            MainEntityType srcEntityType = EntityMetadataCache.getDataEntityType((String)context.getEntityType());
            Set<String> propSet = ScriptUtils.getEntries(srcEntityType, startCondition.getScript(), new String[]{context.getEntityType()});
            if (propSet.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u542f\u52a8\u6761\u4ef6\u4e0d\u652f\u6301\u8de8\u6e90\u5355\u7684\u591a\u4e2a\u5206\u5f55\u3002", (String)"LinkUpBillDecisionExecutor_12", (String)"data-idi-core", (Object[])new Object[0]));
            }
            HashMap<String, Object> ctx = new HashMap<String, Object>(1);
            ctx.put(context.getEntityType() + "_billObj", loadAllFieldObj);
            DynamicObjectType dynamicObjectType = loadAllFieldObj.getDynamicObjectType();
            if (propSet.size() == 1) {
                String startConditionEntry = propSet.iterator().next();
                int sourceEntrySize = loadAllFieldObj.getDynamicObjectCollection(startConditionEntry).size();
                for (int i = 0; i < sourceEntrySize; ++i) {
                    if (!this.canStart(startCondition, ctx, loadAllFieldObj, dynamicObjectType, i)) continue;
                    return true;
                }
                return false;
            }
            return this.canStart(startCondition, ctx, loadAllFieldObj, dynamicObjectType, 0);
        }
        return true;
    }

    private boolean canStart(IDICondition startCondition, Map<String, Object> ctx, DynamicObject bizObj, DynamicObjectType mainType, int entryIndex) {
        String script = startCondition.getScript();
        String entityType = mainType.getName();
        ScriptLocaleFieldHandler scriptLocaleFieldHandler = new ScriptLocaleFieldHandler();
        String localeScript = scriptLocaleFieldHandler.processLocaleField(script, new String[]{entityType}, bizObj);
        String entryScript = ScriptUtils.supportEntryProperty(mainType, localeScript, entryIndex);
        Object result = ScriptFormIdHandler.runScript(entityType, null, ctx, entryScript);
        return (Boolean)result;
    }
}

