/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.data.idi.engine.CacheManager;

public class ParamFactory {
    public static String getString(String key) {
        String cacheParamVal = CacheManager.get("param", key);
        if (cacheParamVal != null) {
            if ("<null>".equals(cacheParamVal)) {
                return null;
            }
            return cacheParamVal;
        }
        Object paramVal = ParamFactory.innerGet(key);
        if (paramVal == null) {
            CacheManager.put("param", key, "<null>");
            return null;
        }
        String valStr = paramVal.toString();
        CacheManager.put("param", key, valStr);
        return valStr;
    }

    private static Object innerGet(String key) {
        QFilter filter = new QFilter("param_key", "=", (Object)key);
        Object paramValue = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"innerGet", (String)"idi_param_config", (String)"param_key,param_val", (QFilter[])new QFilter[]{filter}, null);){
            if (dataSet != null) {
                for (Row row : dataSet) {
                    paramValue = row.get("param_val");
                }
            }
        }
        return paramValue;
    }

    public static boolean getBoolean(String key, boolean defaultVal) {
        String cacheParamVal = CacheManager.get("param", key);
        if (cacheParamVal != null) {
            if ("<null>".equals(cacheParamVal)) {
                return defaultVal;
            }
            return "true".equals(cacheParamVal);
        }
        Object paramVal = ParamFactory.innerGet(key);
        if (paramVal == null) {
            CacheManager.put("param", key, "<null>");
            return defaultVal;
        }
        CacheManager.put("param", key, paramVal.toString());
        return "true".equals(paramVal);
    }

    public static int getInt(String key, int defaultVal) {
        String cacheParamVal = CacheManager.get("param", key);
        if (cacheParamVal != null) {
            if ("<null>".equals(cacheParamVal)) {
                return defaultVal;
            }
            return Integer.parseInt(cacheParamVal);
        }
        Object paramVal = ParamFactory.innerGet(key);
        if (paramVal == null) {
            CacheManager.put("param", key, "<null>");
            return defaultVal;
        }
        CacheManager.put("param", key, paramVal.toString());
        return Integer.parseInt(paramVal.toString());
    }

    public static int getTimeOut() {
        return ParamFactory.getInt("timeout", 5000);
    }

    public static int getReadTimeOut() {
        return ParamFactory.getInt("readtimeout", 180000);
    }

    public static DynamicObject getParam(String key) {
        QFilter filter = new QFilter("param_key", "=", (Object)key);
        return QueryServiceHelper.queryOne((String)"idi_param_config", (String)"param_key,param_desc,param_val", (QFilter[])new QFilter[]{filter});
    }

    public static int getNumbAll() {
        return ParamFactory.getInt("numb_all", 500);
    }

    public static int getNumbClassification() {
        return ParamFactory.getInt("numb_classification", 50);
    }
}

