/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine.customrule;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;

public class EntryRowRelationDTO {
    private String entryFlag;
    private String targetEntryFlag;
    private Map<String, DynamicObjectCollection> entryCollectionMap = new HashMap<String, DynamicObjectCollection>(10);
    private LinkedHashMap<Integer, Set<Integer>> entryIdMap = new LinkedHashMap(10);
    private boolean trueSubEntry = false;
    private Map<String, String> subParentEntryMap = new HashMap<String, String>(10);
    private Map<Integer, DynamicObjectCollection> trueSubEntryCollectionMap = new HashMap<Integer, DynamicObjectCollection>(10);
    Map<String, Map<Integer, Integer>> parentEntryIndexMap = new HashMap<String, Map<Integer, Integer>>(4);

    public String getEntryFlag() {
        return this.entryFlag;
    }

    public void setEntryFlag(String entryFlag) {
        this.entryFlag = entryFlag;
    }

    public String getTargetEntryFlag() {
        return this.targetEntryFlag;
    }

    public void setTargetEntryFlag(String targetEntryFlag) {
        this.targetEntryFlag = targetEntryFlag;
    }

    public LinkedHashMap<Integer, Set<Integer>> getEntryIdMap() {
        return this.entryIdMap;
    }

    public void setEntryIdMap(LinkedHashMap<Integer, Set<Integer>> entryIdMap) {
        this.entryIdMap = entryIdMap;
    }

    public void addEntryIdMap(Integer index, Integer targetIndex) {
        if (this.entryIdMap == null) {
            this.entryIdMap = new LinkedHashMap(10);
        }
        if (this.entryIdMap.get(index) == null) {
            this.entryIdMap.put(index, new HashSet<Integer>(Collections.singletonList(targetIndex)));
        } else {
            this.entryIdMap.get(index).add(targetIndex);
        }
    }

    public boolean matchEntry(String entryNumber) {
        return this.entryFlag.equals(entryNumber) || this.targetEntryFlag.equals(entryNumber);
    }

    public Integer getDataCount() {
        int dataCount = 0;
        for (Set<Integer> value : this.entryIdMap.values()) {
            dataCount += value.size();
        }
        return dataCount;
    }

    public boolean isTrueSubEntry() {
        return this.trueSubEntry;
    }

    public void setTrueSubEntry(boolean trueSubEntry) {
        this.trueSubEntry = trueSubEntry;
    }

    public void addSubParentEntryMap(String subEntry, String parentEntry) {
        if (this.subParentEntryMap == null) {
            this.subParentEntryMap = new HashMap<String, String>(10);
        }
        this.subParentEntryMap.put(subEntry, parentEntry);
    }

    public Map<String, DynamicObjectCollection> getEntryCollectionMap() {
        return this.entryCollectionMap;
    }

    public void setEntryCollectionMap(Map<String, DynamicObjectCollection> entryCollectionMap) {
        this.entryCollectionMap = entryCollectionMap;
    }

    public Map<String, String> getSubParentEntryMap() {
        return this.subParentEntryMap;
    }

    public void setSubParentEntryMap(Map<String, String> subParentEntryMap) {
        this.subParentEntryMap = subParentEntryMap;
    }

    public Map<Integer, DynamicObjectCollection> getTrueSubEntryCollectionMap() {
        return this.trueSubEntryCollectionMap;
    }

    public void setTrueSubEntryCollectionMap(Map<Integer, DynamicObjectCollection> trueSubEntryCollectionMap) {
        this.trueSubEntryCollectionMap = trueSubEntryCollectionMap;
    }

    public void addEntryCollectionMap(String entryNumber, DynamicObjectCollection entryCollection) {
        if (this.entryCollectionMap == null) {
            this.entryCollectionMap = new HashMap<String, DynamicObjectCollection>(10);
        }
        this.entryCollectionMap.put(entryNumber, entryCollection);
    }

    public void addTrueSubEntryCollection(Integer index, DynamicObjectCollection subCollection) {
        if (this.trueSubEntryCollectionMap == null) {
            this.trueSubEntryCollectionMap = new HashMap<Integer, DynamicObjectCollection>(10);
        }
        this.trueSubEntryCollectionMap.put(index, subCollection);
    }

    public Map<String, Map<Integer, Integer>> getParentEntryIndexMap() {
        return this.parentEntryIndexMap;
    }

    public void setParentEntryIndexMap(Map<String, Map<Integer, Integer>> parentEntryIndexMap) {
        this.parentEntryIndexMap = parentEntryIndexMap;
    }

    public void addParentEntryIndexMap(String parentEntryNumber, DynamicObjectCollection subEntryCollection, int parentEntryIndex) {
        Map subParentIndexMap = this.parentEntryIndexMap.computeIfAbsent(parentEntryNumber, k -> new HashMap(10));
        int max = subParentIndexMap.size();
        for (int i = 0; i < subEntryCollection.size(); ++i) {
            subParentIndexMap.put(max++, parentEntryIndex);
        }
    }

    public DynamicObjectCollection gatherSubEntryData(DynamicObject srcBillObj, String parentNumber, String subEntryNumber, DynamicObjectCollection gatherEntry) {
        this.addSubParentEntryMap(subEntryNumber, parentNumber);
        DynamicObjectCollection parentCollection = srcBillObj.getDynamicObjectCollection(parentNumber);
        for (int i = 0; i < parentCollection.size(); ++i) {
            DynamicObject parent = (DynamicObject)parentCollection.get(i);
            if (gatherEntry == null) {
                gatherEntry = new DynamicObjectCollection();
            }
            DynamicObjectCollection subEntry = parent.getDynamicObjectCollection(subEntryNumber);
            this.addParentEntryIndexMap(parentNumber, subEntry, i);
            gatherEntry.addAll((Collection)subEntry);
        }
        return gatherEntry;
    }
}

