/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine.linkupbill;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.util.CollectionUtils;
import kd.data.idi.engine.linkupbill.EntryAndMulItem;
import kd.data.idi.engine.linkupbill.EntryTypeEnum;

public class MulEntryValidator {
    private List<EntryAndMulItem> currentToParentList = new ArrayList<EntryAndMulItem>(10);
    private MainEntityType mainType;

    public MulEntryValidator(MainEntityType mainType) {
        this.mainType = mainType;
    }

    public boolean validate() {
        Map<EntryTypeEnum, List<EntryAndMulItem>> classifyMap = this.currentToParentList.stream().collect(Collectors.groupingBy(EntryAndMulItem::getType));
        List<EntryAndMulItem> entryList = classifyMap.get((Object)EntryTypeEnum.BILLENTRY);
        if (CollectionUtils.isNotEmpty(entryList) && entryList.size() > 1) {
            return false;
        }
        List<EntryAndMulItem> subEntryList = classifyMap.get((Object)EntryTypeEnum.BILLSUBENTYPE);
        if (CollectionUtils.isNotEmpty(subEntryList)) {
            if (subEntryList.size() > 1) {
                return false;
            }
            EntryAndMulItem subEntry = subEntryList.get(0);
            EntryAndMulItem entry = entryList.get(0);
            if (!entry.getEntryKey().equals(subEntry.getParentEntry())) {
                return false;
            }
        }
        return true;
    }

    public void addSubEntry(String subEntryKey, String parentEntry) {
        if (CollectionUtils.isNotEmpty(this.currentToParentList)) {
            Optional<EntryAndMulItem> entryAndMulItem = this.currentToParentList.stream().filter(eam -> eam.getEntryKey().equals(subEntryKey) && eam.getParentEntry().equals(parentEntry)).findAny();
            if (!entryAndMulItem.isPresent()) {
                this.currentToParentList.add(new EntryAndMulItem(subEntryKey, parentEntry, EntryTypeEnum.BILLSUBENTYPE));
            }
        } else {
            this.currentToParentList.add(new EntryAndMulItem(subEntryKey, parentEntry, EntryTypeEnum.BILLSUBENTYPE));
        }
    }

    public void addEntry(String entryKey, String parentKey) {
        if (CollectionUtils.isNotEmpty(this.currentToParentList)) {
            Optional<EntryAndMulItem> entryAndMulItem = this.currentToParentList.stream().filter(eam -> eam.getEntryKey().equals(entryKey) && eam.getParentEntry().equals(parentKey)).findAny();
            if (!entryAndMulItem.isPresent()) {
                this.currentToParentList.add(new EntryAndMulItem(entryKey, parentKey, EntryTypeEnum.BILLENTRY));
            }
        } else {
            this.currentToParentList.add(new EntryAndMulItem(entryKey, parentKey, EntryTypeEnum.BILLENTRY));
        }
    }

    public void addEntry(DynamicProperty property) {
        if (property.getParent() != null && property.getParent().getName().equals(this.mainType.getName())) {
            this.addEntry(property.getName(), property.getParent().getName());
        } else {
            this.addSubEntry(property.getName(), property.getParent().getName());
        }
    }

    public boolean isHead() {
        return this.currentToParentList.isEmpty();
    }

    public boolean hasSubEntry() {
        if (this.isHead()) {
            return false;
        }
        Optional<EntryAndMulItem> data = this.currentToParentList.stream().filter(entryAndMulItem -> entryAndMulItem.getType() == EntryTypeEnum.BILLSUBENTYPE).findAny();
        return data.isPresent();
    }

    public String getEntryName() {
        Optional<EntryAndMulItem> entryData;
        if (!this.isHead() && (entryData = this.currentToParentList.stream().filter(entryAndMulItem -> entryAndMulItem.getType() == EntryTypeEnum.BILLENTRY).findAny()).isPresent()) {
            return entryData.get().getEntryKey();
        }
        return null;
    }

    public String getSubEntryName() {
        Optional<EntryAndMulItem> subEntryData;
        if (!this.isHead() && (subEntryData = this.currentToParentList.stream().filter(entryAndMulItem -> entryAndMulItem.getType() == EntryTypeEnum.BILLSUBENTYPE).findAny()).isPresent()) {
            return subEntryData.get().getEntryKey();
        }
        return null;
    }
}

