/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.export;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.data.idi.engine.SchemaExecutorLogger;

public interface IDataExImport {
    public String getKey();

    default public String getTip() {
        return this.getKey();
    }

    public Object loadData();

    default public String exportToString() {
        Object obj = this.loadData();
        if (obj != null) {
            return this.getKey() + SerializationUtils.serializeToBase64((Object)obj);
        }
        return this.getKey();
    }

    default public void importString(String dynBase64) {
        if (dynBase64.startsWith(this.getKey())) {
            try {
                this.parseImport(dynBase64.substring(this.getKey().length()));
            }
            catch (KDBizException ex) {
                throw ex;
            }
            catch (KDException ex) {
                throw new KDBizException(ex.getMessage());
            }
            catch (Exception ex) {
                String error = ResManager.loadKDString((String)"\u89e3\u6790\u5bfc\u5165\u6587\u4ef6\u53d1\u751f\u9519\u8bef:", (String)"IDataExImport_1", (String)"data-idi-core", (Object[])new Object[0]);
                SchemaExecutorLogger.error(error + this.getTip(), ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u89e3\u6790\u5bfc\u5165\u7684\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9\u662f\u5426\u88ab\u4fee\u6539\u8fc7\u3002", (String)"IDataExImport_0", (String)"data-idi-core", (Object[])new Object[0]));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u89e3\u6790\u5bfc\u5165\u7684\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9\u662f\u5426\u88ab\u4fee\u6539\u8fc7\u3002", (String)"IDataExImport_0", (String)"data-idi-core", (Object[])new Object[0]));
        }
    }

    public void parseImport(String var1);

    default public <T> T deSerialize(String dynBase64) {
        return (T)SerializationUtils.deSerializeFromBase64((String)dynBase64);
    }

    default public void afterExecuteSave(boolean success, DynamicObject dynamicObject) {
    }
}

